/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export;

import com.agfa.pacs.data.dicom.DicomException;
import com.agfa.pacs.data.dicom.comm.DicomCStoreSCU;
import com.agfa.pacs.data.dicom.comm.DicomCompositeCStoreSCU;
import com.agfa.pacs.data.export.ImageObject;
import com.agfa.pacs.data.export.Messages;
import com.agfa.pacs.data.export.ProcessingExceptionMessageFactory;
import com.agfa.pacs.data.shared.NodeProperty;
import com.agfa.pacs.data.shared.data.IDicomDataListener;
import com.agfa.pacs.data.shared.data.OutputStreamDicomDataWriter;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.dicom.UIDMap;
import com.agfa.pacs.data.shared.export.IProcessingElement;
import com.agfa.pacs.data.shared.export.ProcessingException;
import com.agfa.pacs.data.shared.export.ProcessingProperty;
import com.agfa.pacs.data.shared.export.ProcessingWarning;
import com.agfa.pacs.data.shared.pixel.IPixelDataInfo;
import com.agfa.pacs.logging.ALogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.DataWriter;
import org.dcm4che3.net.PDVOutputStream;

public class CStore
implements IProcessingElement {
    private static final ALogger log = ALogger.getLogger(CStore.class);
    public static final String STREAM_LENGTH = "STREAM_LENGTH";
    public static final String DICOM_STORE_TARGET = "DICOM_STORE_TARGET";
    public static final String ONLY_WARN_ON_FAILURE = "CSTORE_ONLY_WARN_ON_FAILURE";
    private DicomCStoreSCU cstore;
    private IDicomNode dicomNode;
    private UIDMap uidMap;
    private boolean onlyWarnOnFailure = false;

    public void finishProcessing() {
        if (this.cstore != null) {
            try {
                this.cstore.close();
            }
            catch (DicomException dicomException) {
                log.error("Exception on close", (Throwable)dicomException);
            }
        }
    }

    public void cleanUp() {
        this.dicomNode = null;
        this.cstore = null;
        this.uidMap = null;
    }

    public String getErrorMessage() {
        return null;
    }

    public void prepareProcessing(Properties properties, List<? extends Object> list) throws ProcessingException {
        if (!properties.containsKey(DICOM_STORE_TARGET)) {
            throw new IllegalArgumentException("No target specified");
        }
        this.dicomNode = (IDicomNode)properties.get(DICOM_STORE_TARGET);
        this.uidMap = properties.containsKey("UID_MAP") ? (UIDMap)properties.get("UID_MAP") : new UIDMap();
        if (properties.containsKey(ONLY_WARN_ON_FAILURE)) {
            this.onlyWarnOnFailure = (Boolean)properties.get(ONLY_WARN_ON_FAILURE);
        }
        try {
            this.checkConnection();
            this.uidMap.replaceByUIDMap(this.cstore.getSupportedUIDs());
            this.releaseConnection();
        }
        catch (DicomException dicomException) {
            log.error("Could not initiate dicom connection", (Throwable)dicomException);
            throw new ProcessingException("Could not initiate dicom connection", Messages.getString("CStore.Fail"), (Throwable)dicomException);
        }
    }

    public Object process(Object object) throws ProcessingException {
        if (object instanceof ImageObject) {
            ImageObject imageObject = (ImageObject)object;
            Attributes attributes = imageObject.getDataset();
            try {
                try {
                    this.checkConnection();
                    String string = attributes.getString(524310);
                    String string2 = attributes.getString(524312);
                    String string3 = attributes.getString(131088);
                    this.cstore.store(string, string2, string3, (DataWriter)new PrivateDataWriter(string2, imageObject));
                }
                catch (Exception exception) {
                    String string = "Could not perform cstore";
                    log.error(string, (Throwable)exception);
                    if (this.onlyWarnOnFailure) {
                        throw new ProcessingWarning(string, Messages.getString("CStore.Fail"), (Throwable)exception);
                    }
                    throw new ProcessingException(string, ProcessingExceptionMessageFactory.getProcessingExceptionMessage("export.errorCStore", imageObject), (Throwable)exception);
                }
            }
            finally {
                this.releaseConnection();
            }
            return attributes;
        }
        throw new IllegalArgumentException("Wrong input object");
    }

    private void checkConnection() throws DicomException {
        if (this.cstore == null) {
            this.cstore = new DicomCompositeCStoreSCU(this.dicomNode, this.uidMap);
        }
        if (this.cstore.isConnected()) {
            return;
        }
        this.cstore.connect();
    }

    private void releaseConnection() {
        if (!this.dicomNode.isEnabled(NodeProperty.KeepAlive) && this.cstore != null) {
            try {
                this.cstore.close();
            }
            catch (DicomException dicomException) {
                log.error("Exception on close", (Throwable)dicomException);
            }
        }
    }

    public ProcessingProperty[] queryProperties() {
        ProcessingProperty[] processingPropertyArray = new ProcessingProperty[]{new ProcessingProperty(DICOM_STORE_TARGET, IDicomNode.class, null)};
        return processingPropertyArray;
    }

    public boolean supportsConcurrentProcessing() {
        return false;
    }

    private static class PrivateDataWriter
    implements DataWriter {
        private final ImageObject image;
        private final String instanceUID;

        public PrivateDataWriter(String string, ImageObject imageObject) {
            this.image = imageObject;
            this.instanceUID = string;
        }

        public void writeTo(PDVOutputStream pDVOutputStream, String string) throws IOException {
            OutputStreamDicomDataWriter outputStreamDicomDataWriter = new OutputStreamDicomDataWriter((OutputStream)pDVOutputStream, false);
            outputStreamDicomDataWriter.dicomDataAvailable(this.instanceUID, this.image.getDataset(), this.image.getFrameCount() > 0);
            int n = 0;
            while (n < this.image.getFrameCount()) {
                IPixelDataInfo iPixelDataInfo = this.image.getFrame(n);
                if (iPixelDataInfo.getDataClass() == InputStream.class) {
                    long l = (Long)iPixelDataInfo.getDescription().getProperty(CStore.STREAM_LENGTH, (Object)0L);
                    outputStreamDicomDataWriter.streamEncapsulatedPixelData((InputStream)iPixelDataInfo.getData(), (int)l);
                } else {
                    outputStreamDicomDataWriter.pixelDataAvailable(this.instanceUID, this.image.getFrame(n), n);
                }
                ++n;
            }
            outputStreamDicomDataWriter.dicomDataFinished(this.instanceUID, IDicomDataListener.Status.Success, this.image.getPostPixelDataset());
            pDVOutputStream.flush();
        }
    }
}

