/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.event.dispatch.exp;

import com.agfa.pacs.event.IEvent;
import com.agfa.pacs.event.IEventListener;
import com.agfa.pacs.event.IUndoInformation;
import com.agfa.pacs.event.ListenerSynchronization;
import com.agfa.pacs.event.context.EventPropagatedContextManager;
import com.agfa.pacs.event.dispatch.exp.InteruptableThread;
import com.agfa.pacs.event.dispatch.exp.StackSet;
import com.agfa.pacs.event.internal.Event;
import com.agfa.pacs.event.internal.Transfer;
import com.agfa.pacs.event.internal.debug.DebugStreamFactory;
import com.agfa.pacs.event.internal.debug.IDebugStream;
import com.agfa.pacs.event.internal.debug.ThreadLocalDebugStream;
import com.agfa.pacs.event.internal.processor.ProcessorFrame;
import com.agfa.pacs.event.internal.task.Task;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.ExceptionDialogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;

public class TaskProcessor
extends InteruptableThread {
    private static final ALogger LOGGER = ALogger.getLogger(TaskProcessor.class);
    private static final boolean DEBUG = DebugStreamFactory.isDebugEnabled();
    private IDebugStream dbgStream;
    protected final BlockingQueue<Task> src;
    protected final StackSet set;
    protected final List<StackSet> stack;
    protected final List<ProcessorFrame> frames = new ArrayList<ProcessorFrame>();
    protected Event eventHistory = null;
    protected IEventListener senderHistory = null;
    protected boolean framesDirty = false;
    protected long dbgTakeCount = 0L;
    private Task t;
    private boolean listenerSyncAcquired;
    private ListenerSynchronization liSync;

    public TaskProcessor(String string, BlockingQueue<Task> blockingQueue, StackSet stackSet, List<StackSet> list) {
        this.setName("TaskProcessor " + string);
        this.src = blockingQueue;
        this.set = stackSet;
        this.stack = list;
    }

    @Override
    public void run() {
        if (DEBUG) {
            this.dbgStream = ThreadLocalDebugStream.get();
        }
        while (this.isRunning()) {
            this.fetchNextTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fetchNextTask() {
        block52: {
            block51: {
                Throwable throwable3;
                block54: {
                    int n;
                    block55: {
                        int n2;
                        int n3;
                        try {
                            block53: {
                                try {
                                    this.t = null;
                                    this.liSync = null;
                                    this.listenerSyncAcquired = false;
                                    this.t = (Task)this.src.poll();
                                    if (this.t == null) {
                                        if (DEBUG) {
                                            this.dbgStream.debug("Writing back cache (as Task queue is empty)");
                                        }
                                        this.writeBackCache();
                                        this.t = this.src.take();
                                    }
                                    ++this.dbgTakeCount;
                                    this.eventHistory = this.t.e;
                                    this.senderHistory = this.t.l;
                                    if (this.t.e.senderLocalContext != null) {
                                        EventPropagatedContextManager.create().putAll(this.t.e.senderLocalContext);
                                    }
                                    this.liSync = (ListenerSynchronization)this.t.l.getSync();
                                    if (DEBUG) {
                                        this.dbgStream.fdebug("*************\nPROCESSING task: %s, listener synchronization: %s", new Object[]{this.t, this.liSync});
                                    }
                                    if (this.liSync != null) {
                                        this.listenerSyncAcquired = this.liSync.checkBypass((IEvent)this.t.e);
                                        if (DEBUG) {
                                            this.dbgStream.sdebug("Listener synchronization lock acquired: %s", new Object[]{this.listenerSyncAcquired});
                                        }
                                    }
                                    if (this.t.e.isUndoEvent()) {
                                        this.t.l.handleUndoEvent((IEvent)this.t.e, (IUndoInformation)this.t.u);
                                    } else {
                                        this.t.l.handleEvent((IEvent)this.t.e, (IUndoInformation)this.t.u);
                                    }
                                    break block51;
                                }
                                catch (Throwable throwable2) {
                                    LOGGER.error("Exception in TaskProcessor:\n", throwable2);
                                    if (this.t != null) {
                                        LOGGER.error(this.t.toString());
                                        LOGGER.error(this.t.e.toString());
                                    }
                                    ExceptionDialogUtils.displayExceptionToUser((Throwable)throwable2);
                                    if (this.t == null) break block52;
                                    EventPropagatedContextManager.disposeContext();
                                    if (this.frames.size() >= this.stack.size()) break block53;
                                    List<StackSet> list = this.stack;
                                    synchronized (list) {
                                        while (this.frames.size() < this.stack.size()) {
                                            this.frames.add(new ProcessorFrame(this.stack.get((int)this.frames.size()).virtualParallelTasks));
                                        }
                                    }
                                }
                            }
                            this.eventHistory = null;
                            this.senderHistory = null;
                            n3 = this.t.e.stackDepth;
                        }
                        catch (Throwable throwable3) {
                            if (this.t == null) break block54;
                            EventPropagatedContextManager.disposeContext();
                            if (this.frames.size() >= this.stack.size()) break block55;
                            List<StackSet> list = this.stack;
                            synchronized (list) {
                                while (this.frames.size() < this.stack.size()) {
                                    this.frames.add(new ProcessorFrame(this.stack.get((int)this.frames.size()).virtualParallelTasks));
                                }
                            }
                        }
                        this.liSync = (ListenerSynchronization)this.t.l.getSync();
                        if (this.liSync != null) {
                            this.liSync.releaseTask(this.frames, n3);
                        }
                        if (this.listenerSyncAcquired) {
                            n2 = this.liSync.release();
                            if (DEBUG) {
                                this.dbgStream.sdebug("Released permit from liSyncSem [%s]", new Object[]{n2});
                            }
                        }
                        if (this.t.e.transfer == Transfer.STREAMED) {
                            n2 = this.stack.get((int)n3).streamSem.V();
                            if (DEBUG) {
                                this.dbgStream.sdebug("Released permit from StackSet[%s].streamSem [%s]", new Object[]{n3, n2});
                            }
                        }
                        if (this.t.e.syncSem != null) {
                            n2 = this.t.e.syncSem.V();
                            if (DEBUG) {
                                this.dbgStream.sdebug("Released permit from syncSem [%s]", new Object[]{n2});
                            }
                        }
                        ++this.frames.get((int)n3).flushSemLocalCount;
                        if (DEBUG) {
                            this.dbgStream.sdebug("Increased ProcessorFrame[%s].flushSemLocalCount [%s]", new Object[]{n3, this.frames.get((int)n3).flushSemLocalCount});
                        }
                        this.t.e = null;
                        this.t.l = null;
                        this.t.u.disposed();
                        this.t.clearForDeletion = true;
                        this.framesDirty = true;
                        break block52;
                    }
                    this.eventHistory = null;
                    this.senderHistory = null;
                    int n4 = this.t.e.stackDepth;
                    this.liSync = (ListenerSynchronization)this.t.l.getSync();
                    if (this.liSync != null) {
                        this.liSync.releaseTask(this.frames, n4);
                    }
                    if (this.listenerSyncAcquired) {
                        n = this.liSync.release();
                        if (DEBUG) {
                            this.dbgStream.sdebug("Released permit from liSyncSem [%s]", new Object[]{n});
                        }
                    }
                    if (this.t.e.transfer == Transfer.STREAMED) {
                        n = this.stack.get((int)n4).streamSem.V();
                        if (DEBUG) {
                            this.dbgStream.sdebug("Released permit from StackSet[%s].streamSem [%s]", new Object[]{n4, n});
                        }
                    }
                    if (this.t.e.syncSem != null) {
                        n = this.t.e.syncSem.V();
                        if (DEBUG) {
                            this.dbgStream.sdebug("Released permit from syncSem [%s]", new Object[]{n});
                        }
                    }
                    ++this.frames.get((int)n4).flushSemLocalCount;
                    if (DEBUG) {
                        this.dbgStream.sdebug("Increased ProcessorFrame[%s].flushSemLocalCount [%s]", new Object[]{n4, this.frames.get((int)n4).flushSemLocalCount});
                    }
                    this.t.e = null;
                    this.t.l = null;
                    this.t.u.disposed();
                    this.t.clearForDeletion = true;
                    this.framesDirty = true;
                }
                throw throwable3;
            }
            if (this.t != null) {
                int n;
                EventPropagatedContextManager.disposeContext();
                if (this.frames.size() < this.stack.size()) {
                    List<StackSet> list = this.stack;
                    synchronized (list) {
                        while (this.frames.size() < this.stack.size()) {
                            this.frames.add(new ProcessorFrame(this.stack.get((int)this.frames.size()).virtualParallelTasks));
                        }
                    }
                }
                this.eventHistory = null;
                this.senderHistory = null;
                int n5 = this.t.e.stackDepth;
                this.liSync = (ListenerSynchronization)this.t.l.getSync();
                if (this.liSync != null) {
                    this.liSync.releaseTask(this.frames, n5);
                }
                if (this.listenerSyncAcquired) {
                    n = this.liSync.release();
                    if (DEBUG) {
                        this.dbgStream.sdebug("Released permit from liSyncSem [%s]", new Object[]{n});
                    }
                }
                if (this.t.e.transfer == Transfer.STREAMED) {
                    n = this.stack.get((int)n5).streamSem.V();
                    if (DEBUG) {
                        this.dbgStream.sdebug("Released permit from StackSet[%s].streamSem [%s]", new Object[]{n5, n});
                    }
                }
                if (this.t.e.syncSem != null) {
                    n = this.t.e.syncSem.V();
                    if (DEBUG) {
                        this.dbgStream.sdebug("Released permit from syncSem [%s]", new Object[]{n});
                    }
                }
                ++this.frames.get((int)n5).flushSemLocalCount;
                if (DEBUG) {
                    this.dbgStream.sdebug("Increased ProcessorFrame[%s].flushSemLocalCount [%s]", new Object[]{n5, this.frames.get((int)n5).flushSemLocalCount});
                }
                this.t.e = null;
                this.t.l = null;
                this.t.u.disposed();
                this.t.clearForDeletion = true;
                this.framesDirty = true;
            }
        }
        return true;
    }

    public void writeBackCache() {
        if (this.framesDirty) {
            int n = this.frames.size();
            int n2 = 0;
            while (n2 < n) {
                ProcessorFrame processorFrame = this.frames.get(n2);
                if (processorFrame.flushSemLocalCount != 0) {
                    StackSet stackSet = this.stack.get(n2);
                    int n3 = stackSet.flushSem.V(processorFrame.flushSemLocalCount);
                    int n4 = stackSet.orderedSem.V(processorFrame.flushSemLocalCount);
                    if (DEBUG) {
                        this.dbgStream.sdebug("Write back: Released permits from StackSet[%s].flushSemCount [%s]", new Object[]{n2, n3});
                        this.dbgStream.sdebug("Write back: Released permits from StackSet[%s].orderedSemCount [%s]", new Object[]{n2, n4});
                    }
                    processorFrame.flushSemLocalCount = 0;
                }
                ++n2;
            }
            this.framesDirty = false;
        }
    }

    public int getStackDepth() {
        return this.set.getStackDepth();
    }

    public long getTakeCount() {
        return this.dbgTakeCount;
    }

    public Event getCurrentEvent() {
        return this.eventHistory;
    }
}

