/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.event.internal.registry;

import com.agfa.pacs.event.IEvent;
import com.agfa.pacs.event.IEventListener;
import com.agfa.pacs.event.IEventListenerProvider;
import com.agfa.pacs.event.internal.registry.ElProvItr;
import com.agfa.pacs.event.internal.registry.ElProvNode;
import com.agfa.pacs.tools.IterableIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;

public class ElProvTree
implements IEventListenerProvider<IEventListener> {
    protected ElProvNode root = new ElProvNode(null);
    protected HashMap<IEventListenerProvider<IEventListener>, String> inverseLookup = new HashMap();

    public boolean contains(IEventListenerProvider<IEventListener> iEventListenerProvider) {
        return this.inverseLookup.containsKey(iEventListenerProvider);
    }

    public boolean register(IEventListenerProvider<IEventListener> iEventListenerProvider, String string) {
        if (this.contains(iEventListenerProvider)) {
            return false;
        }
        this.inverseLookup.put(iEventListenerProvider, string);
        if (string == null) {
            this.root.add(iEventListenerProvider);
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            this.root.append(stringTokenizer, iEventListenerProvider, string);
        }
        return true;
    }

    public boolean unregister(IEventListenerProvider<?> iEventListenerProvider) {
        if (!this.inverseLookup.containsKey(iEventListenerProvider)) {
            return false;
        }
        String string = this.inverseLookup.remove(iEventListenerProvider);
        if (string == null) {
            this.root.remove(iEventListenerProvider);
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            this.root.removeRek(stringTokenizer, iEventListenerProvider);
        }
        return true;
    }

    public boolean unregister(String string) {
        ArrayList<IEventListenerProvider<IEventListener>> arrayList;
        if (string == null) {
            arrayList = this.root.remove();
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            arrayList = this.root.remove(stringTokenizer);
        }
        if (arrayList == null) {
            return false;
        }
        int n = 0;
        while (n < arrayList.size()) {
            this.inverseLookup.remove(arrayList.get(n));
            ++n;
        }
        return true;
    }

    public IEventListenerProvider<IEventListener> getNode(String string) {
        if (string == null) {
            return this.root;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        return this.root.get(stringTokenizer);
    }

    public Iterator<IEventListener> iterator() {
        return new IterableIterator(this.inverseLookup.keySet().iterator());
    }

    public Iterator<IEventListener> iterator(IEvent iEvent, String string) {
        return new ElProvItr(this.root, iEvent, string);
    }

    public String getContent() {
        if (this.root == null) {
            return "empty";
        }
        StringBuffer stringBuffer = new StringBuffer("\n");
        this.root.getContent(stringBuffer, "");
        return stringBuffer.toString();
    }
}

