/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.event.internal.lazy;

import com.agfa.pacs.event.EventEngine;
import com.agfa.pacs.event.IEvent;
import com.agfa.pacs.event.IEventListener;
import com.agfa.pacs.event.IEventListenerProvider;
import com.agfa.pacs.logging.ALogger;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class LazyListenerProvider
implements IEventListenerProvider<IEventListener> {
    private IConfigurationElement ce;
    private IEventListener el;
    private static final ALogger logger = ALogger.getLogger(LazyListenerProvider.class);

    public LazyListenerProvider(IConfigurationElement iConfigurationElement) {
        this.ce = iConfigurationElement;
    }

    public Iterator<IEventListener> iterator() {
        if (this.ce != null) {
            this.wakeup(null);
        }
        return new Itr(this.el);
    }

    public Iterator<IEventListener> iterator(IEvent iEvent, String string) {
        if (this.ce != null) {
            this.wakeup(iEvent);
        }
        return new Itr(this.el);
    }

    protected void wakeup(IEvent iEvent) {
        Lock lock = EventEngine.registry.getLock().writeLock();
        lock.lock();
        try {
            try {
                if (this.ce != null) {
                    EventEngine.registry.enableDeferredRegistration();
                    this.el = (IEventListener)this.ce.createExecutableExtension("class");
                    if (logger.isDebugEnabled()) {
                        logger.debug("lazy listener creation: " + this.ce.getDeclaringExtension().getLabel() + " >because of> " + iEvent);
                    }
                    this.ce = null;
                }
            }
            catch (CoreException coreException) {
                logger.error("error during wakeup", (Throwable)coreException);
                lock.unlock();
            }
        }
        finally {
            lock.unlock();
        }
    }

    public String toString() {
        String string = "LazyLiProvInst[";
        string = this.ce != null ? String.valueOf(string) + this.ce.getDeclaringExtension().getLabel() : String.valueOf(string) + this.el;
        string = String.valueOf(string) + "]";
        return string;
    }

    public static class Itr
    implements Iterator<IEventListener> {
        private IEventListener itrEl;

        public Itr(IEventListener iEventListener) {
            this.itrEl = iEventListener;
        }

        @Override
        public boolean hasNext() {
            return this.itrEl != null;
        }

        @Override
        public IEventListener next() {
            IEventListener iEventListener = this.itrEl;
            this.itrEl = null;
            return iEventListener;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

