/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.event.internal.debug;

import com.agfa.pacs.event.internal.debug.IDebugStream;
import com.agfa.pacs.event.internal.debug.format.CollectionFormatter;
import com.agfa.pacs.event.internal.debug.format.FormatterFactory;
import com.agfa.pacs.event.internal.debug.format.IFormatter;
import com.agfa.pacs.logging.ALogger;
import java.io.IOException;
import java.util.Collection;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.spi.LoggingEvent;

public class Log4JDebugStream
implements IDebugStream {
    private static final ALogger LOGGER = ALogger.getLogger(Log4JDebugStream.class);
    public static final String DEBUG_LOGGER_NAME = "eventengine.debug.logger";
    private static final String DEBUG_APPENDER_PREFIX = "eventengine.debug.appender.";
    private static final String DEFAULT_DEBUG_APPENDER_FILE_SUFFIX = ".log";
    private static final boolean DEFAULT_DEBUG_APPENDER_FILE_APPEND = true;
    private static final int DEFAULT_DEBUG_APPENDER_BACKUPFILES = 3;
    private static final String DEFAULT_DEBUG_THREAD_APPENDER_LAYOUT = "%d %m%n";
    private static final String DEFAULT_DEBUG_CLASS_APPENDER_LAYOUT = "%d (%t) %m%n";
    private final Logger logger;
    private Appender appender;
    private final String name;
    private final boolean isThreadDebugStream;
    private final boolean enabled;

    public Log4JDebugStream(String string, boolean bl) {
        this.name = string.replaceAll("[ ]", "");
        this.isThreadDebugStream = bl;
        this.logger = Logger.getLogger((String)DEBUG_LOGGER_NAME);
        this.appender = this.logger.getAppender(DEBUG_APPENDER_PREFIX + this.name);
        if (this.appender == null) {
            LOGGER.info("Did not find configured Log4J appender for Event Engine debug stream " + this.name);
            this.appender = this.createDefaultLog4JAppender();
            if (this.appender != null) {
                this.logger.addAppender(this.appender);
            }
        }
        this.enabled = this.logger.isDebugEnabled() && this.appender != null;
    }

    @Override
    public void debug(String string, String string2) {
        if (this.enabled) {
            if (string != null) {
                string2 = String.format("[%s] %s", string, string2);
            }
            this.appender.doAppend(new LoggingEvent(this.name, (Category)this.logger, (Priority)Level.DEBUG, (Object)string2, null));
        }
    }

    @Override
    public void sdebug(String string, String string2, Object ... objectArray) {
        if (this.enabled) {
            if (string != null) {
                string2 = String.format("[%s] %s", string, string2);
            }
            String string3 = String.format(string2, objectArray);
            this.appender.doAppend(new LoggingEvent(this.name, (Category)this.logger, (Priority)Level.DEBUG, (Object)string3, null));
        }
    }

    @Override
    public void fdebug(String string, String string2, Object ... objectArray) {
        if (this.enabled) {
            if (string != null) {
                string2 = String.format("[%s] %s", string, string2);
            }
            Object[] objectArray2 = new Object[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                objectArray2[n] = object == null ? null : Log4JDebugStream.format(object);
                ++n;
            }
            String string3 = String.format(string2, objectArray2);
            this.appender.doAppend(new LoggingEvent(this.name, (Category)this.logger, (Priority)Level.DEBUG, (Object)string3, null));
        }
    }

    @Override
    public void debug(String string) {
        this.debug(null, string);
    }

    @Override
    public void sdebug(String string, Object ... objectArray) {
        this.sdebug(null, string, objectArray);
    }

    @Override
    public void fdebug(String string, Object ... objectArray) {
        this.fdebug(null, string, objectArray);
    }

    private Appender createDefaultLog4JAppender() {
        String string = String.valueOf(this.name) + DEFAULT_DEBUG_APPENDER_FILE_SUFFIX;
        RollingFileAppender rollingFileAppender = null;
        try {
            PatternLayout patternLayout = this.isThreadDebugStream ? new PatternLayout(DEFAULT_DEBUG_THREAD_APPENDER_LAYOUT) : new PatternLayout(DEFAULT_DEBUG_CLASS_APPENDER_LAYOUT);
            rollingFileAppender = new RollingFileAppender((Layout)patternLayout, string, true);
            rollingFileAppender.setName(DEBUG_APPENDER_PREFIX + this.name);
            rollingFileAppender.setMaxBackupIndex(3);
        }
        catch (IOException iOException) {
            this.logger.error((Object)"Error while setup of default Log4J appender for Event Engine debug stream", (Throwable)iOException);
        }
        return rollingFileAppender;
    }

    private static String format(Object object) {
        if (object instanceof Collection) {
            return CollectionFormatter.format((Collection)object, "\n");
        }
        IFormatter<?> iFormatter = FormatterFactory.getFormatter(object.getClass());
        return iFormatter.format(object);
    }
}

