/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.event.internal.debug;

import com.agfa.pacs.event.internal.debug.IDebugStream;
import com.agfa.pacs.event.internal.debug.Log4JDebugStream;
import com.agfa.pacs.logging.ALogger;
import java.util.HashMap;
import java.util.Map;

public class DebugStreamFactory {
    private static final Map<String, IDebugStream> debugStreamMap = new HashMap<String, IDebugStream>();

    public static boolean isDebugEnabled() {
        ALogger aLogger = ALogger.getLogger((String)"eventengine.debug.logger");
        return aLogger.isTraceEnabled();
    }

    public static IDebugStream getThreadDebugStream(Thread thread) {
        String string = thread.getName();
        return DebugStreamFactory.getDebugStream(string, true);
    }

    public static IDebugStream getDebugStream(String string) {
        return DebugStreamFactory.getDebugStream(string, false);
    }

    private static IDebugStream getDebugStream(String string, boolean bl) {
        IDebugStream iDebugStream = debugStreamMap.get(string);
        if (iDebugStream == null) {
            iDebugStream = new Log4JDebugStream(string, bl);
            debugStreamMap.put(string, iDebugStream);
        }
        return iDebugStream;
    }
}

