/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.event;

import com.agfa.pacs.event.ActionInfo;
import com.agfa.pacs.event.IEvent;
import com.agfa.pacs.event.IListenerSynchronization;
import com.agfa.pacs.event.internal.Transfer;
import com.agfa.pacs.event.internal.debug.DebugStreamFactory;
import com.agfa.pacs.event.internal.debug.IDebugStream;
import com.agfa.pacs.event.internal.debug.ThreadLocalDebugStream;
import com.agfa.pacs.event.internal.processor.ProcessorFrame;
import com.agfa.pacs.event.internal.task.Task;
import com.agfa.pacs.event.internal.tools.EventEngineSemaphore;
import com.agfa.pacs.logging.ALogger;
import java.util.List;

public class ListenerSynchronization
implements IListenerSynchronization {
    private static final ALogger LOGGER = ALogger.getLogger(ListenerSynchronization.class);
    private static final LiSyncLevel[] EMPTY_LI_SYNC_LEVEL = new LiSyncLevel[0];
    private static final boolean DEBUG = DebugStreamFactory.isDebugEnabled();
    private final EventEngineSemaphore sem = new EventEngineSemaphore(1, 1);
    private volatile Thread semThread;
    private LiSyncLevel[] liLevels = EMPTY_LI_SYNC_LEVEL;
    private int counter = 0;
    private final Object sync = new Object();
    protected IEvent bypass = null;

    private LiSyncLevel getLevel(int n) {
        if (this.liLevels.length <= n) {
            LiSyncLevel[] liSyncLevelArray = new LiSyncLevel[n + 1];
            int n2 = 0;
            while (n2 < this.liLevels.length) {
                liSyncLevelArray[n2] = this.liLevels[n2];
                ++n2;
            }
            n2 = this.liLevels.length;
            while (n2 < liSyncLevelArray.length) {
                liSyncLevelArray[n2] = new LiSyncLevel();
                ++n2;
            }
            this.liLevels = liSyncLevelArray;
        }
        return this.liLevels[n];
    }

    public EventEngineSemaphore getInProgress(int n) {
        return this.getLevel((int)n).sem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean assignFollowUp(Task task) {
        Object object = this.sync;
        synchronized (object) {
            LiSyncLevel liSyncLevel;
            block15: {
                block14: {
                    if (this.bypass != task.e) break block14;
                    if (DEBUG) {
                        this.getDebugStream().fdebug("LiSync", "Did not assign task as follow-up task as it is allowed to bypass; \n task: %s \n liSync: %s", task, this);
                    }
                    return false;
                }
                liSyncLevel = this.getLevel(task.e.stackDepth);
                if (!liSyncLevel.sem.P_nonBlocking()) break block15;
                liSyncLevel.markUnlock = true;
                if (DEBUG) {
                    this.getDebugStream().fdebug("LiSync", "Did not assign task as follow-up task as LiSyncLevel sem was acquired; \n task: %s \n liSync: %s", task, this);
                }
                return false;
            }
            if (liSyncLevel.head == null) {
                liSyncLevel.head = liSyncLevel.tail = task;
                ++this.counter;
            } else {
                liSyncLevel.tail.followUp = task;
                liSyncLevel.tail = task;
                ++this.counter;
            }
            if (DEBUG) {
                this.getDebugStream().fdebug("LiSync", "Assigned task as follow-up task in LiSyncLevel buffer;\n task: %s \n liSync: %s", task, this);
            }
        }
        if (this.counter > 100) {
            Thread.yield();
            int n = 3;
            while (this.counter > 200 && n > 0) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    LOGGER.warn("Thread was interrupted while pausing because of full LiSyncLevel buffer");
                }
                --n;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int releaseTask(List<ProcessorFrame> list, int n) {
        if (DEBUG) {
            this.getDebugStream().fdebug("LiSync", "Listener Synchronization BEFORE releaseTask(): \n %s", this);
        }
        int n2 = 0;
        Task task = null;
        Object object = this.sync;
        synchronized (object) {
            LiSyncLevel liSyncLevel = this.getLevel(n);
            if (liSyncLevel.head == null) {
                if (liSyncLevel.markUnlock) {
                    int n3 = this.getInProgress(n).V();
                    liSyncLevel.markUnlock = false;
                    if (DEBUG) {
                        this.getDebugStream().sdebug("LiSync", "Did not release tasks as LiSyncLevel[%s] buffer is empty, increased LiSyncLevelSem [%s]", n, n3);
                    }
                }
            } else {
                task = liSyncLevel.head;
                Task task2 = liSyncLevel.head.followUp;
                Task task3 = null;
                Task task4 = null;
                --this.counter;
                liSyncLevel.head = null;
                while (task2 != null && task.e.action == ActionInfo.PROGRESS && task.e.transfer != Transfer.STREAMED) {
                    if (task2.e.id == task.e.id) {
                        if (task.e.syncSem != null) {
                            task.e.syncSem.V();
                        }
                        ++list.get((int)task.e.stackDepth).flushSemLocalCount;
                        if (DEBUG) {
                            this.getDebugStream().fdebug("LiSync", "Dropped task for PROGRESS event from LiSyncLevel buffer; Dropped task: %s", task);
                        }
                        if (task4 != null) {
                            task4.followUp = task4.followUp.followUp;
                        }
                        task.clearForDeletion = true;
                        task.l = null;
                        task.e = null;
                        if (task.u != null) {
                            task.u.disposed();
                        }
                        task = task2;
                        task4 = task3;
                        ++n2;
                        --this.counter;
                    } else {
                        task3 = task2;
                        if (liSyncLevel.head == null) {
                            liSyncLevel.head = task2;
                        }
                    }
                    task2 = task2.followUp;
                }
                if (task4 != null) {
                    task4.followUp = task.followUp;
                }
                if (task == liSyncLevel.tail) {
                    liSyncLevel.tail = task4;
                }
                if (liSyncLevel.head == null) {
                    liSyncLevel.head = task.followUp;
                }
                task.followUp = null;
            }
        }
        if (task == null) {
            return 0;
        }
        boolean bl = false;
        do {
            try {
                list.get((int)task.e.stackDepth).src.put(task);
                bl = true;
                if (!DEBUG) continue;
                this.getDebugStream().fdebug("LiSync", "Transfered task from LiSyncLevel buffer to Task queue; task: %s, TaskQueue: %s", task, list.get((int)task.e.stackDepth).src);
            }
            catch (Throwable throwable) {
                LOGGER.error("Error while transfering task from listener synchronization buffer to task queue", throwable);
            }
        } while (!bl);
        if (DEBUG) {
            this.getDebugStream().fdebug("LiSync", "Listener Synchronization AFTER releaseTask(): \n %s", this);
        }
        return n2;
    }

    public void allowBypass(IEvent iEvent) {
        this.bypass = iEvent;
    }

    public boolean checkBypass(IEvent iEvent) {
        if (this.bypass == iEvent) {
            this.bypass = null;
            return false;
        }
        boolean bl = this.acquire();
        if (DEBUG) {
            this.getDebugStream().sdebug("LiSync", "Blocked for listener sync sem: %s", bl);
        }
        return true;
    }

    public boolean acquire() {
        boolean bl = this.sem.P();
        this.semThread = Thread.currentThread();
        return bl;
    }

    public boolean acquire(int n) {
        boolean bl = this.sem.P(n);
        if (bl) {
            this.semThread = Thread.currentThread();
        }
        return bl;
    }

    public int release() {
        this.semThread = null;
        return this.sem.V();
    }

    public int acquireReentrent(int n) {
        if (Thread.currentThread() != this.semThread) {
            if (n <= 0) {
                this.acquire();
                return 1;
            }
            return this.acquire(n) ? 1 : -1;
        }
        return 0;
    }

    private IDebugStream getDebugStream() {
        return ThreadLocalDebugStream.get();
    }

    public int dbgGetCurrentSemCount() {
        return this.sem.getCurrCount();
    }

    public IEvent dbgGetBypass() {
        return this.bypass;
    }

    public LiSyncLevel[] dbgGetLiSyncLevel() {
        return this.liLevels;
    }

    public Task dbgGetHead() {
        return this.getLevel((int)0).head;
    }

    public Task dbgGetTail() {
        return this.getLevel((int)0).tail;
    }

    public int dbgGetLength() {
        Task task = this.getLevel((int)0).head;
        int n = 0;
        while (task != null) {
            ++n;
            task = task.followUp;
        }
        return n;
    }

    public static class LiSyncLevel {
        protected EventEngineSemaphore sem = new EventEngineSemaphore(1, 1);
        public Task tail = null;
        public Task head = null;
        public boolean markUnlock = false;
        public int myNr = nr++;
        private static int nr = 0;

        public String toString() {
            return "LI " + this.myNr;
        }
    }
}

