/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export.tce.keyword;

import com.agfa.pacs.data.export.tce.keyword.GenericKeyword;
import com.agfa.pacs.data.export.tce.keyword.GenericKeywordNode;
import com.agfa.pacs.data.export.tce.keyword.GenericXMLKeywordProvider;
import com.agfa.pacs.data.shared.code.Code;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GenericSimpleTreeXMLKeywordProvider
extends GenericXMLKeywordProvider {
    public static final String TYPE = "XML_TREE";
    private GenericKeywordNode root;
    private HashMap<String, GenericKeywordNode> nodeMap;

    private GenericSimpleTreeXMLKeywordProvider(String string, String string2, GenericKeywordNode genericKeywordNode) {
        super(string, string2);
        this.root = genericKeywordNode;
        this.nodeMap = new HashMap();
        for (GenericKeywordNode genericKeywordNode2 : genericKeywordNode.toList()) {
            GenericKeyword genericKeyword = genericKeywordNode2.getKeyword();
            if (genericKeyword == null) continue;
            this.nodeMap.put(genericKeyword.getValueId(), genericKeywordNode2);
        }
    }

    public static GenericSimpleTreeXMLKeywordProvider createInstance(Document document) {
        Node node = document.getElementsByTagName("coding-system").item(0);
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = namedNodeMap.getNamedItem("id").getTextContent();
        String string2 = namedNodeMap.getNamedItem("designator-id").getTextContent();
        String string3 = namedNodeMap.getNamedItem("designator-name").getTextContent();
        String string4 = String.valueOf(string2) + "$" + string;
        GenericKeywordNode genericKeywordNode = new GenericKeywordNode();
        NodeList nodeList = document.getElementsByTagName("simple-tree");
        if (nodeList != null && nodeList.getLength() > 0) {
            NodeList nodeList2 = nodeList.item(0).getChildNodes();
            int n = 0;
            while (n < nodeList2.getLength()) {
                GenericKeywordNode genericKeywordNode2 = GenericSimpleTreeXMLKeywordProvider.createTree(string4, nodeList2.item(n));
                if (genericKeywordNode2 != null) {
                    genericKeywordNode.addChildren(genericKeywordNode2);
                }
                ++n;
            }
        }
        return new GenericSimpleTreeXMLKeywordProvider(string4, string3, genericKeywordNode);
    }

    public GenericKeywordNode getRoot() {
        return this.root;
    }

    @Override
    public GenericKeyword findKeyword(Code code) {
        return this.findKeyword(code.getCodeValue());
    }

    @Override
    public GenericKeyword findKeyword(String string) {
        GenericKeywordNode genericKeywordNode = this.nodeMap.get(string);
        return genericKeywordNode != null ? genericKeywordNode.getKeyword() : null;
    }

    @Override
    public boolean supportsDicomCodes() {
        return true;
    }

    private static GenericKeywordNode createTree(String string, Node node) {
        GenericKeywordNode genericKeywordNode = GenericSimpleTreeXMLKeywordProvider.createNode(string, node);
        if (genericKeywordNode != null) {
            NodeList nodeList = node.getChildNodes();
            if (nodeList != null) {
                int n = 0;
                while (n < nodeList.getLength()) {
                    GenericKeywordNode genericKeywordNode2 = GenericSimpleTreeXMLKeywordProvider.createTree(string, nodeList.item(n));
                    if (genericKeywordNode2 != null) {
                        genericKeywordNode.addChildren(genericKeywordNode2);
                    }
                    ++n;
                }
            }
            return genericKeywordNode;
        }
        return null;
    }

    private static GenericKeywordNode createNode(String string, Node node) {
        if ("code".equals(node.getNodeName())) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            GenericKeyword genericKeyword = new GenericKeyword(string, namedNodeMap.getNamedItem("value").getTextContent(), namedNodeMap.getNamedItem("meaning").getTextContent());
            return new GenericKeywordNode(genericKeyword);
        }
        return null;
    }

    @Override
    public String getType() {
        return TYPE;
    }
}

