/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export.tce.keyword;

import com.agfa.pacs.data.export.tce.keyword.IKeyword;
import com.agfa.pacs.data.export.tce.keyword.IKeywordProvider;
import com.agfa.pacs.data.export.tce.keyword.KeywordClinicalCodeAdapter;
import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.listtext.clinicalcode.IClinicalCodeNode;
import com.agfa.pacs.listtext.clinicalcode.IClinicalCodeProvider;

public class ClinicalCodeProviderAdapter
implements IKeywordProvider {
    private IClinicalCodeProvider prov;

    public ClinicalCodeProviderAdapter(IClinicalCodeProvider iClinicalCodeProvider) {
        this.prov = iClinicalCodeProvider;
    }

    @Override
    public String getId() {
        return this.prov.getId();
    }

    @Override
    public String getName() {
        return this.prov.getName();
    }

    @Override
    public boolean supportsDicomCodes() {
        return true;
    }

    @Override
    public IKeyword findKeyword(Code code) {
        IClinicalCodeNode iClinicalCodeNode = this.prov.createCodeScheme().findNodeForCode(code);
        if (iClinicalCodeNode != null) {
            return new KeywordClinicalCodeAdapter(iClinicalCodeNode.getCode());
        }
        return null;
    }

    @Override
    public IKeyword findKeyword(String string) {
        IClinicalCodeNode iClinicalCodeNode = this.prov.createCodeScheme().findNodeForCode(string);
        if (iClinicalCodeNode != null) {
            return new KeywordClinicalCodeAdapter(iClinicalCodeNode.getCode());
        }
        return null;
    }

    @Override
    public String getType() {
        return "ClinicalCodes";
    }

    public IClinicalCodeProvider getClinicalCodeProvider() {
        return this.prov;
    }
}

