/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export.tce;

import com.agfa.pacs.data.export.tce.Messages;
import com.agfa.pacs.data.export.tce.TeachingFileDicomCode;
import com.agfa.pacs.data.export.tce.TeachingFilePropertyValueType;
import com.agfa.pacs.data.export.tce.keyword.IKeyword;
import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.data.shared.code.CodeDictionary;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class TeachingFilePropertyValue<T> {
    private TeachingFilePropertyValueType<T> valueType;
    private List<T> values;

    private TeachingFilePropertyValue(TeachingFilePropertyValueType<T> teachingFilePropertyValueType, T ... TArray) {
        this.valueType = teachingFilePropertyValueType;
        this.values = new ArrayList<T>();
        this.setValues(TArray);
    }

    public static <T> TeachingFilePropertyValue<T> createInstance(TeachingFilePropertyValueType<T> teachingFilePropertyValueType, T ... TArray) {
        return new TeachingFilePropertyValue<T>(teachingFilePropertyValueType, TArray);
    }

    public boolean isMultiValue() {
        return this.values.size() > 1;
    }

    public boolean hasValues() {
        return this.values != null && !this.values.isEmpty() && this.values.get(0) != null;
    }

    public TeachingFilePropertyValueType<T> getValueType() {
        return this.valueType;
    }

    public int getValueCount() {
        return this.values != null ? this.values.size() : 0;
    }

    public T getValue() {
        return !this.values.isEmpty() ? (T)this.values.iterator().next() : null;
    }

    public T getValueAt(int n) {
        return this.values != null ? (T)this.values.get(n) : null;
    }

    public T[] getValues() {
        return TeachingFilePropertyValue.toArray(this.values, this.valueType.getValueClass());
    }

    private static <T> T[] toArray(List<T> list, Class<T> clazz) {
        Object[] objectArray = null;
        if (String.class.isAssignableFrom(clazz)) {
            objectArray = new String[list != null && !list.isEmpty() ? list.size() : 0];
        } else if (Integer.class.isAssignableFrom(clazz)) {
            objectArray = new Integer[list != null && !list.isEmpty() ? list.size() : 0];
        } else if (Date.class.isAssignableFrom(clazz)) {
            objectArray = new Date[list != null && !list.isEmpty() ? list.size() : 0];
        } else if (Enum.class.isAssignableFrom(clazz)) {
            objectArray = new Enum[list != null && !list.isEmpty() ? list.size() : 0];
        } else if (IKeyword.class.isAssignableFrom(clazz)) {
            objectArray = new IKeyword[list != null && !list.isEmpty() ? list.size() : 0];
        }
        if (list != null && !list.isEmpty()) {
            int n = 0;
            while (n < list.size()) {
                objectArray[n] = list.get(n);
                ++n;
            }
        }
        return objectArray;
    }

    public List<T> getValuesAsList() {
        return Collections.unmodifiableList(this.values);
    }

    public int getIndexOfValue(T t) {
        return this.values != null ? this.values.indexOf(t) : -1;
    }

    public void setValues(T ... TArray) {
        this.values.clear();
        if (TArray != null && TArray.length > 0) {
            T[] TArray2 = TArray;
            int n = TArray.length;
            int n2 = 0;
            while (n2 < n) {
                T t = TArray2[n2];
                this.values.add(t);
                ++n2;
            }
        }
    }

    public void setValueAt(T t, int n) {
        this.values.set(n, t);
    }

    public boolean removeAllValues() {
        if (this.values.isEmpty()) {
            return false;
        }
        this.values.clear();
        return true;
    }

    public boolean removeValues(T ... TArray) {
        if (TArray != null) {
            boolean bl = false;
            T[] TArray2 = TArray;
            int n = TArray.length;
            int n2 = 0;
            while (n2 < n) {
                T t = TArray2[n2];
                if (this.values.remove(t)) {
                    bl = true;
                }
                ++n2;
            }
            return bl;
        }
        return false;
    }

    public boolean addValues(T ... TArray) {
        if (TArray != null) {
            boolean bl = false;
            T[] TArray2 = TArray;
            int n = TArray.length;
            int n2 = 0;
            while (n2 < n) {
                T t = TArray2[n2];
                if (!this.values.contains(t)) {
                    this.values.add(t);
                    bl = true;
                }
                ++n2;
            }
            return bl;
        }
        return false;
    }

    public TeachingFilePropertyValue<T> copy() {
        return new TeachingFilePropertyValue<T>(this.valueType.copy(), this.getValues());
    }

    public static enum Category implements DicomEnum
    {
        Musculoskeletal(TeachingFileDicomCode.CategoryMusculoskeletal),
        Pulmonary(TeachingFileDicomCode.CategoryPulmonary),
        Cardiovascular(TeachingFileDicomCode.CategoryCardiovascular),
        Gastrointestinal(TeachingFileDicomCode.CategoryGastrointestinal),
        Genitourinary(TeachingFileDicomCode.CategoryGenitourinary),
        Neuro(TeachingFileDicomCode.CategoryNeuro),
        Nuclear(TeachingFileDicomCode.CategoryNuclear),
        Ultrasound(TeachingFileDicomCode.CategoryUltrasound),
        VascularAndInterventional(TeachingFileDicomCode.CategoryVascularAndInterventional),
        Pediatric(TeachingFileDicomCode.CategoryPediatric),
        Breast(TeachingFileDicomCode.CategoryBreast);

        private Code code;

        private Category(Code code) {
            this.code = code;
        }

        public String toString() {
            return Messages.getString("TeachingFileProperty.Category." + this.name());
        }

        @Override
        public String toDicomString() {
            return this.code.getCodeValue();
        }

        @Override
        public Code toDicomCode() {
            return this.code;
        }

        public Category fromDicomCode(Code code) {
            if (code.equals((Object)Category.Musculoskeletal.code)) {
                return Musculoskeletal;
            }
            if (code.equals((Object)Category.Pulmonary.code)) {
                return Pulmonary;
            }
            if (code.equals((Object)Category.Cardiovascular.code)) {
                return Cardiovascular;
            }
            if (code.equals((Object)Category.Gastrointestinal.code)) {
                return Gastrointestinal;
            }
            if (code.equals((Object)Category.Genitourinary.code)) {
                return Genitourinary;
            }
            if (code.equals((Object)Category.Neuro.code)) {
                return Neuro;
            }
            if (code.equals((Object)Category.Nuclear.code)) {
                return Nuclear;
            }
            if (code.equals((Object)Category.Ultrasound.code)) {
                return Ultrasound;
            }
            if (code.equals((Object)Category.Pediatric.code)) {
                return Pediatric;
            }
            if (code.equals((Object)Category.Breast.code)) {
                return Breast;
            }
            return null;
        }
    }

    public static interface DicomEnum {
        public Code toDicomCode();

        public String toDicomString();
    }

    public static enum Level implements DicomEnum
    {
        Primary(TeachingFileDicomCode.LevelPrimary),
        Intermediate(TeachingFileDicomCode.LevelIntermediate),
        Advanced(TeachingFileDicomCode.LevelAdvanced);

        private Code code;

        private Level(Code code) {
            this.code = code;
        }

        public String toString() {
            return Messages.getString("TeachingFileProperty.Level." + this.name());
        }

        @Override
        public String toDicomString() {
            return this.code.getCodeValue();
        }

        @Override
        public Code toDicomCode() {
            return this.code;
        }

        public Level fromDicomCode(Code code) {
            if (code.equals((Object)Level.Primary.code)) {
                return Primary;
            }
            if (code.equals((Object)Level.Intermediate.code)) {
                return Intermediate;
            }
            if (code.equals((Object)Level.Advanced.code)) {
                return Advanced;
            }
            return null;
        }
    }

    public static enum PatientSex implements DicomEnum
    {
        Female("F"),
        Male("M"),
        Other("O"),
        Unknown("U");

        private String dicomString;

        private PatientSex(String string2) {
            this.dicomString = string2;
        }

        public String toString() {
            return Messages.getString("TeachingFileProperty.PatientSex." + this.name());
        }

        @Override
        public String toDicomString() {
            return this.dicomString;
        }

        @Override
        public Code toDicomCode() {
            return null;
        }

        public PatientSex fromDicomString(String string) {
            if (string != null) {
                if (string.equals(PatientSex.Female.dicomString)) {
                    return Female;
                }
                if (string.equals(PatientSex.Male.dicomString)) {
                    return Male;
                }
                if (string.equals(PatientSex.Other.dicomString)) {
                    return Other;
                }
            }
            return Unknown;
        }
    }

    public static enum Purpose implements DicomEnum
    {
        ForTeaching(new Code("IHERADTF", "TCE001", "ForTeaching")),
        ForClinicalTrial(new Code("IHERADTF", "TCE002", "ForClinicalTrial")),
        ForResearch(new Code("IHERADTF", "TCE007", "ForResearch")),
        ForPublication(new Code("IHERADTF", "TCE008", "ForPublication"));

        private Code code;

        private Purpose(Code code) {
            this.code = code;
        }

        public String toString() {
            return Messages.getString("TeachingFileProperty.Purpose." + this.name());
        }

        @Override
        public String toDicomString() {
            return this.code.getCodeValue();
        }

        @Override
        public Code toDicomCode() {
            return this.code;
        }

        public Purpose fromDicomCode(Code code) {
            if (code.equals((Object)Purpose.ForTeaching.code)) {
                return ForTeaching;
            }
            if (code.equals((Object)Purpose.ForClinicalTrial.code)) {
                return ForClinicalTrial;
            }
            if (code.equals((Object)Purpose.ForResearch.code)) {
                return ForResearch;
            }
            if (code.equals((Object)Purpose.ForPublication.code)) {
                return ForPublication;
            }
            return null;
        }
    }

    public static enum YesNo implements DicomEnum
    {
        Yes(CodeDictionary.YesNo.Yes),
        No(CodeDictionary.YesNo.No);

        private Code code;

        private YesNo(Code code) {
            this.code = code;
        }

        public String toString() {
            return Messages.getString("TeachingFile.YesNo." + this.name());
        }

        @Override
        public Code toDicomCode() {
            return this.code;
        }

        @Override
        public String toDicomString() {
            return this.name();
        }

        public YesNo fromDicomString(String string) {
            return YesNo.valueOf(string);
        }

        public static YesNo fromDicomCode(Code code) {
            YesNo[] yesNoArray = YesNo.values();
            int n = yesNoArray.length;
            int n2 = 0;
            while (n2 < n) {
                YesNo yesNo = yesNoArray[n2];
                if (yesNo.code.equals((Object)code)) {
                    return yesNo;
                }
                ++n2;
            }
            return null;
        }
    }
}

