/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export.tce;

import com.agfa.pacs.core.FactorySelector;
import com.agfa.pacs.data.export.tce.ITeachingFileConfig;
import com.agfa.pacs.data.export.tce.keyword.IKeywordProvider;
import java.util.ArrayList;
import java.util.List;

public abstract class TCEProviderFactory {
    private static TCEProviderFactory implementation;

    public static synchronized TCEProviderFactory getInstance() {
        if (implementation == null) {
            TCEProviderFactory.initialize();
        }
        return implementation;
    }

    public List<String> getKeywordProviderIdentifiers() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (IKeywordProvider iKeywordProvider : this.getKeywordProviderInt()) {
            arrayList.add(iKeywordProvider.getId());
        }
        return arrayList;
    }

    public IKeywordProvider getKeywordProvider(String string) {
        for (IKeywordProvider iKeywordProvider : this.getKeywordProviderInt()) {
            if (!iKeywordProvider.getId().equals(string)) continue;
            return iKeywordProvider;
        }
        return null;
    }

    public List<IKeywordProvider> getKeywordProviders() {
        return implementation.getKeywordProviderInt();
    }

    public ITeachingFileConfig getConfiguration() {
        return implementation.getConfigurationInt();
    }

    protected abstract List<IKeywordProvider> getKeywordProviderInt();

    protected abstract ITeachingFileConfig getConfigurationInt();

    private static synchronized void initialize() {
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            Class<?> clazz = Class.forName(FactorySelector.createFactory((String)TCEProviderFactory.class.getName()));
            implementation = (TCEProviderFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            reflectiveOperationException = classNotFoundException;
        }
        catch (InstantiationException instantiationException) {
            reflectiveOperationException = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            reflectiveOperationException = illegalAccessException;
        }
        if (reflectiveOperationException != null) {
            throw new RuntimeException("failed to create factory " + TCEProviderFactory.class.getName(), reflectiveOperationException);
        }
    }
}

