/*
 * Decompiled with CFR 0.152.
 */
package at.bestsolution.efxclipse.runtime.osgi.fxloader;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;

public class WinRegistry {
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    public static final int REG_SUCCESS = 0;
    public static final int REG_NOTFOUND = 2;
    public static final int REG_ACCESSDENIED = 5;
    private static final int KEY_ALL_ACCESS = 983103;
    private static final int KEY_READ = 131097;
    private static Preferences userRoot = Preferences.userRoot();
    private static Preferences systemRoot = Preferences.systemRoot();
    private static Class<? extends Preferences> userClass = userRoot.getClass();
    private static Method regOpenKey = null;
    private static Method regCloseKey = null;
    private static Method regQueryValueEx = null;
    private static Method regEnumValue = null;
    private static Method regQueryInfoKey = null;
    private static Method regEnumKeyEx = null;
    private static Method regCreateKeyEx = null;
    private static Method regSetValueEx = null;
    private static Method regDeleteKey = null;
    private static Method regDeleteValue = null;

    static {
        try {
            regOpenKey = userClass.getDeclaredMethod("WindowsRegOpenKey", Integer.TYPE, byte[].class, Integer.TYPE);
            regOpenKey.setAccessible(true);
            regCloseKey = userClass.getDeclaredMethod("WindowsRegCloseKey", Integer.TYPE);
            regCloseKey.setAccessible(true);
            regQueryValueEx = userClass.getDeclaredMethod("WindowsRegQueryValueEx", Integer.TYPE, byte[].class);
            regQueryValueEx.setAccessible(true);
            regEnumValue = userClass.getDeclaredMethod("WindowsRegEnumValue", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            regEnumValue.setAccessible(true);
            regQueryInfoKey = userClass.getDeclaredMethod("WindowsRegQueryInfoKey1", Integer.TYPE);
            regQueryInfoKey.setAccessible(true);
            regEnumKeyEx = userClass.getDeclaredMethod("WindowsRegEnumKeyEx", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            regEnumKeyEx.setAccessible(true);
            regCreateKeyEx = userClass.getDeclaredMethod("WindowsRegCreateKeyEx", Integer.TYPE, byte[].class);
            regCreateKeyEx.setAccessible(true);
            regSetValueEx = userClass.getDeclaredMethod("WindowsRegSetValueEx", Integer.TYPE, byte[].class, byte[].class);
            regSetValueEx.setAccessible(true);
            regDeleteValue = userClass.getDeclaredMethod("WindowsRegDeleteValue", Integer.TYPE, byte[].class);
            regDeleteValue.setAccessible(true);
            regDeleteKey = userClass.getDeclaredMethod("WindowsRegDeleteKey", Integer.TYPE, byte[].class);
            regDeleteKey.setAccessible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private WinRegistry() {
    }

    public static String readString(int n, String string, String string2) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (n == -2147483646) {
            return WinRegistry.readString(systemRoot, n, string, string2);
        }
        if (n == -2147483647) {
            return WinRegistry.readString(userRoot, n, string, string2);
        }
        throw new IllegalArgumentException("hkey=" + n);
    }

    public static Map<String, String> readStringValues(int n, String string) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (n == -2147483646) {
            return WinRegistry.readStringValues(systemRoot, n, string);
        }
        if (n == -2147483647) {
            return WinRegistry.readStringValues(userRoot, n, string);
        }
        throw new IllegalArgumentException("hkey=" + n);
    }

    public static List<String> readStringSubKeys(int n, String string) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (n == -2147483646) {
            return WinRegistry.readStringSubKeys(systemRoot, n, string);
        }
        if (n == -2147483647) {
            return WinRegistry.readStringSubKeys(userRoot, n, string);
        }
        throw new IllegalArgumentException("hkey=" + n);
    }

    public static void createKey(int n, String string) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int[] nArray;
        if (n == -2147483646) {
            nArray = WinRegistry.createKey(systemRoot, n, string);
            regCloseKey.invoke((Object)systemRoot, new Integer(nArray[0]));
        } else if (n == -2147483647) {
            nArray = WinRegistry.createKey(userRoot, n, string);
            regCloseKey.invoke((Object)userRoot, new Integer(nArray[0]));
        } else {
            throw new IllegalArgumentException("hkey=" + n);
        }
        if (nArray[1] != 0) {
            throw new IllegalArgumentException("rc=" + nArray[1] + "  key=" + string);
        }
    }

    public static void writeStringValue(int n, String string, String string2, String string3) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (n == -2147483646) {
            WinRegistry.writeStringValue(systemRoot, n, string, string2, string3);
        } else if (n == -2147483647) {
            WinRegistry.writeStringValue(userRoot, n, string, string2, string3);
        } else {
            throw new IllegalArgumentException("hkey=" + n);
        }
    }

    public static void deleteKey(int n, String string) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int n2 = -1;
        if (n == -2147483646) {
            n2 = WinRegistry.deleteKey(systemRoot, n, string);
        } else if (n == -2147483647) {
            n2 = WinRegistry.deleteKey(userRoot, n, string);
        }
        if (n2 != 0) {
            throw new IllegalArgumentException("rc=" + n2 + "  key=" + string);
        }
    }

    public static void deleteValue(int n, String string, String string2) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int n2 = -1;
        if (n == -2147483646) {
            n2 = WinRegistry.deleteValue(systemRoot, n, string, string2);
        } else if (n == -2147483647) {
            n2 = WinRegistry.deleteValue(userRoot, n, string, string2);
        }
        if (n2 != 0) {
            throw new IllegalArgumentException("rc=" + n2 + "  key=" + string + "  value=" + string2);
        }
    }

    private static int deleteValue(Preferences preferences, int n, String string, String string2) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int[] nArray = (int[])regOpenKey.invoke((Object)preferences, new Integer(n), WinRegistry.toCstr(string), new Integer(983103));
        if (nArray[1] != 0) {
            return nArray[1];
        }
        int n2 = (Integer)regDeleteValue.invoke((Object)preferences, new Integer(nArray[0]), WinRegistry.toCstr(string2));
        regCloseKey.invoke((Object)preferences, new Integer(nArray[0]));
        return n2;
    }

    private static int deleteKey(Preferences preferences, int n, String string) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int n2 = (Integer)regDeleteKey.invoke((Object)preferences, new Integer(n), WinRegistry.toCstr(string));
        return n2;
    }

    private static String readString(Preferences preferences, int n, String string, String string2) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int[] nArray = (int[])regOpenKey.invoke((Object)preferences, new Integer(n), WinRegistry.toCstr(string), new Integer(131097));
        if (nArray[1] != 0) {
            return null;
        }
        byte[] byArray = (byte[])regQueryValueEx.invoke((Object)preferences, new Integer(nArray[0]), WinRegistry.toCstr(string2));
        regCloseKey.invoke((Object)preferences, new Integer(nArray[0]));
        return byArray != null ? new String(byArray).trim() : null;
    }

    private static Map<String, String> readStringValues(Preferences preferences, int n, String string) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int[] nArray = (int[])regOpenKey.invoke((Object)preferences, new Integer(n), WinRegistry.toCstr(string), new Integer(131097));
        if (nArray[1] != 0) {
            return null;
        }
        int[] nArray2 = (int[])regQueryInfoKey.invoke((Object)preferences, new Integer(nArray[0]));
        int n2 = nArray2[2];
        int n3 = nArray2[3];
        int n4 = 0;
        while (n4 < n2) {
            byte[] byArray = (byte[])regEnumValue.invoke((Object)preferences, new Integer(nArray[0]), new Integer(n4), new Integer(n3 + 1));
            String string2 = WinRegistry.readString(n, string, new String(byArray));
            hashMap.put(new String(byArray).trim(), string2);
            ++n4;
        }
        regCloseKey.invoke((Object)preferences, new Integer(nArray[0]));
        return hashMap;
    }

    private static List<String> readStringSubKeys(Preferences preferences, int n, String string) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int[] nArray = (int[])regOpenKey.invoke((Object)preferences, new Integer(n), WinRegistry.toCstr(string), new Integer(131097));
        if (nArray[1] != 0) {
            return null;
        }
        int[] nArray2 = (int[])regQueryInfoKey.invoke((Object)preferences, new Integer(nArray[0]));
        int n2 = nArray2[0];
        int n3 = nArray2[3];
        int n4 = 0;
        while (n4 < n2) {
            byte[] byArray = (byte[])regEnumKeyEx.invoke((Object)preferences, new Integer(nArray[0]), new Integer(n4), new Integer(n3 + 1));
            arrayList.add(new String(byArray).trim());
            ++n4;
        }
        regCloseKey.invoke((Object)preferences, new Integer(nArray[0]));
        return arrayList;
    }

    private static int[] createKey(Preferences preferences, int n, String string) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return (int[])regCreateKeyEx.invoke((Object)preferences, new Integer(n), WinRegistry.toCstr(string));
    }

    private static void writeStringValue(Preferences preferences, int n, String string, String string2, String string3) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int[] nArray = (int[])regOpenKey.invoke((Object)preferences, new Integer(n), WinRegistry.toCstr(string), new Integer(983103));
        regSetValueEx.invoke((Object)preferences, new Integer(nArray[0]), WinRegistry.toCstr(string2), WinRegistry.toCstr(string3));
        regCloseKey.invoke((Object)preferences, new Integer(nArray[0]));
    }

    private static byte[] toCstr(String string) {
        byte[] byArray = new byte[string.length() + 1];
        int n = 0;
        while (n < string.length()) {
            byArray[n] = (byte)string.charAt(n);
            ++n;
        }
        byArray[string.length()] = 0;
        return byArray;
    }
}

