/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.valuemapping;

import com.agfa.pacs.data.shared.valuemapping.AbstractValueMapping;
import com.agfa.pacs.data.shared.valuemapping.ISUVData;
import com.agfa.pacs.data.shared.valuemapping.IStandardizedUptakeValueMethod;
import com.agfa.pacs.data.shared.valuemapping.IValueMapping;
import com.agfa.pacs.data.shared.valuemapping.IValueMappingProperties;
import com.agfa.pacs.tools.DoubleEquals;
import org.dcm4che3.data.Attributes;

public class SUVMapping
extends AbstractValueMapping {
    private final IStandardizedUptakeValueMethod method;
    private final IValueMapping modalityLUT;
    private final double factor;

    public SUVMapping(ISUVData iSUVData, IValueMappingProperties iValueMappingProperties) {
        this.method = iSUVData.getMethod();
        this.modalityLUT = iValueMappingProperties.getModalityLUT();
        this.factor = SUVMapping.calculateFactor(iValueMappingProperties.getAttributes(), iSUVData);
    }

    private static double calculateFactor(Attributes attributes, ISUVData iSUVData) {
        Double d = iSUVData.getAcquisitionDelay(attributes);
        if (d == null) {
            return Double.NaN;
        }
        double d2 = iSUVData.getMethod().getPatientSizeFactor(iSUVData) / iSUVData.getInjectedDose();
        if (!DoubleEquals.equals((double)d, (double)0.0)) {
            d2 *= Math.exp(Math.log(2.0) * d / iSUVData.getIsotope().getHalfLife());
        }
        return d2;
    }

    @Override
    public double applyMapping(int n) {
        return this.modalityLUT.applyMapping(n) * this.factor;
    }

    @Override
    public String getUnit() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.method.getUnit());
        stringBuilder.append(" (");
        stringBuilder.append(this.method.getName());
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public IStandardizedUptakeValueMethod getMethod() {
        return this.method;
    }

    @Override
    public boolean isMonotonic() {
        return this.modalityLUT.isMonotonic();
    }
}

