/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.valuemapping;

import com.agfa.pacs.data.shared.Messages;
import com.agfa.pacs.data.shared.valuemapping.IIsotope;
import com.agfa.pacs.tools.CompareUtils;

public class SUVIsotope
implements IIsotope {
    public static final IIsotope CUSTOM = new SUVIsotope(null, true);
    private final Double halfLife;
    private final boolean isCustom;

    private SUVIsotope(Double d, boolean bl) {
        this.halfLife = d;
        this.isCustom = bl;
    }

    static IIsotope createIsotopeFromData(double d) {
        return new SUVIsotope(d, false);
    }

    public static IIsotope createCustomIsotope(Double d) {
        if (d == null) {
            return CUSTOM;
        }
        return new SUVIsotope(d, true);
    }

    @Override
    public Double getHalfLife() {
        return this.halfLife;
    }

    @Override
    public boolean isEditable() {
        return this.isCustom;
    }

    public boolean equals(Object object) {
        if (object instanceof SUVIsotope) {
            SUVIsotope sUVIsotope = (SUVIsotope)object;
            return this.isCustom == sUVIsotope.isCustom && CompareUtils.equals((Object)this.halfLife, (Object)sUVIsotope.halfLife);
        }
        return false;
    }

    public int hashCode() {
        return CompareUtils.hashCode((Object)this.halfLife) ^ Boolean.valueOf(this.isCustom).hashCode();
    }

    public String toString() {
        if (this.isCustom) {
            return Messages.getString("SUV.Isotope.Custom.Label");
        }
        return Messages.getString("SUV.Isotope.FromData.Label");
    }
}

