/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.valuemapping;

import com.agfa.pacs.data.shared.Messages;
import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.data.shared.valuemapping.AbstractValueMapping;
import com.agfa.pacs.data.shared.valuemapping.DefaultValueMappingOption;
import com.agfa.pacs.data.shared.valuemapping.IValueMapping;
import com.agfa.pacs.data.shared.valuemapping.IValueMappingOption;
import com.agfa.pacs.data.shared.valuemapping.IValueMappingProperties;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.CompareUtils;
import com.agfa.pacs.tools.DoubleEquals;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class RealWorldValueMapping
extends AbstractValueMapping
implements IValueMappingOption {
    private static final ALogger log = ALogger.getLogger(RealWorldValueMapping.class);
    private static final String UNKNOWN = Messages.getString("ValueMapping.Unknown");
    private final int firstValueMapped;
    private final int lastValueMapped;
    private final double slope;
    private final double intercept;
    private final double[] lutData;
    private final String lutExplanation;
    private final String lutLabel;
    private final Code measurementUnit;
    private final boolean isMonotonic;

    private RealWorldValueMapping(Attributes attributes, int n) {
        this.firstValueMapped = RealWorldValueMapping.getInt(attributes, 4231702, Integer.MIN_VALUE);
        this.lastValueMapped = RealWorldValueMapping.getInt(attributes, 4231697, Integer.MAX_VALUE);
        if (attributes.containsValue(4231717) && attributes.containsValue(4231716)) {
            this.slope = attributes.getDouble(4231717, 0.0);
            this.intercept = attributes.getDouble(4231716, 0.0);
            this.lutData = null;
            this.isMonotonic = true;
        } else {
            this.slope = 1.0;
            this.intercept = 0.0;
            this.lutData = attributes.getDoubles(4231698);
            this.isMonotonic = this.checkMonotonicity(this.lutData);
        }
        this.lutLabel = RealWorldValueMapping.getLabel(attributes, n);
        this.lutExplanation = RealWorldValueMapping.getString(attributes, 2633731, this.lutLabel);
        this.measurementUnit = Code.create(attributes, 4196586);
    }

    private static int getInt(Attributes attributes, int n, int n2) {
        return attributes.getInt(n, n2);
    }

    private static String getString(Attributes attributes, int n, String string) {
        if (attributes.contains(n)) {
            return attributes.getString(n);
        }
        return string;
    }

    private static String getLabel(Attributes attributes, int n) {
        String string = attributes.getString(4231696);
        if (string == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(UNKNOWN);
            stringBuilder.append(" (");
            stringBuilder.append(n + 1);
            stringBuilder.append(')');
            string = stringBuilder.toString();
        }
        return string;
    }

    public static List<RealWorldValueMapping> create(Attributes attributes) {
        if (attributes == null) {
            return Collections.emptyList();
        }
        Sequence sequence = attributes.getSequence(4231318);
        if (sequence == null) {
            return Collections.emptyList();
        }
        int n = sequence.size();
        ArrayList<RealWorldValueMapping> arrayList = new ArrayList<RealWorldValueMapping>(n);
        int n2 = 0;
        while (n2 < n) {
            try {
                RealWorldValueMapping realWorldValueMapping = new RealWorldValueMapping((Attributes)sequence.get(n2), n2);
                if (realWorldValueMapping.isValid()) {
                    arrayList.add(realWorldValueMapping);
                } else {
                    log.debug("RealWorldValueMapping skipped: " + realWorldValueMapping);
                }
            }
            catch (Exception exception) {
                log.warn("Parsing RealWorldValueMapping failed.", (Throwable)exception);
            }
            ++n2;
        }
        return arrayList;
    }

    private boolean checkMonotonicity(double[] dArray) {
        boolean bl = false;
        boolean bl2 = false;
        int n = 1;
        while (n < dArray.length) {
            double d = dArray[n] - dArray[n - 1];
            if (d > 0.0) {
                bl = true;
            }
            if (d < 0.0) {
                bl2 = true;
            }
            ++n;
        }
        return bl ^ bl2;
    }

    @Override
    public IValueMapping createValueMapping(IValueMappingProperties iValueMappingProperties) {
        for (IValueMapping iValueMapping : iValueMappingProperties.getRealWorldValueMappings()) {
            if (!this.isEquivalent(iValueMapping)) continue;
            return iValueMapping;
        }
        return null;
    }

    @Override
    public double applyMapping(int n) {
        if (n < this.firstValueMapped || n > this.lastValueMapped) {
            return Double.NaN;
        }
        if (this.lutData == null) {
            return this.slope * (double)n + this.intercept;
        }
        if (n - this.firstValueMapped < this.lutData.length) {
            return this.lutData[n - this.firstValueMapped];
        }
        return Double.NaN;
    }

    @Override
    public String getUnit() {
        if (this.measurementUnit == null) {
            return null;
        }
        return this.measurementUnit.getCodeValue();
    }

    @Override
    public Integer getFirstValueMapped() {
        return this.firstValueMapped;
    }

    @Override
    public Integer getLastValueMapped() {
        return this.lastValueMapped;
    }

    @Override
    public String getLabel() {
        return DefaultValueMappingOption.constructLabel(this.lutLabel, this.getUnit());
    }

    @Override
    public String getDescription() {
        return this.lutExplanation;
    }

    @Override
    public boolean isMonotonic() {
        return this.isMonotonic;
    }

    private boolean isValid() {
        return this.firstValueMapped < this.lastValueMapped && !DoubleEquals.equals((double)this.slope, (double)0.0);
    }

    public boolean isEquivalent(IValueMapping iValueMapping) {
        if (iValueMapping instanceof RealWorldValueMapping) {
            return this.isEquivalent((RealWorldValueMapping)iValueMapping);
        }
        return false;
    }

    private boolean isEquivalent(RealWorldValueMapping realWorldValueMapping) {
        return CompareUtils.equals((Object)this.lutLabel, (Object)realWorldValueMapping.lutLabel) && CompareUtils.equals((Object)this.getUnit(), (Object)realWorldValueMapping.getUnit());
    }

    public boolean equals(Object object) {
        if (object instanceof RealWorldValueMapping) {
            RealWorldValueMapping realWorldValueMapping = (RealWorldValueMapping)object;
            return this.firstValueMapped == realWorldValueMapping.firstValueMapped && this.lastValueMapped == realWorldValueMapping.lastValueMapped && this.slope == realWorldValueMapping.slope && this.intercept == realWorldValueMapping.intercept && Arrays.equals(this.lutData, realWorldValueMapping.lutData) && CompareUtils.equals((Object)this.lutExplanation, (Object)realWorldValueMapping.lutExplanation) && CompareUtils.equals((Object)this.lutLabel, (Object)realWorldValueMapping.lutLabel) && CompareUtils.equals((Object)this.measurementUnit, (Object)realWorldValueMapping.measurementUnit);
        }
        return false;
    }

    public int hashCode() {
        return this.firstValueMapped ^ this.lastValueMapped ^ Double.valueOf(this.slope).hashCode() ^ Double.valueOf(this.intercept).hashCode() ^ CompareUtils.hashCode((Object)this.lutData) ^ CompareUtils.hashCode((Object)this.lutExplanation) ^ CompareUtils.hashCode((Object)this.lutLabel) ^ CompareUtils.hashCode((Object)this.measurementUnit);
    }

    public String toString() {
        return this.getLabel();
    }
}

