/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.util;

import com.agfa.pacs.data.shared.util.SplittedOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class SplittedZipOutputStream
extends ZipOutputStream {
    private SplittedOutputStream sos;

    public SplittedZipOutputStream(SplittedOutputStream splittedOutputStream) {
        super(splittedOutputStream);
        this.sos = splittedOutputStream;
    }

    @Override
    public void close() throws IOException {
        this.sos.setSplit(true);
        super.finish();
        super.close();
    }

    @Override
    public void closeEntry() throws IOException {
        boolean bl = this.sos.isSplit();
        this.sos.setSplit(false);
        super.closeEntry();
        this.sos.setSplit(bl);
    }

    @Override
    public void finish() throws IOException {
        boolean bl = this.sos.isSplit();
        this.sos.setSplit(false);
        this.sos.setSplit(bl);
    }

    @Override
    public void putNextEntry(ZipEntry zipEntry) throws IOException {
        boolean bl = this.sos.isSplit();
        this.sos.setSplit(false);
        super.putNextEntry(zipEntry);
        this.sos.setSplit(bl);
    }
}

