/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.store;

import com.agfa.pacs.core.FactorySelector;
import com.agfa.pacs.data.shared.store.IStoreProvider;

public abstract class StoreProviderFactory {
    private static StoreProviderFactory implementation;

    public static synchronized StoreProviderFactory getInstance() {
        if (implementation == null) {
            StoreProviderFactory.initialize();
        }
        return implementation;
    }

    public IStoreProvider getStoreProvider() {
        return this.getStoreProviderInt();
    }

    protected abstract IStoreProvider getStoreProviderInt();

    private static synchronized void initialize() {
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            Class<?> clazz = Class.forName(FactorySelector.createFactory((String)StoreProviderFactory.class.getName()));
            implementation = (StoreProviderFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            reflectiveOperationException = classNotFoundException;
        }
        catch (InstantiationException instantiationException) {
            reflectiveOperationException = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            reflectiveOperationException = illegalAccessException;
        }
        if (reflectiveOperationException != null) {
            throw new RuntimeException("Failed to create factory " + StoreProviderFactory.class.getName(), reflectiveOperationException);
        }
    }
}

