/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.profiler;

import com.agfa.pacs.core.FactorySelector;
import com.agfa.pacs.data.shared.profiler.IProfiler;

public abstract class Profiler {
    private static IProfiler instance;
    private static volatile boolean enabled;

    static {
        enabled = false;
        Profiler.initialize();
    }

    public static boolean isProfilingEnabled() {
        return enabled;
    }

    public static void setProfilingEnabled(boolean bl) {
        if (instance != null) {
            enabled = bl;
            instance.setProfilingEnabled(bl);
        }
    }

    public static IProfiler getInstance() {
        return instance;
    }

    public abstract IProfiler getProfiler();

    private static synchronized void initialize() {
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            Class<?> clazz = Class.forName(FactorySelector.createFactory((String)Profiler.class.getName()));
            Profiler profiler = (Profiler)clazz.newInstance();
            instance = profiler.getProfiler();
            if (instance != null) {
                enabled = instance.getStartupProfilerState();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            reflectiveOperationException = classNotFoundException;
        }
        catch (InstantiationException instantiationException) {
            reflectiveOperationException = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            reflectiveOperationException = illegalAccessException;
        }
        if (reflectiveOperationException != null) {
            throw new RuntimeException("failed to create factory " + Profiler.class.getName(), reflectiveOperationException);
        }
    }
}

