/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.primitives;

import com.agfa.pacs.data.shared.primitives.Hash;

abstract class PrimitiveHash
extends Hash {
    protected transient byte[] _states;
    protected static final byte FREE = 0;
    protected static final byte FULL = 1;
    protected static final byte REMOVED = 2;

    public PrimitiveHash() {
    }

    public PrimitiveHash(int n) {
        this(n, 0.5f);
    }

    public PrimitiveHash(int n, float f) {
        this._loadFactor = f;
        this.setUp((int)Math.ceil((float)n / f));
    }

    @Override
    public Object clone() {
        PrimitiveHash primitiveHash = (PrimitiveHash)super.clone();
        primitiveHash._states = (byte[])this._states.clone();
        return primitiveHash;
    }

    @Override
    protected int capacity() {
        return this._states.length;
    }

    @Override
    protected void removeAt(int n) {
        this._states[n] = 2;
        super.removeAt(n);
    }

    @Override
    protected int setUp(int n) {
        int n2 = super.setUp(n);
        this._states = new byte[n2];
        return n2;
    }
}

