/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.primitives;

import com.agfa.pacs.data.shared.primitives.Hash;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;

abstract class Iterator {
    protected final Hash _hash;
    protected int _expectedSize;
    protected int _index;

    public Iterator(Hash hash) {
        this._hash = hash;
        this._expectedSize = this._hash.size();
        this._index = this._hash.capacity();
    }

    public boolean hasNext() {
        return this.nextIndex() >= 0;
    }

    public void remove() {
        if (this._expectedSize != this._hash.size()) {
            throw new ConcurrentModificationException();
        }
        try {
            this._hash.tempDisableAutoCompaction();
            this._hash.removeAt(this._index);
        }
        finally {
            this._hash.reenableAutoCompaction(false);
        }
        --this._expectedSize;
    }

    protected final void moveToNextIndex() {
        this._index = this.nextIndex();
        if (this._index < 0) {
            throw new NoSuchElementException();
        }
    }

    protected abstract int nextIndex();
}

