/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.primitives;

import com.agfa.pacs.data.shared.primitives.IntHash;
import com.agfa.pacs.data.shared.primitives.IntIterator;
import com.agfa.pacs.data.shared.primitives.IntProcedure;
import com.agfa.pacs.data.shared.primitives.SetIntIterator;
import java.util.Arrays;

public class IntHashSet
extends IntHash {
    static final long serialVersionUID = 1L;

    public IntHashSet() {
    }

    public IntHashSet(int n) {
        super(n);
    }

    public IntHashSet(int n, float f) {
        super(n, f);
    }

    public IntHashSet(int[] nArray) {
        this(nArray.length);
        this.addAll(nArray);
    }

    public IntIterator iterator() {
        return new SetIntIterator(this);
    }

    public boolean add(int n) {
        int n2 = this.insertionIndex(n);
        if (n2 < 0) {
            return false;
        }
        byte by = this._states[n2];
        this._set[n2] = n;
        this._states[n2] = 1;
        this.postInsertHook(by == 0);
        return true;
    }

    @Override
    protected void rehash(int n) {
        int n2 = this._set.length;
        int[] nArray = this._set;
        byte[] byArray = this._states;
        this._set = new int[n];
        this._states = new byte[n];
        int n3 = n2;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            int n4 = nArray[n3];
            int n5 = this.insertionIndex(n4);
            this._set[n5] = n4;
            this._states[n5] = 1;
        }
    }

    public int[] toArray() {
        int[] nArray = new int[this.size()];
        int[] nArray2 = this._set;
        byte[] byArray = this._states;
        int n = byArray.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            nArray[n2++] = nArray2[n];
        }
        return nArray;
    }

    @Override
    public void clear() {
        super.clear();
        int[] nArray = this._set;
        byte[] byArray = this._states;
        int n = nArray.length;
        while (n-- > 0) {
            nArray[n] = 0;
            byArray[n] = 0;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof IntHashSet)) {
            return false;
        }
        final IntHashSet intHashSet = (IntHashSet)object;
        if (intHashSet.size() != this.size()) {
            return false;
        }
        return this.forEach(new IntProcedure(){

            @Override
            public final boolean execute(int n) {
                return intHashSet.contains(n);
            }
        });
    }

    public int hashCode() {
        HashProcedure hashProcedure = new HashProcedure();
        this.forEach(hashProcedure);
        return hashProcedure.getHashCode();
    }

    public boolean remove(int n) {
        int n2 = this.index(n);
        if (n2 >= 0) {
            this.removeAt(n2);
            return true;
        }
        return false;
    }

    public boolean containsAll(int[] nArray) {
        int n = nArray.length;
        while (n-- > 0) {
            if (this.contains(nArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(int[] nArray) {
        boolean bl = false;
        int n = nArray.length;
        while (n-- > 0) {
            if (!this.add(nArray[n])) continue;
            bl = true;
        }
        return bl;
    }

    public boolean removeAll(int[] nArray) {
        boolean bl = false;
        int n = nArray.length;
        while (n-- > 0) {
            if (!this.remove(nArray[n])) continue;
            bl = true;
        }
        return bl;
    }

    public boolean retainAll(int[] nArray) {
        boolean bl = false;
        Arrays.sort(nArray);
        int[] nArray2 = this._set;
        byte[] byArray = this._states;
        int n = nArray2.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || Arrays.binarySearch(nArray, nArray2[n]) >= 0) continue;
            this.remove(nArray2[n]);
            bl = true;
        }
        return bl;
    }

    private final class HashProcedure
    implements IntProcedure {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        @Override
        public final boolean execute(int n) {
            this.h += IntHashSet.this._hashingStrategy.computeHashCode(n);
            return true;
        }
    }
}

