/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.primitives;

import com.agfa.pacs.data.shared.primitives.IntIterator;

public class IntHashMap<U> {
    private transient Entry<U>[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;

    public IntHashMap() {
        this(20, 0.75f);
    }

    public IntHashMap(int n) {
        this(n, 0.75f);
    }

    public IntHashMap(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load: " + f);
        }
        if (n == 0) {
            n = 1;
        }
        this.loadFactor = f;
        this.table = new Entry[n];
        this.threshold = (int)((float)n * f);
    }

    public int size() {
        return this.count;
    }

    public IntIterator getKeyIterator() {
        return new KeyIterator();
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Entry<U>[] entryArray = this.table;
        int n = entryArray.length;
        while (n-- > 0) {
            Entry<U> entry = entryArray[n];
            while (entry != null) {
                if (entry.value.equals(object)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public boolean containsValue(Object object) {
        return this.contains(object);
    }

    public boolean containsKey(int n) {
        Entry<U>[] entryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<U> entry = entryArray[n2];
        while (entry != null) {
            if (entry.key == n) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public U get(int n) {
        Entry<U>[] entryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<U> entry = entryArray[n2];
        while (entry != null) {
            if (entry.key == n) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    protected void rehash() {
        int n = this.table.length;
        Entry<U>[] entryArray = this.table;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = new Entry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry<U> entry = entryArray[n3];
            while (entry != null) {
                Entry<U> entry2 = entry;
                entry = entry.next;
                int n4 = (entry2.key & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    public U put(int n, U u) {
        Entry<U>[] entryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<U> entry = entryArray[n2];
        while (entry != null) {
            if (entry.key == n) {
                Object u2 = entry.value;
                entry.value = u;
                return u2;
            }
            entry = entry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            entryArray = this.table;
            n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        }
        entryArray[n2] = entry = new Entry<U>(n, u, entryArray[n2]);
        ++this.count;
        return null;
    }

    public U remove(int n) {
        Entry<U>[] entryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<U> entry = entryArray[n2];
        Entry<U> entry2 = null;
        while (entry != null) {
            if (entry.key == n) {
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    entryArray[n2] = entry.next;
                }
                --this.count;
                Object u = entry.value;
                entry.value = null;
                return u;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return null;
    }

    public synchronized void clear() {
        Entry<U>[] entryArray = this.table;
        int n = entryArray.length;
        while (--n >= 0) {
            entryArray[n] = null;
        }
        this.count = 0;
    }

    private static class Entry<U> {
        int key;
        U value;
        Entry<U> next;

        protected Entry(int n, U u, Entry<U> entry) {
            this.key = n;
            this.value = u;
            this.next = entry;
        }
    }

    private class KeyIterator
    implements IntIterator {
        private int index = -1;
        private Entry<U> nextEntry;

        public KeyIterator() {
            this.findNextEntry();
        }

        private void findNextEntry() {
            if (this.nextEntry != null) {
                this.nextEntry = this.nextEntry.next;
                if (this.nextEntry != null) {
                    return;
                }
            }
            ++this.index;
            while (this.index < IntHashMap.this.table.length && IntHashMap.this.table[this.index] == null) {
                ++this.index;
            }
            if (this.index < IntHashMap.this.table.length) {
                this.nextEntry = IntHashMap.this.table[this.index];
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextEntry != null;
        }

        @Override
        public int next() {
            int n = this.nextEntry.key;
            this.findNextEntry();
            return n;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

