/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.pixel;

import com.agfa.pacs.cache.ByteArrayContainer;
import com.agfa.pacs.cache.DataCacheProviderFactory;
import com.agfa.pacs.cache.IDataCacheProvider;
import com.agfa.pacs.data.shared.data.IDicomDataListener;
import com.agfa.pacs.data.shared.data.OutputStreamDicomDataWriter;
import com.agfa.pacs.data.shared.pixel.CachedPixelDataInfo;
import com.agfa.pacs.data.shared.pixel.DatasetImagePixel;
import com.agfa.pacs.data.shared.pixel.DecodedPixelDataInfo;
import com.agfa.pacs.data.shared.pixel.IImagePixel;
import com.agfa.pacs.data.shared.pixel.IPixelDataInfo;
import com.agfa.pacs.data.shared.pixel.PhotometricInterpretation;
import com.agfa.pacs.data.shared.pixel.PixelDataException;
import com.agfa.pacs.data.shared.pixel.PixelDataReader;
import com.agfa.pacs.data.shared.pixel.decoder.PixelDataDecoderFactory;
import com.agfa.pacs.data.shared.pixel.encoder.IPixelDataEncoder;
import com.agfa.pacs.data.shared.pixel.encoder.PixelDataEncoderFactory;
import com.agfa.pacs.logging.ALogger;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;

public class PixelDataTranscoder
implements IDicomDataListener {
    private static final PixelDataDecoderFactory decoder = PixelDataDecoderFactory.getInstance();
    private static final ALogger log = ALogger.getLogger(PixelDataTranscoder.class);
    private static final IDataCacheProvider cache = DataCacheProviderFactory.getCache();
    private IDicomDataListener writer;
    private String transferSyntaxUID;
    protected IPixelDataEncoder pixelDataEncoder;

    public PixelDataTranscoder(IDicomDataListener iDicomDataListener, String string, boolean bl) {
        this.writer = iDicomDataListener;
        this.transferSyntaxUID = string;
        if (!bl) {
            this.init();
        }
    }

    private void init() {
        if (this.transferSyntaxUID != null) {
            try {
                this.pixelDataEncoder = PixelDataEncoderFactory.getInstance().createPixelDataEncoder(this.transferSyntaxUID);
            }
            catch (PixelDataException pixelDataException) {
                log.error("Could not find Encoder", (Throwable)pixelDataException);
            }
        }
    }

    protected String getTransferSyntaxUID() {
        return this.transferSyntaxUID;
    }

    @Override
    public void dicomDataAvailable(String string, Attributes attributes, boolean bl) {
        String string2 = attributes.getString(131088, null);
        if (string2 == null) {
            string2 = "1.2.840.10008.1.2";
            attributes.setString(131088, VR.UI, "1.2.840.10008.1.2");
        }
        if (bl && !string2.equals(this.transferSyntaxUID) && !PixelDataDecoderFactory.getInstance().getSupportedTransferSyntaxUIDs().contains(string2)) {
            this.transferSyntaxUID = string2;
        }
        attributes = new Attributes(attributes);
        if (bl && !this.transferSyntaxUID.equals(attributes.getString(131088, null)) && attributes.getString(2621444, PhotometricInterpretation.Monochrome.dicom()).startsWith("YBR") && (this.transferSyntaxUID.equals("1.2.840.10008.1.2") || this.transferSyntaxUID.equals("1.2.840.10008.1.2.1"))) {
            attributes.setString(2621444, VR.CS, PhotometricInterpretation.RGBColor.dicom());
            attributes.setInt(2621446, VR.US, new int[]{0});
        }
        if (this.writer instanceof OutputStreamDicomDataWriter) {
            ((OutputStreamDicomDataWriter)this.writer).setTransferSyntaxUID(this.transferSyntaxUID);
        }
        this.writer.dicomDataAvailable(string, attributes, bl);
    }

    @Override
    public void dicomDataError(String string, String string2, Throwable throwable) {
        log.error("DicomDataError", throwable);
    }

    @Override
    public void dicomDataFinished(String string, IDicomDataListener.Status status, Attributes attributes) {
        this.writer.dicomDataFinished(string, status, attributes);
    }

    @Override
    public void pixelDataAvailable(String string, IPixelDataInfo iPixelDataInfo, int n) {
        String string2 = iPixelDataInfo.getTransferSyntaxUID();
        if (string2 != null) {
            if (string2.equals(this.transferSyntaxUID)) {
                this.writer.pixelDataAvailable(string, iPixelDataInfo, n);
            } else {
                PixelDataReader pixelDataReader = new PixelDataReader(iPixelDataInfo);
                try {
                    DatasetImagePixel datasetImagePixel = new DatasetImagePixel(iPixelDataInfo.getDescription());
                    Object object = null;
                    try {
                        object = decoder.decode((IImagePixel)datasetImagePixel, (ByteArrayContainer)pixelDataReader.getData(), string2);
                    }
                    catch (PixelDataException pixelDataException) {
                        log.warn("Could not decode data");
                        this.writer.pixelDataAvailable(string, iPixelDataInfo, n);
                        pixelDataReader.releaseData();
                        return;
                    }
                    try {
                        if (!string2.equals(this.transferSyntaxUID) && datasetImagePixel.getSamplesPerPixel() == 3 && datasetImagePixel.getPhotometricInterpretation() != PhotometricInterpretation.RGBColor && (this.transferSyntaxUID.equals("1.2.840.10008.1.2") || this.transferSyntaxUID.equals("1.2.840.10008.1.2.1"))) {
                            datasetImagePixel.setPhotometricInterpretation(PhotometricInterpretation.RGBColor);
                        }
                        if (this.transferSyntaxUID != null) {
                            byte[] byArray = this.pixelDataEncoder.encode(datasetImagePixel, object);
                            CachedPixelDataInfo cachedPixelDataInfo = CachedPixelDataInfo.createPDI(this.transferSyntaxUID, byArray, iPixelDataInfo.getDescription());
                            this.writer.pixelDataAvailable(string, cachedPixelDataInfo, n);
                            cache.remove(cachedPixelDataInfo.getCacheID());
                        }
                        this.writer.pixelDataAvailable(string, new DecodedPixelDataInfo(object, iPixelDataInfo.getDescription()), n);
                    }
                    catch (PixelDataException pixelDataException) {
                        log.error("Could not transcode", (Throwable)pixelDataException);
                    }
                }
                finally {
                    pixelDataReader.releaseData();
                }
            }
        } else if (this.transferSyntaxUID != null) {
            PixelDataReader pixelDataReader = new PixelDataReader(iPixelDataInfo);
            try {
                try {
                    DatasetImagePixel datasetImagePixel = new DatasetImagePixel(iPixelDataInfo.getDescription());
                    Object object = pixelDataReader.getData();
                    if (this.pixelDataEncoder == null) {
                        this.init();
                    }
                    byte[] byArray = this.pixelDataEncoder.encode(datasetImagePixel, object);
                    CachedPixelDataInfo cachedPixelDataInfo = CachedPixelDataInfo.createPDI(this.transferSyntaxUID, byArray, iPixelDataInfo.getDescription());
                    this.writer.pixelDataAvailable(string, cachedPixelDataInfo, n);
                }
                catch (PixelDataException pixelDataException) {
                    log.error("Could not transcode", (Throwable)pixelDataException);
                    pixelDataReader.releaseData();
                }
            }
            finally {
                pixelDataReader.releaseData();
            }
        } else {
            this.writer.pixelDataAvailable(string, iPixelDataInfo, n);
        }
    }
}

