/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.pixel;

import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.cache.DataCacheProviderFactory;
import com.agfa.pacs.cache.IDataCacheProvider;
import com.agfa.pacs.core.ApplicationManagement;
import com.agfa.pacs.data.shared.pixel.AgilityDatasetImagePixel;
import com.agfa.pacs.data.shared.pixel.DatasetImagePixel;
import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;
import com.agfa.pacs.data.shared.pixel.IPixelDataFrameProvider;
import com.agfa.pacs.data.shared.pixel.IPixelDataInfo;
import com.agfa.pacs.data.shared.pixel.PhotometricInterpretation;
import com.agfa.pacs.data.shared.pixel.PixelDataFramePixelDataInfo;
import com.agfa.pacs.data.shared.pixel.PixelDataFrameProvider;
import com.agfa.pacs.logging.ALogger;
import org.dcm4che3.data.Attributes;

public class PixelDataFrameUtilities {
    private static final IDataCacheProvider cache = DataCacheProviderFactory.getCache();
    public static final IPixelDataFrameProvider DefaultPixelDataFrameProvider = PixelDataFrameProvider.getInstance();
    private static final boolean isAgility = ApplicationManagement.getInstance().getApplicationType().isAgilityPlatform();
    private static final ALogger LOGGER = ALogger.getLogger(PixelDataFrameUtilities.class);

    public static IPixelDataFrame<?> createPixelDataFrame(Attributes attributes, Object object) {
        DatasetImagePixel datasetImagePixel = isAgility ? new AgilityDatasetImagePixel(attributes) : new DatasetImagePixel(attributes);
        CacheID cacheID = cache.createID();
        if (object instanceof byte[]) {
            cache.addPersistentBytes((byte[])object, cacheID);
        } else if (object instanceof short[]) {
            cache.addPersistentShorts((short[])object, cacheID);
        } else if (object instanceof int[]) {
            cache.addPersistentInts((int[])object, cacheID);
        }
        return DefaultPixelDataFrameProvider.createPixelDataFrame(attributes, cacheID, null, object.getClass(), datasetImagePixel);
    }

    private static IPixelDataFrame<?> createPixelDataFrame(IPixelDataFrameProvider iPixelDataFrameProvider, IPixelDataInfo iPixelDataInfo) {
        if (iPixelDataInfo instanceof PixelDataFramePixelDataInfo) {
            return ((PixelDataFramePixelDataInfo)iPixelDataInfo).getPixelDataFrame();
        }
        DatasetImagePixel datasetImagePixel = new DatasetImagePixel(iPixelDataInfo.getDescription());
        CacheID cacheID = iPixelDataInfo.getCacheID();
        if (cacheID == null) {
            cacheID = cache.createID();
            Object object = iPixelDataInfo.getData();
            if (object instanceof byte[]) {
                cache.addPersistentBytes((byte[])object, cacheID);
            }
            if (object instanceof short[]) {
                cache.addPersistentShorts((short[])object, cacheID);
            }
            if (object instanceof int[]) {
                cache.addPersistentInts((int[])object, cacheID);
            }
        }
        return iPixelDataFrameProvider.createPixelDataFrame(iPixelDataInfo.getDescription(), cacheID, null, iPixelDataInfo.getDataClass(), datasetImagePixel);
    }

    public static IPixelDataFrame<?> createPixelDataFrame(IPixelDataFrameProvider iPixelDataFrameProvider, IPixelDataInfo iPixelDataInfo, String string) {
        if (iPixelDataInfo.getTransferSyntaxUID() == null) {
            return PixelDataFrameUtilities.createPixelDataFrame(iPixelDataFrameProvider, iPixelDataInfo);
        }
        return PixelDataFrameUtilities.createPixelDataFrame(iPixelDataFrameProvider, iPixelDataInfo.getTransferSyntaxUID(), iPixelDataInfo.getDescription(), iPixelDataInfo.getCacheID(), string);
    }

    private static IPixelDataFrame<?> createPixelDataFrame(IPixelDataFrameProvider iPixelDataFrameProvider, String string, Attributes attributes, CacheID cacheID, String string2) {
        DatasetImagePixel datasetImagePixel = new DatasetImagePixel(attributes);
        int n = datasetImagePixel.getBitsAllocated();
        PhotometricInterpretation photometricInterpretation = datasetImagePixel.getPhotometricInterpretation();
        IPixelDataFrame<?> iPixelDataFrame = null;
        switch (photometricInterpretation) {
            case InverseMonochrome: 
            case Monochrome: 
            case IndexedColor: {
                Class<byte[]> clazz = null;
                if (n <= 8) {
                    clazz = byte[].class;
                }
                if (n > 8 && n <= 16) {
                    clazz = short[].class;
                }
                iPixelDataFrame = iPixelDataFrameProvider.createPixelDataFrame(attributes, cacheID, string, clazz, datasetImagePixel);
                break;
            }
            case RGBColor: 
            case YBRFull: 
            case YBRFull422: 
            case YBRPartial422: 
            case YBRPartial420: 
            case YBRIrreversibleColorTransforamtion: 
            case YBRReversibleColorTransforamtion: {
                iPixelDataFrame = iPixelDataFrameProvider.createPixelDataFrame(attributes, cacheID, string, int[].class, datasetImagePixel);
                break;
            }
            default: {
                LOGGER.warn("photometric Interpretation " + photometricInterpretation + " not impelmented ");
            }
        }
        return iPixelDataFrame;
    }
}

