/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.pixel;

import com.agfa.pacs.core.FactorySelector;
import com.agfa.pacs.data.shared.pixel.ICacheStorageDecision;
import com.agfa.pacs.data.shared.pixel.IImagePixel;
import java.util.List;

public abstract class CacheStorageDecisionFactory {
    private static CacheStorageDecisionFactory implementation;

    public static synchronized CacheStorageDecisionFactory getInstance() {
        if (implementation == null) {
            CacheStorageDecisionFactory.initialize();
        }
        return implementation;
    }

    public Boolean cacheDecompressedImages(IImagePixel iImagePixel) {
        List<ICacheStorageDecision> list = this.getStorageHandlerInt();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            Boolean bl = list.get(n2).cacheDecompressedImages(iImagePixel);
            if (bl != null) {
                return bl;
            }
            ++n2;
        }
        return true;
    }

    public Boolean cacheCompressedImages(IImagePixel iImagePixel) {
        for (ICacheStorageDecision iCacheStorageDecision : this.getStorageHandlerInt()) {
            Boolean bl = iCacheStorageDecision.cacheCompressedImages(iImagePixel);
            if (bl == null) continue;
            return bl;
        }
        return true;
    }

    public abstract List<ICacheStorageDecision> getStorageHandlerInt();

    private static synchronized void initialize() {
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            Class<?> clazz = Class.forName(FactorySelector.createFactory((String)CacheStorageDecisionFactory.class.getName()));
            implementation = (CacheStorageDecisionFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            reflectiveOperationException = classNotFoundException;
        }
        catch (InstantiationException instantiationException) {
            reflectiveOperationException = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            reflectiveOperationException = illegalAccessException;
        }
        if (reflectiveOperationException != null) {
            throw new RuntimeException("failed to create factory " + CacheStorageDecisionFactory.class.getName(), reflectiveOperationException);
        }
    }
}

