/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.node.config;

import com.agfa.pacs.config.IConfigurationList;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.data.shared.node.IDataInfoNode;
import com.agfa.pacs.data.shared.node.config.DataInfoNodeConfigurationUtilities;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.List;

public class DataInfoNodeConfiguration {
    private final String ROOT = "listtext.datanode";
    private IConfigurationProvider provider;

    public DataInfoNodeConfiguration(IConfigurationProvider iConfigurationProvider) {
        try {
            this.provider = iConfigurationProvider.getNode("listtext.datanode");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ALogger.getLogger(DataInfoNodeConfiguration.class).info("No datanode configuration found");
            iConfigurationProvider = null;
        }
    }

    public List<IDataInfoNode> getDataNodes() throws Exception {
        ArrayList<IDataInfoNode> arrayList = new ArrayList<IDataInfoNode>();
        if (this.provider == null) {
            return arrayList;
        }
        IConfigurationList iConfigurationList = this.provider.getList("datanodes");
        for (IConfigurationProvider iConfigurationProvider : iConfigurationList) {
            try {
                IDataInfoNode iDataInfoNode = DataInfoNodeConfigurationUtilities.getDataInfoNode(iConfigurationProvider);
                if (iDataInfoNode == null) continue;
                arrayList.add(iDataInfoNode);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ALogger.getLogger(DataInfoNodeConfiguration.class).warn("Not complete datanode configuration", (Throwable)illegalArgumentException);
            }
        }
        return arrayList;
    }

    public boolean hasExternalArchivesConfigured() {
        if (this.provider == null) {
            return false;
        }
        IConfigurationList iConfigurationList = this.provider.getList("datanodes");
        for (IConfigurationProvider iConfigurationProvider : iConfigurationList) {
            String string;
            if (!iConfigurationProvider.exists("type") || !(string = iConfigurationProvider.getString("type")).contains("DICOM") || string.equalsIgnoreCase("AGFADICOMWADO")) continue;
            return true;
        }
        return false;
    }

    public String getNameOfMasterArchive() {
        return this.provider.getString("mpiDatanode");
    }
}

