/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.lw.impl;

import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IDataInfoRetriever;
import com.agfa.pacs.data.shared.lw.IIntermediateDataInfo;
import com.agfa.pacs.data.shared.lw.impl.AbstractDataInfo;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dcm4che3.data.Attributes;

public abstract class IntermediateDataInfo
extends AbstractDataInfo
implements IIntermediateDataInfo {
    private static final ALogger log = ALogger.getLogger(IntermediateDataInfo.class);
    private volatile List<IDataInfo> children;
    protected volatile Set<String> duplicateCheck = new HashSet<String>();

    public IntermediateDataInfo(IDataInfo iDataInfo, String string) {
        super(iDataInfo, string);
    }

    public IntermediateDataInfo(Attributes attributes, IDataInfo iDataInfo, String string) {
        super(attributes, iDataInfo, string);
    }

    protected synchronized void initChildren() {
        this.children = new ArrayList<IDataInfo>();
    }

    @Override
    public synchronized void resetChildren() {
        if (this.source.getRetriever() != null) {
            this.children = null;
            this.duplicateCheck = new HashSet<String>();
        }
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    public List<IDataInfo> children() {
        return this.children(null, this);
    }

    @Override
    public List<IDataInfo> children(Level level) {
        return this.children(level, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IDataInfo> children(Level level, IDataInfo iDataInfo) {
        List<IDataInfo> list = this.children;
        if (list == null) {
            IntermediateDataInfo intermediateDataInfo = this;
            synchronized (intermediateDataInfo) {
                list = this.children;
                if (list == null) {
                    IDataInfoRetriever iDataInfoRetriever = null;
                    if (this.source != null) {
                        iDataInfoRetriever = this.source.getRetriever();
                    }
                    if (iDataInfoRetriever != null) {
                        this.children = list = iDataInfoRetriever.getDataInfo(iDataInfo, level);
                    }
                    if (list == null) {
                        this.children = list = new ArrayList<IDataInfo>(1);
                    }
                }
            }
        }
        return list;
    }

    @Override
    public synchronized IDataInfo deepCopy(boolean bl) {
        IntermediateDataInfo intermediateDataInfo;
        block5: {
            intermediateDataInfo = (IntermediateDataInfo)super.deepCopy(bl);
            if (intermediateDataInfo != null) break block5;
            return null;
        }
        try {
            if (this.children != null) {
                intermediateDataInfo.children = new ArrayList<IDataInfo>(this.children.size());
                for (IDataInfo iDataInfo : this.children) {
                    IDataInfo iDataInfo2 = iDataInfo.deepCopy(bl);
                    iDataInfo2.setTreeParent(intermediateDataInfo);
                    intermediateDataInfo.children.add(iDataInfo2);
                }
            }
            return intermediateDataInfo;
        }
        catch (Exception exception) {
            log.error("DataInfo deep copy error", (Throwable)exception);
            return null;
        }
    }

    @Override
    public boolean childrenAvailable() {
        return this.children != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addChild(IDataInfo iDataInfo) {
        if (iDataInfo == null) {
            return false;
        }
        List<IDataInfo> list = this.children;
        if (list == null) {
            IntermediateDataInfo intermediateDataInfo = this;
            synchronized (intermediateDataInfo) {
                list = this.children;
                if (list == null) {
                    this.children = list = new ArrayList<IDataInfo>();
                }
            }
        }
        if (this.duplicateCheck.contains(iDataInfo.getKey())) {
            return false;
        }
        this.duplicateCheck.add(iDataInfo.getKey());
        list.add(iDataInfo);
        iDataInfo.setTreeParent(this);
        return true;
    }

    @Override
    public void removeChild(IDataInfo iDataInfo) {
        if (this.children == null || iDataInfo == null) {
            return;
        }
        this.children.remove(iDataInfo);
        this.duplicateCheck.remove(iDataInfo.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChildren(Collection<? extends IDataInfo> collection) {
        List<IDataInfo> list = this.children;
        if (list == null) {
            IntermediateDataInfo iDataInfo = this;
            synchronized (iDataInfo) {
                list = this.children;
                if (this.children == null) {
                    this.children = list = new ArrayList<IDataInfo>();
                }
            }
        }
        for (IDataInfo iDataInfo : collection) {
            if (iDataInfo == null || this.duplicateCheck.contains(iDataInfo.getKey())) continue;
            this.duplicateCheck.add(iDataInfo.getKey());
            list.add(iDataInfo);
            iDataInfo.setTreeParent(this);
        }
    }
}

