/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.lw;

import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.data.shared.lw.DataInfoFactoryProvider;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IDataInfoFactory;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.data.shared.lw.IRootInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.node.IDataInfoNode;
import com.agfa.pacs.data.shared.util.PatientKeyUtils;
import com.agfa.pacs.tools.CompareUtils;
import com.agfa.pacs.tools.IDisposable;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;

public class DataInfoUtilities {
    private static final IDataInfoFactory factory = DataInfoFactoryProvider.getInstance();

    public static List<IDataInfo> intoList(IDataInfo iDataInfo) {
        return Collections.singletonList(iDataInfo);
    }

    public static IRootInfo createRoot() {
        return factory.createRootInfo();
    }

    public static IRootInfo createRoot(String string) {
        return factory.createRootInfo(string);
    }

    public static List<IDataInfo> extractChildrenBelongingToParent(IDataInfo iDataInfo, List<? extends IDataInfo> list) {
        ArrayList<IDataInfo> arrayList = new ArrayList<IDataInfo>();
        String string = iDataInfo.getKey();
        Iterator<? extends IDataInfo> iterator = list.iterator();
        block0: while (iterator.hasNext()) {
            IDataInfo iDataInfo2;
            IDataInfo iDataInfo3 = iDataInfo2 = iterator.next();
            do {
                if (!iDataInfo3.getKey().equals(string)) continue;
                arrayList.add(iDataInfo2);
                continue block0;
            } while ((iDataInfo3 = iDataInfo3.getTreeParent()).getTreeParent() != null);
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    public static List<IDataInfo> findLowestNodes(List<? extends IDataInfo> list) {
        ArrayList<IDataInfo> arrayList = new ArrayList<IDataInfo>();
        for (IDataInfo iDataInfo : list) {
            void iDataInfo2;
            IDataInfo iDataInfo3 = iDataInfo.getTreeParent();
            while (iDataInfo3 != null) {
                if (list.contains(iDataInfo3)) {
                    Object var2_5 = null;
                    break;
                }
                iDataInfo3 = iDataInfo3.getTreeParent();
            }
            if (iDataInfo2 == null) continue;
            arrayList.add((IDataInfo)iDataInfo2);
        }
        return arrayList;
    }

    public static IDataInfo findEqual(Collection<? extends IDataInfo> collection, IDataInfo iDataInfo) {
        if (collection != null) {
            for (IDataInfo iDataInfo2 : collection) {
                if (!iDataInfo2.equalsKey(iDataInfo)) continue;
                return iDataInfo2;
            }
        }
        return null;
    }

    public static boolean removeStumps(IDataInfo iDataInfo, Class<? extends IDataInfo> clazz) {
        if (clazz.isInstance(iDataInfo)) {
            return false;
        }
        if (iDataInfo.hasChildren()) {
            ArrayList<IDataInfo> arrayList = new ArrayList<IDataInfo>();
            List<? extends IDataInfo> list = iDataInfo.children();
            for (IDataInfo iDataInfo2 : list) {
                if (!DataInfoUtilities.removeStumps(iDataInfo2, clazz)) continue;
                arrayList.add(iDataInfo2);
            }
            for (IDataInfo iDataInfo2 : arrayList) {
                iDataInfo.removeChild(iDataInfo2);
            }
            return iDataInfo.children().isEmpty();
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static IRootInfo cloneDown(Collection<? extends IDataInfo> collection, Class<? extends IDataInfo> clazz, boolean bl) {
        if (bl) {
            collection = DataInfoUtilities.getLevel(collection, Level.Object);
        }
        IRootInfo iRootInfo = DataInfoFactoryProvider.getInstance().createRootInfo("ROOT");
        Hashtable<void, IDataInfo> hashtable = new Hashtable<void, IDataInfo>();
        block0: for (IDataInfo iDataInfo : collection) {
            void iDataInfo2;
            boolean bl2 = true;
            IDataInfo iDataInfo3 = null;
            IDataInfo iDataInfo4 = null;
            while (iDataInfo2 != null) {
                if (clazz.isInstance(iDataInfo2)) {
                    iRootInfo.addChild(iDataInfo4);
                    continue block0;
                }
                if (!hashtable.containsKey(iDataInfo2)) {
                    if (bl2) {
                        iDataInfo3 = iDataInfo2.deepCopy(true);
                        bl2 = false;
                    } else {
                        iDataInfo3 = iDataInfo2.copy(false);
                    }
                    hashtable.put(iDataInfo2, iDataInfo3);
                }
                iDataInfo3 = (IDataInfo)hashtable.get(iDataInfo2);
                iDataInfo3.addChild(iDataInfo4);
                IDataInfo iDataInfo5 = iDataInfo2.getTreeParent();
                iDataInfo4 = iDataInfo3;
            }
        }
        return iRootInfo;
    }

    public static IRootInfo mergeRoots(IRootInfo iRootInfo, IRootInfo iRootInfo2) {
        if (iRootInfo == null && iRootInfo2 == null) {
            return null;
        }
        if (!(iRootInfo != null && iRootInfo.childrenAvailable() || iRootInfo2 == null)) {
            return iRootInfo2;
        }
        if (!(iRootInfo == null || iRootInfo2 != null && iRootInfo2.childrenAvailable())) {
            return iRootInfo;
        }
        DataInfoUtilities.merge(iRootInfo, iRootInfo2, false, new CompareCache());
        return iRootInfo;
    }

    public static CompareCache createCompareCache() {
        return new CompareCache();
    }

    private static void merge(IDataInfo iDataInfo, IDataInfo iDataInfo2, boolean bl, CompareCache compareCache) {
        if (bl) {
            if (!compareCache.isSame(iDataInfo, iDataInfo2)) {
                return;
            }
            if (iDataInfo instanceof IObjectInfo) {
                DataInfoUtilities.mergeInstanceInfos(iDataInfo, iDataInfo2);
            }
        }
        if (iDataInfo2.childrenAvailable()) {
            List<? extends IDataInfo> list = iDataInfo.children();
            List<? extends IDataInfo> list2 = iDataInfo2.children();
            for (IDataInfo iDataInfo3 : list2) {
                IDataInfo iDataInfo4 = compareCache.findSame(list, iDataInfo3);
                if (iDataInfo4 != null) {
                    DataInfoUtilities.merge(iDataInfo4, iDataInfo3, true, compareCache);
                    continue;
                }
                iDataInfo.addChild(iDataInfo3);
            }
        }
    }

    public static void setSource(IDataInfo iDataInfo, IDataInfoSource iDataInfoSource) {
        iDataInfo.setSource(iDataInfoSource);
        if (iDataInfo.childrenAvailable()) {
            for (IDataInfo iDataInfo2 : iDataInfo.children()) {
                DataInfoUtilities.setSource(iDataInfo2, iDataInfoSource);
            }
        }
    }

    public static <U extends IDataInfo> List<U> getLevel(Collection<? extends IDataInfo> collection, Level level, ICancelationCallback iCancelationCallback) {
        if (collection.size() == 1) {
            return DataInfoUtilities.getLevel(collection.iterator().next(), level);
        }
        LinkedHashSet<IDataInfo> linkedHashSet = new LinkedHashSet<IDataInfo>();
        for (IDataInfo iDataInfo : collection) {
            if (iCancelationCallback != null && iCancelationCallback.shouldCancel()) break;
            int n = 1;
            if (iDataInfo.getHierarchyLevel() != null) {
                n = level.compareTo(iDataInfo.getHierarchyLevel());
            }
            if (n == 0) {
                linkedHashSet.add(iDataInfo);
                continue;
            }
            if (n > 0) {
                DataInfoUtilities.getLevelDown(iDataInfo, level, linkedHashSet, iCancelationCallback);
                continue;
            }
            DataInfoUtilities.getLevelUp(iDataInfo, level, linkedHashSet, iCancelationCallback);
        }
        return new ArrayList(linkedHashSet);
    }

    public static <U extends IDataInfo> List<U> getLevel(IDataInfo iDataInfo, Class<U> clazz) {
        return DataInfoUtilities.getLevel(iDataInfo, DataInfoUtilities.getLevelForClass(clazz));
    }

    public static <U extends IDataInfo> List<U> getLevel(IDataInfo iDataInfo, Level level) {
        ArrayList<IDataInfo> arrayList;
        int n = 1;
        if (iDataInfo.getHierarchyLevel() != null) {
            n = level.compareTo(iDataInfo.getHierarchyLevel());
        }
        if (n == 0) {
            arrayList = new ArrayList<IDataInfo>(2);
            arrayList.add(iDataInfo);
        } else if (n > 0) {
            HashSet<IDataInfo> hashSet = new HashSet<IDataInfo>();
            DataInfoUtilities.getLevelDown(iDataInfo, level, hashSet, null);
            arrayList = new ArrayList(hashSet.size());
            arrayList.addAll(hashSet);
        } else {
            do {
                if ((iDataInfo = iDataInfo.getTreeParent()) != null) continue;
                return Collections.emptyList();
            } while (iDataInfo.getHierarchyLevel() != level);
            arrayList = new ArrayList(2);
            arrayList.add(iDataInfo);
        }
        return arrayList;
    }

    public static <U extends IDataInfo> List<U> getLevel(Collection<? extends IDataInfo> collection, Class<U> clazz) {
        return DataInfoUtilities.getLevel(collection, DataInfoUtilities.getLevelForClass(clazz), null);
    }

    public static IRootInfo getRoot(IDataInfo iDataInfo) {
        while (iDataInfo.getTreeParent() != null) {
            iDataInfo = iDataInfo.getTreeParent();
        }
        if (iDataInfo instanceof IRootInfo) {
            return (IRootInfo)iDataInfo;
        }
        throw new IllegalArgumentException("No root found");
    }

    /*
     * WARNING - void declaration
     */
    public static List<IDataInfo> mergeDuplicates(List<? extends IDataInfo> list) {
        HashMap<String, IPatientInfo> hashMap = new HashMap<String, IPatientInfo>();
        for (IDataInfo iDataInfo : list) {
            void iDataInfo2;
            while (!(iDataInfo2 instanceof IPatientInfo)) {
                IDataInfo iDataInfo3 = iDataInfo2.getTreeParent();
            }
            if (!(iDataInfo2 instanceof IPatientInfo)) continue;
            IPatientInfo iPatientInfo = (IPatientInfo)hashMap.get(iDataInfo2.getKey());
            if (iPatientInfo == null) {
                hashMap.put(iDataInfo2.getKey(), (IPatientInfo)iDataInfo2);
                continue;
            }
            if (iDataInfo2 == iPatientInfo) continue;
            DataInfoUtilities.mergeData(iPatientInfo, (IDataInfo)iDataInfo2);
        }
        return new ArrayList<IDataInfo>(hashMap.values());
    }

    private static void mergeData(IDataInfo iDataInfo, IDataInfo iDataInfo2) {
        if (!(iDataInfo.hasChildren() && iDataInfo.childrenAvailable() && iDataInfo2.hasChildren() && iDataInfo2.childrenAvailable())) {
            return;
        }
        HashMap<String, IDataInfo> hashMap = new HashMap<String, IDataInfo>();
        for (IDataInfo iDataInfo3 : iDataInfo.children()) {
            hashMap.put(iDataInfo3.getKey(), iDataInfo3);
        }
        for (IDataInfo iDataInfo4 : iDataInfo2.children()) {
            IDataInfo iDataInfo5 = (IDataInfo)hashMap.get(iDataInfo4.getKey());
            if (iDataInfo5 == iDataInfo4) continue;
            if (iDataInfo5 == null) {
                iDataInfo.addChild(iDataInfo4);
                continue;
            }
            DataInfoUtilities.mergeData(iDataInfo5, iDataInfo4);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static List<IRootInfo> getRoots(Collection<? extends IDataInfo> collection) {
        LinkedHashSet<IRootInfo> linkedHashSet = new LinkedHashSet<IRootInfo>();
        for (IDataInfo iDataInfo : collection) {
            void iDataInfo2;
            while (iDataInfo2.getTreeParent() != null) {
                IDataInfo iDataInfo3 = iDataInfo2.getTreeParent();
            }
            if (!(iDataInfo2 instanceof IRootInfo)) continue;
            linkedHashSet.add((IRootInfo)iDataInfo2);
        }
        return new ArrayList<IRootInfo>(linkedHashSet);
    }

    public static <U extends IDataInfo> List<U> getLevel(Collection<? extends IDataInfo> collection, Class<U> clazz, ICancelationCallback iCancelationCallback) {
        return DataInfoUtilities.getLevel(collection, DataInfoUtilities.getLevelForClass(clazz), iCancelationCallback);
    }

    public static <U extends IDataInfo> List<U> getLevel(Collection<? extends IDataInfo> collection, Level level) {
        return DataInfoUtilities.getLevel(collection, level, null);
    }

    private static boolean studyComplete(IStudyInfo iStudyInfo) {
        if (!iStudyInfo.childrenAvailable()) {
            return false;
        }
        int n = iStudyInfo.getInt(2101766);
        return n == iStudyInfo.children().size();
    }

    public static List<IObjectInfo> getObjectLevel(Collection<? extends IDataInfo> collection) {
        for (IStudyInfo iStudyInfo : DataInfoUtilities.getLevel(collection, IStudyInfo.class)) {
            if (!DataInfoUtilities.studyComplete(iStudyInfo) || iStudyInfo.children().get(0).childrenAvailable()) continue;
            iStudyInfo.resetChildren();
        }
        return DataInfoUtilities.getLevel(collection, Level.Object);
    }

    public static List<IObjectInfo> getObjectLevel(IStudyInfo iStudyInfo) {
        if (DataInfoUtilities.studyComplete(iStudyInfo) && !iStudyInfo.children().get(0).childrenAvailable()) {
            iStudyInfo.resetChildren();
        }
        return DataInfoUtilities.getLevel((IDataInfo)iStudyInfo, Level.Object);
    }

    public static List<IObjectInfo> getExpandedObjects(IDataInfo iDataInfo) {
        ArrayDeque<? extends IDataInfo> arrayDeque = new ArrayDeque<IDataInfo>(64);
        ArrayList<IObjectInfo> arrayList = new ArrayList<IObjectInfo>();
        arrayDeque.add(iDataInfo);
        while (!arrayDeque.isEmpty()) {
            IDataInfo iDataInfo2 = (IDataInfo)arrayDeque.poll();
            if (iDataInfo2.getHierarchyLevel() == Level.Object) {
                arrayList.add((IObjectInfo)iDataInfo2);
                continue;
            }
            if (!iDataInfo2.childrenAvailable()) continue;
            arrayDeque.addAll(iDataInfo2.children());
        }
        return arrayList;
    }

    private static Level getLevelForClass(Class<? extends IDataInfo> clazz) {
        if (IPatientInfo.class.isAssignableFrom(clazz)) {
            return Level.Patient;
        }
        if (IStudyInfo.class.isAssignableFrom(clazz)) {
            return Level.Study;
        }
        if (ISeriesInfo.class.isAssignableFrom(clazz)) {
            return Level.Series;
        }
        return Level.Object;
    }

    private static void getLevelUp(IDataInfo iDataInfo, Level level, Set<IDataInfo> set, ICancelationCallback iCancelationCallback) {
        while (iDataInfo != null) {
            if (iCancelationCallback != null && iCancelationCallback.shouldCancel()) break;
            if (iDataInfo.getHierarchyLevel() == level) {
                set.add(iDataInfo);
                return;
            }
            iDataInfo = iDataInfo.getTreeParent();
        }
    }

    private static void getLevelDown(IDataInfo iDataInfo, Level level, Set<IDataInfo> set, ICancelationCallback iCancelationCallback) {
        if (!iDataInfo.hasChildren()) {
            return;
        }
        List<IDataInfo> list = iDataInfo.children(level);
        if (list.size() == 0) {
            return;
        }
        if (list.get(0).getHierarchyLevel() == level) {
            set.addAll(list);
        } else {
            for (IDataInfo iDataInfo2 : list) {
                if (iCancelationCallback != null && iCancelationCallback.shouldCancel()) break;
                DataInfoUtilities.getLevelDown(iDataInfo2, level, set, iCancelationCallback);
            }
        }
    }

    public static String compilePatientKey(Attributes attributes) {
        return PatientKeyUtils.generatePatientKey(attributes);
    }

    private static void mergeInstanceInfos(IDataInfo iDataInfo, IDataInfo iDataInfo2) {
        boolean bl = false;
        IDataInfoSource iDataInfoSource = iDataInfo.getSource();
        IDataInfoSource iDataInfoSource2 = iDataInfo2.getSource();
        if (iDataInfoSource instanceof IDataInfoNode && iDataInfoSource2 instanceof IDataInfoNode) {
            int n;
            int n2 = ((IDataInfoNode)iDataInfoSource).getOrderId();
            boolean bl2 = bl = n2 > (n = ((IDataInfoNode)iDataInfoSource2).getOrderId());
        }
        if (!(iDataInfo instanceof IObjectInfo) || !(iDataInfo2 instanceof IObjectInfo)) {
            return;
        }
        IObjectInfo iObjectInfo = (IObjectInfo)iDataInfo;
        IObjectInfo iObjectInfo2 = (IObjectInfo)iDataInfo2;
        if (bl) {
            iObjectInfo.setInstanceInfo(iObjectInfo2.getInstanceInfo());
        }
    }

    public static Map<String, WeakReference<IDisposable>> forStudyManagment(List<? extends IDataInfo> list) {
        HashMap<String, WeakReference<IDisposable>> hashMap = new HashMap<String, WeakReference<IDisposable>>();
        List<IStudyInfo> list2 = DataInfoUtilities.getLevel(list, Level.Study);
        for (IStudyInfo iStudyInfo : list2) {
            hashMap.put(iStudyInfo.getKey(), new WeakReference<IStudyInfo>(iStudyInfo));
        }
        return hashMap;
    }

    public static List<String> extractInstanceUIDs(IDataInfo iDataInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<IObjectInfo> list = DataInfoUtilities.getLevel(iDataInfo, Level.Object);
        for (IObjectInfo iObjectInfo : list) {
            arrayList.add(iObjectInfo.getSOPInstanceUID());
        }
        return arrayList;
    }

    public static List<String> extractKeys(List<? extends IDataInfo> list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (IDataInfo iDataInfo : list) {
            arrayList.add(iDataInfo.getKey());
        }
        return arrayList;
    }

    public static List<String> extractInstanceUIDs(List<? extends IDataInfo> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<IObjectInfo> list2 = DataInfoUtilities.getLevel(list, Level.Object);
        for (IObjectInfo iObjectInfo : list2) {
            arrayList.add(iObjectInfo.getSOPInstanceUID());
        }
        return arrayList;
    }

    public static List<Attributes> toAttributes(List<? extends IDataInfo> list) {
        ArrayList<Attributes> arrayList = new ArrayList<Attributes>(list.size());
        for (IDataInfo iDataInfo : list) {
            arrayList.add(iDataInfo.getAttributes());
        }
        return arrayList;
    }

    public static List<Attributes> toAttributesMerged(Collection<? extends IDataInfo> collection) {
        ArrayList<Attributes> arrayList = new ArrayList<Attributes>(collection.size());
        for (IDataInfo iDataInfo : collection) {
            arrayList.add(iDataInfo.getDicomObjectMerged());
        }
        return arrayList;
    }

    public static List<Attributes> forAuditing(List<? extends IDataInfo> list) {
        List<IStudyInfo> list2 = DataInfoUtilities.getLevel(list, Level.Study);
        ArrayList<Attributes> arrayList = new ArrayList<Attributes>();
        for (IStudyInfo iStudyInfo : list2) {
            Attributes attributes = new Attributes();
            Attributes attributes2 = iStudyInfo.getTreeParent().getAttributes();
            attributes.setString(0x100020, VR.LO, attributes2.getString(0x100020, null));
            if (attributes2.getString(0x100021, null) != null) {
                attributes.setString(0x100021, VR.LO, attributes2.getString(0x100021, null));
            }
            if (attributes2.getString(0x100010, null) != null) {
                attributes.setString(0x100010, VR.PN, attributes2.getString(0x100010, null));
            }
            attributes.setString(0x20000D, VR.UI, iStudyInfo.getStudyUID());
            if (iStudyInfo.getAttributes().containsValue(524368)) {
                attributes.setString(524368, VR.SH, iStudyInfo.getAttributes().getString(524368, null));
            }
            arrayList.add(attributes);
        }
        return arrayList;
    }

    public static List<Attributes> forInstanceLevelAuditing(List<? extends IDataInfo> list) {
        List<IObjectInfo> list2 = DataInfoUtilities.getLevel(list, Level.Object);
        ArrayList<Attributes> arrayList = new ArrayList<Attributes>(list2.size());
        for (IObjectInfo iObjectInfo : list2) {
            Attributes attributes = DataInfoUtilities.createInstanceReference(iObjectInfo);
            arrayList.add(attributes);
        }
        return arrayList;
    }

    private static Attributes createInstanceReference(IObjectInfo iObjectInfo) {
        Attributes attributes;
        Attributes attributes2 = new Attributes();
        IPatientInfo iPatientInfo = null;
        IStudyInfo iStudyInfo = null;
        ISeriesInfo iSeriesInfo = iObjectInfo.getSeries();
        if (iSeriesInfo != null && (iStudyInfo = iSeriesInfo.getStudy()) != null) {
            iPatientInfo = iStudyInfo.getPatient();
        }
        if (iPatientInfo != null) {
            attributes = iPatientInfo.getAttributes();
            attributes2.setString(0x100020, VR.LO, attributes.getString(0x100020, null));
            if (attributes.getString(0x100021, null) != null) {
                attributes2.setString(0x100021, VR.LO, attributes.getString(0x100021, null));
            }
            if (attributes.getString(0x100010, null) != null) {
                attributes2.setString(0x100010, VR.PN, attributes.getString(0x100010, null));
            }
        } else {
            attributes2.setString(0x100020, VR.LO, iObjectInfo.getAttributes().getString(0x100020, ""));
        }
        if (iStudyInfo != null) {
            attributes = iStudyInfo.getAttributes();
            attributes2.setString(0x20000D, VR.UI, iStudyInfo.getStudyUID());
            if (attributes.containsValue(524368)) {
                attributes2.setString(524368, VR.SH, attributes.getString(524368, null));
            }
        } else {
            attributes2.setString(0x20000D, VR.UI, iObjectInfo.getAttributes().getString(0x20000D));
        }
        attributes2.setString(0x20000E, VR.UI, iObjectInfo.getSeriesUID());
        attributes2.setString(524312, VR.UI, iObjectInfo.getSOPInstanceUID());
        attributes2.setString(524310, VR.UI, iObjectInfo.getSOPClassUID());
        return attributes2;
    }

    public static List<IDataInfo> cloneData(List<? extends IDataInfo> list) {
        return DataInfoUtilities.cloneData(list, false);
    }

    public static List<IDataInfo> cloneData(List<? extends IDataInfo> list, boolean bl) {
        ArrayList<IDataInfo> arrayList = new ArrayList<IDataInfo>(list.size());
        HashMap<String, IDataInfo> hashMap = new HashMap<String, IDataInfo>(list.size() * 2);
        for (IDataInfo iDataInfo : list) {
            IDataInfo iDataInfo2 = iDataInfo.deepCopy(bl);
            if (!bl && iDataInfo2.getHierarchyLevel() == Level.Patient) {
                iDataInfo2.setAttributes(new Attributes(iDataInfo2.getAttributes()));
            }
            arrayList.add(iDataInfo2);
            hashMap.put(String.valueOf(DataInfoUtilities.getLevel(iDataInfo)) + iDataInfo.getKey(), iDataInfo2);
            DataInfoUtilities.cloneUp(iDataInfo, iDataInfo2, hashMap);
        }
        hashMap.clear();
        return arrayList;
    }

    private static String getLevel(IDataInfo iDataInfo) {
        Level level = iDataInfo.getHierarchyLevel();
        if (level == null) {
            return "";
        }
        return level.dicom();
    }

    private static void cloneUp(IDataInfo iDataInfo, IDataInfo iDataInfo2, Map<String, IDataInfo> map) {
        IDataInfo iDataInfo3 = null;
        if (iDataInfo.getTreeParent() == null) {
            return;
        }
        IDataInfo iDataInfo4 = iDataInfo.getTreeParent();
        iDataInfo3 = map.get(String.valueOf(DataInfoUtilities.getLevel(iDataInfo4)) + iDataInfo4.getKey());
        if (iDataInfo3 == null) {
            iDataInfo3 = iDataInfo4.getHierarchyLevel() == Level.Patient ? iDataInfo4.copy(true) : iDataInfo4.copy(false);
            map.put(String.valueOf(DataInfoUtilities.getLevel(iDataInfo4)) + iDataInfo4.getKey(), iDataInfo3);
            DataInfoUtilities.cloneUp(iDataInfo4, iDataInfo3, map);
        }
        iDataInfo3.addChild(iDataInfo2);
    }

    public static List<IStudyInfo> cloneAndCutBelowStudies(Collection<IStudyInfo> collection) {
        ArrayList<IStudyInfo> arrayList = new ArrayList<IStudyInfo>();
        HashMap<String, IDataInfo> hashMap = new HashMap<String, IDataInfo>();
        IStudyInfo iStudyInfo = null;
        for (IStudyInfo iStudyInfo2 : collection) {
            iStudyInfo = iStudyInfo2.getSource().getRetriever() == null ? (IStudyInfo)iStudyInfo2.deepCopy(false) : (IStudyInfo)iStudyInfo2.copy(false);
            arrayList.add(iStudyInfo);
            DataInfoUtilities.cloneUp(iStudyInfo2, iStudyInfo, hashMap);
        }
        return arrayList;
    }

    public static final class CompareCache {
        public final boolean isSame(IDataInfo iDataInfo, IDataInfo iDataInfo2) {
            if (iDataInfo instanceof IPatientInfo && iDataInfo2 instanceof IPatientInfo) {
                return CompareUtils.equals((Object)iDataInfo.getKey(), (Object)iDataInfo2.getKey());
            }
            return iDataInfo.getKey().equals(iDataInfo2.getKey());
        }

        public final IDataInfo findSame(List<? extends IDataInfo> list, IDataInfo iDataInfo) {
            for (IDataInfo iDataInfo2 : list) {
                if (!this.isSame(iDataInfo, iDataInfo2)) continue;
                return iDataInfo2;
            }
            return null;
        }
    }

    public static interface ICancelationCallback {
        public boolean shouldCancel();
    }
}

