/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.instanceinfo.impl;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.data.shared.instanceinfo.IOverlayAccessor;
import com.agfa.pacs.data.shared.instanceinfo.impl.URLInstanceInfo;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.StringTools;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

public class AgilityWadoImageInstanceInfo
extends URLInstanceInfo {
    private static final ALogger LOGGER = ALogger.getLogger(AgilityWadoImageInstanceInfo.class);
    protected static final String USE_MULTIPART_WADO_CONFIG = "com.agfa.pacs.data.lw.useMultipartWado";
    private String tsUID;
    private double x0;
    private double y0;
    private double x1;
    private double y1;
    private int columns;
    private int rows;
    private boolean multipart;
    String imageMimeType = "";
    private final IOverlayAccessor overlayAccessor;
    private final int frameNumber;

    public AgilityWadoImageInstanceInfo(URL uRL, double d, double d2, double d3, double d4, int n, int n2, String string, IOverlayAccessor iOverlayAccessor, int n3) {
        super(uRL);
        this.x0 = d;
        this.y0 = d2;
        this.x1 = d3;
        this.y1 = d4;
        this.columns = n;
        this.rows = n2;
        this.tsUID = string;
        this.overlayAccessor = iOverlayAccessor;
        this.frameNumber = n3;
        boolean bl = false;
        if ("1.2.840.10008.1.2.4.51".equals(string)) {
            bl = true;
        }
        this.setMultipart(this.shouldBeMultipart(bl));
    }

    public AgilityWadoImageInstanceInfo(URL uRL) {
        this(uRL, 0.0, 0.0, 0.0, 0.0, 0, 0, null, null, 0);
    }

    public IOverlayAccessor getOverlayAccessor() {
        return this.overlayAccessor;
    }

    public AgilityWadoImageInstanceInfo(URL uRL, int n, int n2, String string, IOverlayAccessor iOverlayAccessor, int n3) {
        this(uRL, 0.0, 0.0, 0.0, 0.0, n, n2, string, iOverlayAccessor, n3);
    }

    protected boolean shouldBeMultipart(boolean bl) {
        boolean bl2 = false;
        if (bl) {
            IConfigurationProvider iConfigurationProvider = ConfigurationProviderFactory.getConfig();
            if (iConfigurationProvider.exists(USE_MULTIPART_WADO_CONFIG)) {
                bl2 = iConfigurationProvider.getBoolean(USE_MULTIPART_WADO_CONFIG);
            }
        } else {
            bl2 = false;
        }
        return bl2;
    }

    @Override
    public URL getURL() {
        boolean bl = false;
        if ("1.2.840.10008.1.2.4.51".equals(this.tsUID)) {
            bl = true;
        }
        String string = super.getURIString();
        String string2 = string.substring(0, string.indexOf(63) + 1);
        Map map = StringTools.parseParameterMap((String)string.substring(string2.length()), (String)"&");
        map.remove("useOrig");
        if (this.rows != 0) {
            map.put("columns", Integer.toString(this.columns));
            map.put("rows", Integer.toString(this.rows));
        }
        if (this.x1 != 0.0) {
            map.put("region", String.valueOf(this.x0) + "," + this.y0 + "," + this.x1 + "," + this.y1);
        }
        String string3 = "";
        if (bl) {
            string3 = "image%2fjp12";
            this.setImageMimeType("image/jp12");
        } else {
            string3 = "image%2fjpeg";
            this.setImageMimeType("image/jpeg");
        }
        if (this.isMultipart()) {
            string3 = "multipart%2fmixed," + string3;
        }
        map.put("contentType", string3);
        map.put("frameNumber", Integer.toString(this.frameNumber));
        try {
            return new URL(String.valueOf(string2) + StringTools.composeParameterString((Map)map, (String)"&"));
        }
        catch (MalformedURLException malformedURLException) {
            LOGGER.warn("Error building URL", (Throwable)malformedURLException);
            return null;
        }
    }

    public String getTSUID() {
        return this.tsUID;
    }

    private void setMultipart(boolean bl) {
        this.multipart = bl;
    }

    public boolean isMultipart() {
        return this.multipart;
    }

    public String getImageMimeType() {
        return this.imageMimeType;
    }

    protected void setImageMimeType(String string) {
        this.imageMimeType = string;
    }
}

