/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.icon.impl;

import com.agfa.pacs.data.shared.icon.DefaultIconFactory;
import com.agfa.pacs.data.shared.icon.IIconInfo;
import com.agfa.pacs.data.shared.icon.IIconProviderListener;
import com.agfa.pacs.data.shared.icon.IconException;
import com.agfa.pacs.logging.ALogger;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;

public class ImageIconInfo
implements IIconInfo {
    private static final MediaTracker tracker = new MediaTracker(new Component(){});
    private static final ALogger log = ALogger.getLogger(ImageIconInfo.class);
    private BufferedImage image = null;
    private boolean isDefaultIcon = false;

    public ImageIconInfo(BufferedImage bufferedImage, boolean bl) {
        this.image = bufferedImage;
        this.isDefaultIcon = bl;
    }

    public ImageIconInfo(Image image, boolean bl) {
        this.isDefaultIcon = bl;
        try {
            try {
                tracker.addImage(image, image.hashCode());
                tracker.waitForID(image.hashCode());
                int n = tracker.statusID(image.hashCode(), true);
                if ((n & 4) != 0) {
                    throw new IconException("Cannot load Icon");
                }
                this.image = new BufferedImage(image.getWidth(null), image.getHeight(null), 5);
                this.image.getGraphics().drawImage(image, 0, 0, null);
            }
            catch (Exception exception) {
                log.error("Could not load icon:", (Throwable)exception);
                try {
                    image = DefaultIconFactory.getInstance().getDefaultIcon("1.2.840.10008.5.1.4.1.1.2").getImage();
                }
                catch (IconException iconException) {}
                tracker.removeImage(image, image.hashCode());
            }
        }
        finally {
            tracker.removeImage(image, image.hashCode());
        }
    }

    @Override
    public BufferedImage getImage() throws IconException {
        return this.image;
    }

    @Override
    public BufferedImage getImageAsync(IIconProviderListener iIconProviderListener) throws IconException {
        return this.image;
    }

    @Override
    public boolean isDefaultIcon() {
        return this.isDefaultIcon;
    }

    @Override
    public void release(BufferedImage bufferedImage) {
    }
}

