/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.icon.impl;

import com.agfa.pacs.data.shared.icon.IIconInfo;
import com.agfa.pacs.data.shared.icon.IIconProvider;
import com.agfa.pacs.data.shared.icon.IIconProviderListener;
import com.agfa.pacs.data.shared.icon.IconException;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.logging.ALogger;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class IconNotifier
extends Thread {
    private static final ALogger log = ALogger.getLogger(IconNotifier.class);
    private static final int MAX_BUCKET_SIZE = 100;
    private BlockingQueue<IconPair> queue = new LinkedBlockingQueue<IconPair>();

    public IconNotifier() {
        super("IconNotification");
    }

    public void add(IObjectInfo iObjectInfo, IIconProviderListener iIconProviderListener, IIconProvider iIconProvider, int n) {
        this.queue.add(new IconPair(iObjectInfo, iIconProviderListener, iIconProvider, n));
    }

    @Override
    public void run() {
        ArrayList<IconPair> arrayList = new ArrayList<IconPair>(100);
        IconPair iconPair = null;
        while (true) {
            try {
                Thread.sleep(500L);
                iconPair = this.queue.poll(4000L, TimeUnit.MILLISECONDS);
                if (iconPair != null) {
                    arrayList.add(iconPair);
                }
                while (!this.queue.isEmpty() && arrayList.size() < 100) {
                    iconPair = (IconPair)this.queue.poll();
                    if (iconPair == null) continue;
                    arrayList.add(iconPair);
                }
            }
            catch (InterruptedException interruptedException) {}
            for (IconPair iconPair2 : arrayList) {
                iconPair2.setIcon(iconPair2.provider.getIcon(iconPair2.data, iconPair2.frameNumber));
            }
            for (IconPair iconPair2 : arrayList) {
                try {
                    BufferedImage bufferedImage = iconPair2.getIcon().getImage();
                    iconPair2.listener.iconAvailable(iconPair2.data, iconPair2.getIcon(), bufferedImage);
                    bufferedImage.flush();
                }
                catch (IconException iconException) {
                    log.debug("Icon loading problem", (Throwable)iconException);
                }
                catch (Exception exception) {
                    log.error("Icon loading problem", (Throwable)exception);
                }
            }
            arrayList.clear();
        }
    }

    private static class IconPair {
        public final IObjectInfo data;
        public final IIconProviderListener listener;
        private final IIconProvider provider;
        private IIconInfo icon;
        private int frameNumber;

        public IconPair(IObjectInfo iObjectInfo, IIconProviderListener iIconProviderListener, IIconProvider iIconProvider, int n) {
            this.data = iObjectInfo;
            this.listener = iIconProviderListener;
            this.provider = iIconProvider;
            this.frameNumber = n;
        }

        public IIconInfo getIcon() {
            return this.icon;
        }

        public void setIcon(IIconInfo iIconInfo) {
            this.icon = iIconInfo;
        }
    }
}

