/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.hw;

import com.agfa.pacs.core.FactorySelector;
import com.agfa.pacs.data.shared.hw.DicomRetrieverProviderProxy;
import com.agfa.pacs.data.shared.hw.IDicomRetrieverProvider;
import com.agfa.pacs.data.shared.instanceinfo.IInstanceInfo;
import com.agfa.pacs.data.shared.lw.ILoadableInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class DicomRetrieverProviderFactory {
    private static DicomRetrieverProviderFactory implementation;
    private Map<Class<?>, IDicomRetrieverProvider> providerCache = new ConcurrentHashMap();

    public static synchronized DicomRetrieverProviderFactory getInstance() {
        if (implementation == null) {
            DicomRetrieverProviderFactory.initialize();
        }
        return implementation;
    }

    public void setUseCache(boolean bl) {
        this.providerCache = bl ? new HashMap() : null;
    }

    public IDicomRetrieverProvider getProvider(IInstanceInfo iInstanceInfo, ILoadableInfo iLoadableInfo) {
        if (iInstanceInfo == null) {
            return null;
        }
        IDicomRetrieverProvider iDicomRetrieverProvider = null;
        if (this.providerCache != null) {
            iDicomRetrieverProvider = this.providerCache.get(iInstanceInfo.getClass());
        }
        if (iDicomRetrieverProvider != null && iDicomRetrieverProvider.canRetrieve(iInstanceInfo, iLoadableInfo)) {
            return iDicomRetrieverProvider;
        }
        List<DicomRetrieverProviderProxy> list = implementation.getIDicomRetrieverFactoriesInt();
        for (DicomRetrieverProviderProxy dicomRetrieverProviderProxy : list) {
            if (!dicomRetrieverProviderProxy.canRetrieve(iInstanceInfo, iLoadableInfo)) continue;
            if (this.providerCache != null) {
                this.providerCache.put(iInstanceInfo.getClass(), dicomRetrieverProviderProxy.getProvider());
            }
            return dicomRetrieverProviderProxy;
        }
        return null;
    }

    public boolean canRetrieve(IInstanceInfo iInstanceInfo, ILoadableInfo iLoadableInfo) {
        IDicomRetrieverProvider iDicomRetrieverProvider = this.getProvider(iInstanceInfo, iLoadableInfo);
        return iDicomRetrieverProvider != null;
    }

    protected abstract List<DicomRetrieverProviderProxy> getIDicomRetrieverFactoriesInt();

    private static synchronized void initialize() {
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            Class<?> clazz = Class.forName(FactorySelector.createFactory((String)DicomRetrieverProviderFactory.class.getName()));
            implementation = (DicomRetrieverProviderFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            reflectiveOperationException = classNotFoundException;
        }
        catch (InstantiationException instantiationException) {
            reflectiveOperationException = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            reflectiveOperationException = illegalAccessException;
        }
        if (reflectiveOperationException != null) {
            throw new RuntimeException("failed to create factory " + DicomRetrieverProviderFactory.class.getName(), reflectiveOperationException);
        }
    }
}

