/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.dicom;

import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dcm4che3.net.TransferCapability;

public class UIDMap {
    private Map<String, Set<String>> map = new HashMap<String, Set<String>>();
    private Map<String, byte[]> extInfo = new HashMap<String, byte[]>();

    public void addTransferSyntaxUID(String string, String string2) {
        Set<String> set = this.map.get(string);
        if (set == null) {
            set = new LinkedHashSet<String>();
            this.map.put(string, set);
        }
        set.add(string2);
    }

    public void addTransferSyntaxUIDs(String string, String[] stringArray) {
        this.addTransferSyntaxUIDs(string, Arrays.asList(stringArray));
    }

    public void addTransferSyntaxUIDs(String string, Collection<String> collection) {
        Set<String> set = this.map.get(string);
        if (set == null) {
            set = new LinkedHashSet<String>();
            this.map.put(string, set);
        }
        set.addAll(collection);
    }

    public void addTransferSyntaxUIDs(List<String> list, Collection<String> collection) {
        for (String string : list) {
            this.addTransferSyntaxUIDs(string, collection);
        }
    }

    public void setTransferSyntaxUIDs(String string, Set<String> set) {
        this.map.put(string, set);
    }

    public void addClassUID(String string) {
        if (!this.map.containsKey(string)) {
            this.map.put(string, new HashSet());
        }
    }

    public void addUIDMap(UIDMap uIDMap) {
        for (String string : uIDMap.getClassUIDs()) {
            this.addTransferSyntaxUIDs(string, uIDMap.getTransferSyntaxUIDs(string));
        }
    }

    public void replaceByUIDMap(UIDMap uIDMap) {
        this.map.clear();
        this.extInfo.clear();
        for (String string : uIDMap.getClassUIDs()) {
            this.addTransferSyntaxUIDs(string, uIDMap.getTransferSyntaxUIDs(string));
        }
    }

    public Set<String> getTransferSyntaxUIDs(String string) {
        Set<String> set = this.map.get(string);
        if (set == null) {
            set = this.map.get(null);
        }
        return set;
    }

    public String[] getTransferSyntaxUIDArray(String string) {
        Set<String> set = this.getTransferSyntaxUIDs(string);
        if (set == null) {
            return null;
        }
        return set.toArray(new String[set.size()]);
    }

    public void removeTransferSyntaxUID(String string, String string2) {
        if (!this.map.containsKey(string)) {
            return;
        }
        this.map.get(string).remove(string2);
        if (this.map.get(string).isEmpty()) {
            this.map.remove(string);
        }
    }

    public void removeTransferUIDs(String string, String[] stringArray) {
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            this.removeTransferSyntaxUID(string, string2);
            ++n2;
        }
    }

    public void removeClassUID(String string) {
        this.map.remove(string);
    }

    public Collection<String> getClassUIDs() {
        ArrayList<String> arrayList = new ArrayList<String>(this.map.size());
        for (String string : this.map.keySet()) {
            if (string == null) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public void setExtInfo(String string, byte[] byArray) {
        this.extInfo.put(string, byArray);
    }

    public TransferCapability[] getTransferCapabilitiesArray(boolean bl) {
        return this.getTransferCapabilities(bl).toArray(new TransferCapability[0]);
    }

    public List<TransferCapability> getTransferCapabilities(boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>(this.map.keySet());
        ArrayList<TransferCapability> arrayList2 = new ArrayList<TransferCapability>();
        for (String string : arrayList) {
            if (string == null) continue;
            TransferCapability transferCapability = new TransferCapability(null, string, bl ? TransferCapability.Role.SCP : TransferCapability.Role.SCU, this.getTransferSyntaxUIDArray(string));
            arrayList2.add(transferCapability);
        }
        return arrayList2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Map.Entry<String, Set<String>> entry : this.map.entrySet()) {
            stringBuffer.append(entry.getKey());
            stringBuffer.append("\n");
            for (String string : entry.getValue()) {
                stringBuffer.append("  ");
                stringBuffer.append(string);
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    public static UIDMap createUIDMap(Collection<String> collection) {
        return UIDMap.createUIDMap(collection, UIDUtilities.getDefaultTransferSyntaxUIDs(), UIDUtilities.getImageTransferSyntaxUIDs());
    }

    public static UIDMap createUIDMap(Collection<String> collection, String[] stringArray, String[] stringArray2) {
        return UIDMap.createUIDMap(collection, Arrays.asList(stringArray), Arrays.asList(stringArray2));
    }

    public static UIDMap createUIDMap(Collection<String> collection, Collection<String> collection2, Collection<String> collection3) {
        UIDMap uIDMap = new UIDMap();
        uIDMap.addTransferSyntaxUIDs((String)null, collection2);
        for (String string : collection) {
            if (UIDUtilities.isType(string, UIDType.Image)) {
                uIDMap.addTransferSyntaxUIDs(string, collection3);
                continue;
            }
            uIDMap.addTransferSyntaxUIDs(string, collection2);
        }
        return uIDMap;
    }

    public static UIDMap createUIDMap(List<String> list, List<String> list2) {
        UIDMap uIDMap = new UIDMap();
        for (String string : list) {
            uIDMap.addTransferSyntaxUIDs(string, list2);
        }
        return uIDMap;
    }
}

