/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.code;

import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.logging.ALogger;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.data.Attributes;

public class MammoCode
extends Code {
    private static final ALogger LOGGER = ALogger.getLogger(MammoCode.class);
    public static final String MAMMO_DESIGNATOR = "SNM3";
    public static final String DEFAULT_DESIGNATOR = "SRT";
    private String viewCode;
    public static final MammoCode[] MedioLateral = MammoCode.createMammoCode("R-10224", "medio-lateral", "ML");
    public static final MammoCode[] MedioLateralOblique = MammoCode.createMammoCode("R-10226", "medio-lateral oblique", "MLO");
    public static final MammoCode[] LateralMedial = MammoCode.createMammoCode("R-10228", "latero-medial", "LM");
    public static final MammoCode[] LateralMedialOblique = MammoCode.createMammoCode("R-10230", "latero-medial oblique", "LMO");
    public static final MammoCode[] CranioCaudal = MammoCode.createMammoCode("R-10242", "cranio-caudal", "CC");
    public static final MammoCode[] CranioCaudalFromBelow = MammoCode.createMammoCode("R-10244", "caudo-cranial (from below)", "FB");
    public static final MammoCode[] SuperoLateralToInferomedialOblique = MammoCode.createMammoCode("R-102D0", "superolateral to inferomedial oblique", "SIO");
    public static final MammoCode[] InferomedialToSuperolateralOblique = MammoCode.createMammoCode("R-40AAA", "inferomedial to superolateral oblique", "ISO");
    public static final MammoCode[] CranioCaudalExaggeratedLaterally = MammoCode.createMammoCode("R-1024A", "cranio-caudal exaggerated laterally", "XCCL");
    public static final MammoCode[] CranioCaudalExaggeratedMedially = MammoCode.createMammoCode("R-1024B", "cranio-caudal exaggerated medially", "XCCM");
    public static final MammoCode[] CranioCaudalExaggeratedRetired = MammoCode.createMammoCode("R-102CF", "cranio-caudal exaggerated", "XCC");
    public static final MammoCode[] CranioCaudalExaggeratedLaterallyRetired = MammoCode.createMammoCode("Y-X1770", "cranio-caudal exaggerated laterally", "XCCL");
    public static final MammoCode[] CranioCaudalExaggeratedMediallyRetired = MammoCode.createMammoCode("Y-X1771", "cranio-caudal exaggerated medially", "XCCM");
    private static final List<MammoCode> codes = MammoCode.codes();

    MammoCode(String string, String string2, String string3, String string4) {
        super(string, string2, string3);
        this.viewCode = string4;
    }

    public String getViewCode() {
        return this.viewCode;
    }

    private static MammoCode[] createMammoCode(String string, String string2, String string3) {
        return new MammoCode[]{new MammoCode(MAMMO_DESIGNATOR, string, string2, string3), new MammoCode(DEFAULT_DESIGNATOR, string, string2, string3)};
    }

    protected static List<MammoCode> codes() {
        Field[] fieldArray;
        ArrayList<MammoCode> arrayList = new ArrayList<MammoCode>();
        Field[] fieldArray2 = fieldArray = MammoCode.class.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray2[n2];
            if (field.getType() == MammoCode[].class) {
                try {
                    MammoCode[] mammoCodeArray;
                    MammoCode[] mammoCodeArray2 = mammoCodeArray = (MammoCode[])field.get(null);
                    int n3 = mammoCodeArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        MammoCode mammoCode = mammoCodeArray2[n4];
                        arrayList.add(mammoCode);
                        ++n4;
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("Error accessing object " + field.toString(), (Throwable)exception);
                }
            }
            ++n2;
        }
        return arrayList;
    }

    public static MammoCode getMammoCode(Attributes attributes) {
        Code code = Code.create(attributes, 5505568);
        if (code != null) {
            for (MammoCode mammoCode : codes) {
                if (!mammoCode.equals(code)) continue;
                return mammoCode;
            }
        }
        return null;
    }

    public static Iterable<MammoCode> getMammoCodes() {
        return codes;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

