/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.print.dicompm.dicom;

import com.agfa.pacs.data.dicom.DicomException;
import com.agfa.pacs.data.dicom.comm.DicomNServiceSCU;
import com.agfa.pacs.data.dicom.transfercapability.ITransferCapabilityProvider;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.dicom.UIDMap;
import com.agfa.pacs.listtext.print.PrintColor;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.DimseRQHandler;
import org.dcm4che3.net.TransferCapability;
import org.dcm4che3.net.pdu.ExtendedNegotiation;
import org.dcm4che3.net.service.DicomService;
import org.dcm4che3.net.service.DicomServiceRegistry;

class DicomPrintNServiceSCU
extends DicomNServiceSCU {
    private DicomService dicomService;
    private boolean supportsGrayscale;
    private boolean supportsColor;
    private static final int LONG_TIME_OUT = 180000;

    private static UIDMap initUIDMap() {
        UIDMap uIDMap = new UIDMap();
        List<String> list = Collections.singletonList("1.2.840.10008.1.2");
        uIDMap.addTransferSyntaxUIDs("1.2.840.10008.5.1.1.9", list);
        uIDMap.addTransferSyntaxUIDs("1.2.840.10008.5.1.1.18", list);
        uIDMap.addTransferSyntaxUIDs("1.2.840.10008.5.1.1.15", list);
        uIDMap.addTransferSyntaxUIDs("1.2.840.10008.5.1.1.14", list);
        uIDMap.addTransferSyntaxUIDs("1.2.840.10008.5.1.1.23", list);
        return uIDMap;
    }

    public DicomPrintNServiceSCU(IDicomNode iDicomNode, DicomService dicomService) throws DicomException {
        super(iDicomNode);
        this.dicomService = dicomService;
        this.addTransferCapabilities(DicomPrintNServiceSCU.initUIDMap());
    }

    public synchronized void close() throws DicomException {
        super.close();
        this.getRegistry().removeDicomService(this.dicomService);
    }

    private DicomServiceRegistry getRegistry() {
        DimseRQHandler dimseRQHandler = this.localAE.getDimseRQHandler();
        if (dimseRQHandler instanceof DicomServiceRegistry) {
            return (DicomServiceRegistry)dimseRQHandler;
        }
        ALogger.getLogger(DicomPrintNServiceSCU.class).error("Registration failed");
        throw new IllegalStateException();
    }

    public synchronized void connect() throws DicomException {
        this.getRegistry().addDicomService(this.dicomService);
        Connection connection = new Connection();
        connection.setResponseTimeout(180000);
        connection.setIdleTimeout(180000);
        super.connect(connection);
        Set set = this.association.getTransferSyntaxesFor("1.2.840.10008.5.1.1.9");
        this.supportsGrayscale = !set.isEmpty();
        set = this.association.getTransferSyntaxesFor("1.2.840.10008.5.1.1.18");
        this.supportsColor = !set.isEmpty();
    }

    public boolean supportsColor() {
        return this.supportsColor;
    }

    public boolean supportsGrayscale() {
        return this.supportsGrayscale;
    }

    public PrintColor[] getSupportedColors() {
        ArrayList<PrintColor> arrayList = new ArrayList<PrintColor>();
        Set set = this.association.getTransferSyntaxesFor("1.2.840.10008.5.1.1.9");
        if (!set.isEmpty()) {
            arrayList.add(PrintColor.Gray);
        }
        if (!(set = this.association.getTransferSyntaxesFor("1.2.840.10008.5.1.1.18")).isEmpty()) {
            arrayList.add(PrintColor.Color);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new PrintColor[0]);
    }

    public static class PrintTransferCapabilityProvider
    implements ITransferCapabilityProvider {
        public List<TransferCapability> getTransferCapabilities() {
            return DicomPrintNServiceSCU.initUIDMap().getTransferCapabilities(false);
        }

        public List<ExtendedNegotiation> getExtendedNegotiation() {
            return Collections.emptyList();
        }
    }
}

