/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.print.dicompm;

import com.agfa.pacs.listtext.dicomobject.type.print.FilmOrientation;
import com.agfa.pacs.listtext.dicomobject.type.print.FilmSizeID;
import com.agfa.pacs.listtext.dicomobject.type.print.imagedisplayformat.ColumnsImageDisplayFormat;
import com.agfa.pacs.listtext.dicomobject.type.print.imagedisplayformat.ImageDisplayFormat;
import com.agfa.pacs.listtext.dicomobject.type.print.imagedisplayformat.RowsImageDisplayFormat;
import com.agfa.pacs.listtext.dicomobject.type.print.imagedisplayformat.StandardImageDisplayFormat;
import com.agfa.pacs.listtext.print.IDisplayFormat;
import com.agfa.pacs.listtext.print.IFilmBoxResolution;
import com.agfa.pacs.listtext.print.IFilmSize;
import com.agfa.pacs.listtext.print.dicompm.DicomFilmBoxResolution;
import com.agfa.pacs.listtext.print.dicompm.DicomFilmSize;
import com.agfa.pacs.listtext.print.renderer.layout.IFilmBoxLayout;
import com.agfa.pacs.listtext.print.renderer.layout.RasterFilmBoxLayout;
import com.agfa.pacs.listtext.print.renderer.layout.RowFilmBoxLayout;

public class DicomDisplayFormat
implements IDisplayFormat {
    private FilmSizeID filmSizeID;
    private int dpi;
    private FilmOrientation filmOrientation;
    private ImageDisplayFormat imageDisplayFormat;
    private double width;
    private double height;

    public DicomDisplayFormat(FilmSizeID filmSizeID, double d, double d2, int n, FilmOrientation filmOrientation, ImageDisplayFormat imageDisplayFormat) {
        this.filmSizeID = filmSizeID;
        this.dpi = n;
        this.filmOrientation = filmOrientation;
        this.imageDisplayFormat = imageDisplayFormat;
        this.width = d;
        this.height = d2;
    }

    public IFilmBoxResolution getFilmBoxResolution() {
        return new DicomFilmBoxResolution(this.dpi);
    }

    public IFilmSize getFilmSize() {
        return new DicomFilmSize(this.filmSizeID, this.width, this.height);
    }

    public IFilmBoxLayout getFilmBoxLayout() {
        if (this.imageDisplayFormat instanceof StandardImageDisplayFormat) {
            StandardImageDisplayFormat standardImageDisplayFormat = (StandardImageDisplayFormat)this.imageDisplayFormat;
            return new RasterFilmBoxLayout(standardImageDisplayFormat.getNumberOfColumns(), standardImageDisplayFormat.getNumberOfRows());
        }
        if (this.imageDisplayFormat instanceof RowsImageDisplayFormat) {
            RowsImageDisplayFormat rowsImageDisplayFormat = (RowsImageDisplayFormat)this.imageDisplayFormat;
            return new RowFilmBoxLayout(rowsImageDisplayFormat.getNumbers());
        }
        if (this.imageDisplayFormat instanceof ColumnsImageDisplayFormat) {
            ColumnsImageDisplayFormat columnsImageDisplayFormat = (ColumnsImageDisplayFormat)this.imageDisplayFormat;
            return new RowFilmBoxLayout(columnsImageDisplayFormat.getNumbers());
        }
        return null;
    }

    public boolean isRotated() {
        return this.filmOrientation == FilmOrientation.Landscape;
    }

    public FilmSizeID getFilmSizeID() {
        return this.filmSizeID;
    }

    public ImageDisplayFormat getImageDisplayFormat() {
        return this.imageDisplayFormat;
    }

    public FilmOrientation getFilmOrientation() {
        return this.filmOrientation;
    }
}

