/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.print;

import com.agfa.pacs.listtext.dicomobject.NormalizedInformationObject;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSOP;
import com.agfa.pacs.listtext.dicomobject.module.general.SOPCommonModule;
import com.agfa.pacs.listtext.dicomobject.module.print.BasicFilmSessionPresentationModule;
import com.agfa.pacs.listtext.dicomobject.module.print.BasicFilmSessionRelationshipModule;
import com.agfa.pacs.listtext.dicomobject.module.print.ProposedStudy;
import com.agfa.pacs.listtext.dicomobject.type.print.FilmDestination;
import com.agfa.pacs.listtext.dicomobject.type.print.MediumType;
import com.agfa.pacs.listtext.dicomobject.type.print.PrintPriority;
import java.util.List;
import org.dcm4che3.data.Attributes;

public class BasicFilmSession
extends NormalizedInformationObject {
    private BasicFilmSessionPresentationModule fsp;
    private BasicFilmSessionRelationshipModule fsr;

    public BasicFilmSession() {
        this(null);
    }

    public BasicFilmSession(Attributes attributes) {
        super(new Class[]{SOPCommonModule.class, BasicFilmSessionPresentationModule.class, BasicFilmSessionRelationshipModule.class}, attributes);
        this.setSOPClassUID("1.2.840.10008.5.1.1.1");
    }

    protected void init(boolean bl) {
        super.init(bl);
        this.fsp = (BasicFilmSessionPresentationModule)this.getModule(BasicFilmSessionPresentationModule.class);
        this.fsr = (BasicFilmSessionRelationshipModule)this.getModule(BasicFilmSessionRelationshipModule.class);
    }

    public void setFilmDestination(FilmDestination filmDestination) {
        this.fsp.setFilmDestination(filmDestination);
    }

    public void setFilmSessionLabel(String string) {
        this.fsp.setFilmSessionLabel(string);
    }

    public void setMediumType(MediumType mediumType) {
        this.fsp.setMediumType(mediumType);
    }

    public void setMemoryAllocation(Integer n) {
        this.fsp.setMemoryAllocation(n);
    }

    public void setNumberOfCopies(Integer n) {
        this.fsp.setNumberOfCopies(n);
    }

    public void setOwnerID(String string) {
        this.fsp.setOwnerID(string);
    }

    public void setPrintPriority(PrintPriority printPriority) {
        this.fsp.setPrintPriority(printPriority);
    }

    public void setProposedStudy(ProposedStudy proposedStudy) {
        this.fsr.setProposedStudy(proposedStudy);
    }

    public List<ReferencedSOP> filmBoxes() {
        return this.fsr.filmBoxes();
    }

    public Attributes getNServiceDicomObject() {
        Attributes attributes = new Attributes();
        this.fsp.writeTo(attributes);
        if (this.fsr.getProposedStudy() != null) {
            attributes.newSequence(556794016, 1).add(this.fsr.getProposedStudy().toDataset());
        }
        return attributes;
    }

    public void updateFrom(Attributes attributes) {
        this.fsp.updateFrom(attributes);
        this.fsr.readFrom(attributes);
    }
}

