/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.dicom.comm;

import com.agfa.pacs.data.dicom.comm.DicomCStoreSCU;
import com.agfa.pacs.data.dicom.transfercapability.ITransferCapabilityProvider;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.dicom.UIDMap;
import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.dcm4che3.net.TransferCapability;
import org.dcm4che3.net.pdu.ExtendedNegotiation;

public class DicomCompositeCStoreSCU
extends DicomCStoreSCU {
    private static UIDMap initUIDMap(Collection<String> collection) {
        UIDMap uIDMap = new UIDMap();
        for (String string : collection) {
            if (UIDUtilities.isType((String)string, (UIDType)UIDType.Image)) {
                uIDMap.addTransferSyntaxUIDs(string, (Collection)UIDUtilities.getImageTransferSyntaxUIDs());
                continue;
            }
            if (UIDUtilities.isType((String)string, (UIDType)UIDType.Video)) {
                uIDMap.addTransferSyntaxUIDs(string, (Collection)UIDUtilities.getVideoTransferSyntaxUIDs());
                continue;
            }
            uIDMap.addTransferSyntaxUIDs(string, (Collection)UIDUtilities.getDefaultTransferSyntaxUIDs());
        }
        return uIDMap;
    }

    private static UIDMap initUIDMap(Collection<String> collection, Collection<String> collection2) {
        UIDMap uIDMap = DicomCompositeCStoreSCU.initUIDMap(collection);
        for (String string : collection) {
            for (String string2 : collection2) {
                if (string2 == null) continue;
                uIDMap.addTransferSyntaxUID(string, string2);
            }
        }
        return uIDMap;
    }

    public DicomCompositeCStoreSCU(IDicomNode iDicomNode, UIDMap uIDMap) {
        super(iDicomNode, uIDMap);
    }

    public DicomCompositeCStoreSCU(IDicomNode iDicomNode, Collection<String> collection) {
        super(iDicomNode, DicomCompositeCStoreSCU.initUIDMap(collection));
    }

    public DicomCompositeCStoreSCU(IDicomNode iDicomNode, Collection<String> collection, Collection<String> collection2) {
        super(iDicomNode, DicomCompositeCStoreSCU.initUIDMap(collection, collection2));
    }

    public DicomCompositeCStoreSCU(IDicomNode iDicomNode, String string) {
        super(iDicomNode, DicomCompositeCStoreSCU.initUIDMap(Collections.singletonList(string)));
    }

    public DicomCompositeCStoreSCU(IDicomNode iDicomNode, String string, String string2) {
        super(iDicomNode, DicomCompositeCStoreSCU.initUIDMap(Collections.singletonList(string), Collections.singletonList(string2)));
    }

    public static class CStoreTransferCapabilityProvider
    implements ITransferCapabilityProvider {
        @Override
        public List<TransferCapability> getTransferCapabilities() {
            UIDMap uIDMap = new UIDMap();
            uIDMap.addTransferSyntaxUIDs(null, (Collection)UIDUtilities.getDefaultTransferSyntaxUIDs());
            uIDMap.addTransferSyntaxUIDs(UIDUtilities.getSOPClassUIDs((UIDType)UIDType.Image), (Collection)UIDUtilities.getImageTransferSyntaxUIDs());
            uIDMap.addTransferSyntaxUIDs(UIDUtilities.getSOPClassUIDs((UIDType)UIDType.Composite), (Collection)UIDUtilities.getDefaultTransferSyntaxUIDs());
            uIDMap.addTransferSyntaxUIDs(UIDUtilities.getSOPClassUIDs((UIDType)UIDType.StructuredReport), (Collection)UIDUtilities.getDefaultTransferSyntaxUIDs());
            uIDMap.addTransferSyntaxUIDs(UIDUtilities.getSOPClassUIDs((UIDType)UIDType.KeyObject), (Collection)UIDUtilities.getDefaultTransferSyntaxUIDs());
            uIDMap.addTransferSyntaxUIDs(UIDUtilities.getSOPClassUIDs((UIDType)UIDType.Presentation), (Collection)UIDUtilities.getDefaultTransferSyntaxUIDs());
            uIDMap.addTransferSyntaxUIDs(UIDUtilities.getSOPClassUIDs((UIDType)UIDType.Waveform), (Collection)UIDUtilities.getDefaultTransferSyntaxUIDs());
            uIDMap.addTransferSyntaxUIDs(UIDUtilities.getSOPClassUIDs((UIDType)UIDType.USVolume), (Collection)UIDUtilities.getDefaultTransferSyntaxUIDs());
            uIDMap.addTransferSyntaxUIDs(UIDUtilities.getSOPClassUIDs((UIDType)UIDType.Video), (Collection)UIDUtilities.getVideoTransferSyntaxUIDs());
            return uIDMap.getTransferCapabilities(false);
        }

        @Override
        public List<ExtendedNegotiation> getExtendedNegotiation() {
            return Collections.emptyList();
        }
    }
}

