/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.util;

public class TagUtils {
    private static char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String shortToHexString(int n) {
        char[] cArray = new char[]{HEX_DIGITS[n >>> 12 & 0xF], HEX_DIGITS[n >>> 8 & 0xF], HEX_DIGITS[n >>> 4 & 0xF], HEX_DIGITS[n >>> 0 & 0xF]};
        return new String(cArray);
    }

    public static String toHexString(int n) {
        char[] cArray = new char[]{HEX_DIGITS[n >>> 28], HEX_DIGITS[n >>> 24 & 0xF], HEX_DIGITS[n >>> 20 & 0xF], HEX_DIGITS[n >>> 16 & 0xF], HEX_DIGITS[n >>> 12 & 0xF], HEX_DIGITS[n >>> 8 & 0xF], HEX_DIGITS[n >>> 4 & 0xF], HEX_DIGITS[n >>> 0 & 0xF]};
        return new String(cArray);
    }

    public static String toHexString(byte[] byArray) {
        char[] cArray = new char[byArray.length << 1];
        int n = 0;
        int n2 = 0;
        while (n < byArray.length) {
            cArray[n2++] = HEX_DIGITS[byArray[n] >>> 4 & 0xF];
            cArray[n2++] = HEX_DIGITS[byArray[n] & 0xF];
            ++n;
        }
        return new String(cArray);
    }

    public static String toString(int n) {
        char[] cArray = new char[]{'(', HEX_DIGITS[n >>> 28], HEX_DIGITS[n >>> 24 & 0xF], HEX_DIGITS[n >>> 20 & 0xF], HEX_DIGITS[n >>> 16 & 0xF], ',', HEX_DIGITS[n >>> 12 & 0xF], HEX_DIGITS[n >>> 8 & 0xF], HEX_DIGITS[n >>> 4 & 0xF], HEX_DIGITS[n >>> 0 & 0xF], ')'};
        return new String(cArray);
    }

    public static int groupNumber(int n) {
        return n >>> 16;
    }

    public static int elementNumber(int n) {
        return n & 0xFFFF;
    }

    public static boolean isGroupLength(int n) {
        return TagUtils.elementNumber(n) == 0;
    }

    public static boolean isPrivateCreator(int n) {
        return (n & 0x10000) != 0 && (n & 0xFF00) == 0 && (n & 0xF0) != 0;
    }

    public static boolean isPrivateGroup(int n) {
        return (n & 0x10000) != 0;
    }

    public static boolean isPrivateTag(int n) {
        return (n & 0x10000) != 0 && (n & 0xFF00) != 0;
    }

    public static int toTag(int n, int n2) {
        return n << 16 | n2;
    }

    public static int toPrivateTag(int n, int n2) {
        return n & 0xFFFF0000 | ((n & 0xFF) << 8 | n2 & 0xFF);
    }

    public static int creatorTagOf(int n) {
        return n & 0xFFFF0000 | n >>> 8 & 0xFF;
    }

    public static int groupLengthTagOf(int n) {
        return n & 0xFFFF0000;
    }

    public static boolean isItem(int n) {
        return n == -73728 || n == -73715 || n == -73507;
    }

    public static boolean isFileMetaInformation(int n) {
        return (n & 0xFFFF0000) == 131072;
    }

    public static int normalizeRepeatingGroup(int n) {
        int n2 = n & 0xFFE00000;
        return n2 == 0x50000000 || n2 == 0x60000000 ? n & 0xFFE0FFFF : n;
    }

    public static int tmTagOf(int n) {
        switch (n) {
            case 524306: {
                return 524307;
            }
            case 524320: {
                return 524336;
            }
            case 524321: {
                return 524337;
            }
            case 524322: {
                return 524338;
            }
            case 524323: {
                return 524339;
            }
            case 524324: {
                return 524340;
            }
            case 524325: {
                return 524341;
            }
            case 0x100030: {
                return 1048626;
            }
            case 1576978: {
                return 1576980;
            }
            case 1577472: {
                return 1577473;
            }
            case 1601548: {
                return 1601550;
            }
            case 2110467: {
                return 2110469;
            }
            case 0x320032: {
                return 0x320033;
            }
            case 3276852: {
                return 3276853;
            }
            case 3280896: {
                return 3280897;
            }
            case 3280912: {
                return 3280913;
            }
            case 3280960: {
                return 3280961;
            }
            case 3280976: {
                return 3280977;
            }
            case 3670042: {
                return 3670043;
            }
            case 3670044: {
                return 3670045;
            }
            case 3670048: {
                return 3670049;
            }
            case 0x380030: {
                return 3670066;
            }
            case 0x400002: {
                return 0x400003;
            }
            case 0x400004: {
                return 0x400005;
            }
            case 0x400244: {
                return 4194885;
            }
            case 4194896: {
                return 4194897;
            }
            case 0x402004: {
                return 4202501;
            }
            case 4235553: {
                return 4235554;
            }
            case 7340162: {
                return 7340163;
            }
            case 553648192: {
                return 553648208;
            }
            case 805699592: {
                return 805699593;
            }
            case 805830692: {
                return 805830693;
            }
            case 805831010: {
                return 805831012;
            }
            case 805831014: {
                return 805831016;
            }
            case 805831248: {
                return 805831249;
            }
            case 805961734: {
                return 805961735;
            }
            case 805962284: {
                return 805962286;
            }
            case 806223876: {
                return 806223877;
            }
            case 1074266368: {
                return 1074266369;
            }
            case 1074266376: {
                return 1074266377;
            }
            case 1074266386: {
                return 1074266387;
            }
        }
        return 0;
    }

    public static int daTagOf(int n) {
        switch (n) {
            case 524307: {
                return 524306;
            }
            case 524336: {
                return 524320;
            }
            case 524337: {
                return 524321;
            }
            case 524338: {
                return 524322;
            }
            case 524339: {
                return 524323;
            }
            case 524340: {
                return 524324;
            }
            case 524341: {
                return 524325;
            }
            case 1048626: {
                return 0x100030;
            }
            case 1576980: {
                return 1576980;
            }
            case 1577473: {
                return 1577473;
            }
            case 1601550: {
                return 1601550;
            }
            case 2110469: {
                return 2110467;
            }
            case 0x320033: {
                return 0x320032;
            }
            case 3276853: {
                return 3276852;
            }
            case 3280897: {
                return 3280896;
            }
            case 3280913: {
                return 3280912;
            }
            case 3280961: {
                return 3280960;
            }
            case 3280977: {
                return 3280976;
            }
            case 3670043: {
                return 3670042;
            }
            case 3670045: {
                return 3670044;
            }
            case 3670049: {
                return 3670048;
            }
            case 3670066: {
                return 0x380030;
            }
            case 0x400003: {
                return 0x400002;
            }
            case 0x400005: {
                return 0x400004;
            }
            case 4194885: {
                return 0x400244;
            }
            case 4194897: {
                return 4194896;
            }
            case 0x402004: {
                return 4202501;
            }
            case 4235554: {
                return 4235553;
            }
            case 7340163: {
                return 7340162;
            }
            case 553648208: {
                return 553648192;
            }
            case 805699593: {
                return 805699592;
            }
            case 805830693: {
                return 805830692;
            }
            case 805831012: {
                return 805831010;
            }
            case 805831016: {
                return 805831014;
            }
            case 805831249: {
                return 805831248;
            }
            case 805961735: {
                return 805961734;
            }
            case 805962286: {
                return 805962284;
            }
            case 806223877: {
                return 806223876;
            }
            case 1074266369: {
                return 1074266368;
            }
            case 1074266377: {
                return 1074266376;
            }
            case 1074266387: {
                return 1074266386;
            }
        }
        return 0;
    }
}

