/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class IntHashMap<V>
implements Cloneable,
Serializable {
    private static final int DEFAULT_CAPACITY = 32;
    private static final int MINIMUM_CAPACITY = 4;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final byte FREE = 0;
    private static final byte FULL = 1;
    private static final byte REMOVED = -1;
    private transient int[] keys;
    private transient Object[] values;
    private transient byte[] states;
    private transient int free;
    private transient int size;
    private static final long serialVersionUID = 9153226350279204066L;

    public IntHashMap() {
        this.init(32);
    }

    public IntHashMap(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("expectedMaxSize is negative: " + n);
        }
        this.init(this.capacity(n));
    }

    private int capacity(int n) {
        int n2 = n << 1;
        if (n2 > 0x40000000) {
            return 0x40000000;
        }
        int n3 = 4;
        while (n3 < n2) {
            n3 <<= 1;
        }
        return n3;
    }

    private void init(int n) {
        this.keys = new int[n];
        this.values = new Object[n];
        this.states = new byte[n];
        this.free = n >>> 1;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public V get(int n) {
        byte[] byArray = this.states;
        int[] nArray = this.keys;
        int n2 = nArray.length - 1;
        int n3 = n & n2;
        while (byArray[n3] != 0) {
            if (nArray[n3] == n) {
                return (V)this.values[n3];
            }
            n3 = n3 + 1 & n2;
        }
        return null;
    }

    public boolean containsKey(int n) {
        byte[] byArray = this.states;
        int[] nArray = this.keys;
        int n2 = nArray.length - 1;
        int n3 = n & n2;
        while (byArray[n3] != 0) {
            if (nArray[n3] == n) {
                return byArray[n3] > 0;
            }
            n3 = n3 + 1 & n2;
        }
        return false;
    }

    public V put(int n, V v) {
        byte[] byArray = this.states;
        int[] nArray = this.keys;
        int n2 = nArray.length - 1;
        int n3 = n & n2;
        while (byArray[n3] > 0) {
            if (nArray[n3] == n) {
                Object object = this.values[n3];
                this.values[n3] = v;
                return (V)object;
            }
            n3 = n3 + 1 & n2;
        }
        byte by = byArray[n3];
        byArray[n3] = 1;
        nArray[n3] = n;
        this.values[n3] = v;
        ++this.size;
        if (by == 0 && --this.free < 0) {
            this.resize(Math.max(this.capacity(this.size), nArray.length));
        }
        return null;
    }

    public void trimToSize() {
        this.resize(this.capacity(this.size));
    }

    public void rehash() {
        this.resize(this.keys.length);
    }

    private void resize(int n) {
        if (n > 0x40000000) {
            throw new IllegalStateException("Capacity exhausted.");
        }
        int[] nArray = this.keys;
        Object[] objectArray = this.values;
        byte[] byArray = this.states;
        int[] nArray2 = new int[n];
        Object[] objectArray2 = new Object[n];
        byte[] byArray2 = new byte[n];
        int n2 = n - 1;
        int n3 = 0;
        while (n3 < nArray.length) {
            if (byArray[n3] > 0) {
                int n4 = nArray[n3];
                int n5 = n4 & n2;
                while (byArray2[n5] != 0) {
                    n5 = n5 + 1 & n2;
                }
                byArray2[n5] = 1;
                nArray2[n5] = n4;
                objectArray2[n5] = objectArray[n3];
                objectArray[n3] = null;
            }
            ++n3;
        }
        this.keys = nArray2;
        this.values = objectArray2;
        this.states = byArray2;
        this.free = (n >>> 1) - this.size;
    }

    public V remove(int n) {
        byte[] byArray = this.states;
        int[] nArray = this.keys;
        int n2 = nArray.length - 1;
        int n3 = n & n2;
        while (byArray[n3] != 0) {
            if (nArray[n3] == n) {
                if (byArray[n3] < 0) {
                    return null;
                }
                byArray[n3] = -1;
                Object object = this.values[n3];
                this.values[n3] = null;
                --this.size;
                return (V)object;
            }
            n3 = n3 + 1 & n2;
        }
        return null;
    }

    public void clear() {
        Arrays.fill(this.values, null);
        Arrays.fill(this.states, (byte)0);
        this.size = 0;
        this.free = this.keys.length >>> 1;
    }

    public Object clone() {
        try {
            IntHashMap intHashMap = (IntHashMap)super.clone();
            intHashMap.states = (byte[])this.states.clone();
            intHashMap.keys = (int[])this.keys.clone();
            intHashMap.values = (Object[])this.values.clone();
            return intHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean accept(Visitor<V> visitor) {
        int n = 0;
        while (n < this.states.length) {
            if (this.states[n] > 0 && !visitor.visit(this.keys[n], this.values[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        byte[] byArray = this.states;
        int[] nArray = this.keys;
        Object[] objectArray = this.values;
        objectOutputStream.writeInt(this.size);
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] > 0) {
                objectOutputStream.writeInt(nArray[n]);
                objectOutputStream.writeObject(objectArray[n]);
            }
            ++n;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.init(this.capacity(n));
        this.size = n;
        this.free -= n;
        byte[] byArray = this.states;
        int[] nArray = this.keys;
        Object[] objectArray = this.values;
        int n2 = nArray.length - 1;
        while (n-- > 0) {
            int n3 = objectInputStream.readInt();
            int n4 = n3 & n2;
            while (byArray[n4] != 0) {
                n4 = n4 + 1 & n2;
            }
            byArray[n4] = 1;
            nArray[n4] = n3;
            objectArray[n4] = objectInputStream.readObject();
        }
    }

    public static interface Visitor<V> {
        public boolean visit(int var1, V var2);
    }
}

