/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net.service;

import java.io.IOException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.data.ValidationResult;
import org.dcm4che3.util.StringUtils;

public class DicomServiceException
extends IOException {
    private static final long serialVersionUID = -8680017798403768406L;
    private final Attributes rsp = new Attributes();
    private Attributes data;

    public DicomServiceException(int n) {
        this.setStatus(n);
    }

    public DicomServiceException(int n, String string) {
        super(string);
        this.setStatus(n);
        this.setErrorComment(this.getMessage());
    }

    public DicomServiceException(int n, Throwable throwable) {
        super(throwable);
        this.setStatus(n);
        this.setErrorComment(this.getMessage());
    }

    /*
     * Unable to fully structure code
     */
    public static Throwable initialCauseOf(Throwable var0) {
        if (var0 != null) ** GOTO lbl4
        return null;
lbl-1000:
        // 1 sources

        {
            var0 = var1_1;
lbl4:
            // 2 sources

            ** while ((var1_1 = var0.getCause()) != null)
        }
lbl5:
        // 1 sources

        return var0;
    }

    private void setStatus(int n) {
        this.rsp.setInt(2304, VR.US, n);
    }

    public int getStatus() {
        return this.rsp.getInt(2304, 0);
    }

    public DicomServiceException setUID(int n, String string) {
        this.rsp.setString(n, VR.UI, string);
        return this;
    }

    public DicomServiceException setErrorComment(String string) {
        if (string != null) {
            this.rsp.setString(2306, VR.LO, StringUtils.truncate(string, 64));
        }
        return this;
    }

    public DicomServiceException setErrorID(int n) {
        this.rsp.setInt(2307, VR.US, n);
        return this;
    }

    public DicomServiceException setEventTypeID(int n) {
        this.rsp.setInt(4098, VR.US, n);
        return this;
    }

    public DicomServiceException setActionTypeID(int n) {
        this.rsp.setInt(4104, VR.US, n);
        return this;
    }

    public DicomServiceException setOffendingElements(int ... nArray) {
        this.rsp.setInt(2305, VR.AT, nArray);
        return this;
    }

    public DicomServiceException setAttributeIdentifierList(int ... nArray) {
        this.rsp.setInt(4101, VR.AT, nArray);
        return this;
    }

    public Attributes mkRSP(int n, int n2) {
        this.rsp.setInt(256, VR.US, n);
        this.rsp.setInt(288, VR.US, n2);
        return this.rsp;
    }

    public final Attributes getDataset() {
        return this.data;
    }

    public final DicomServiceException setDataset(Attributes attributes) {
        this.data = attributes;
        return this;
    }

    public static DicomServiceException valueOf(ValidationResult validationResult, Attributes attributes) {
        if (validationResult.hasNotAllowedAttributes()) {
            return new DicomServiceException(261).setAttributeIdentifierList(validationResult.tagsOfNotAllowedAttributes());
        }
        if (validationResult.hasMissingAttributes()) {
            return new DicomServiceException(288).setAttributeIdentifierList(validationResult.tagsOfMissingAttributes());
        }
        if (validationResult.hasMissingAttributeValues()) {
            return new DicomServiceException(289).setDataset(new Attributes(attributes, validationResult.tagsOfMissingAttributeValues()));
        }
        if (validationResult.hasInvalidAttributeValues()) {
            return new DicomServiceException(262).setDataset(new Attributes(attributes, validationResult.tagsOfInvalidAttributeValues()));
        }
        return null;
    }
}

