/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.AssociationStateException;
import org.dcm4che3.net.Commands;
import org.dcm4che3.net.DataWriter;
import org.dcm4che3.net.DimseRSPHandler;
import org.dcm4che3.net.InputStreamDataWriter;
import org.dcm4che3.net.pdu.AAssociateRQ;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.net.service.InstanceLocator;
import org.dcm4che3.net.service.RetrieveTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicRetrieveTask
implements RetrieveTask {
    protected static final Logger LOG = LoggerFactory.getLogger(BasicRetrieveTask.class);
    protected final Service service;
    protected final Association as;
    protected final PresentationContext pc;
    protected final Attributes rq;
    protected int status = 0;
    protected boolean pendingRSP;
    protected int pendingRSPInterval;
    protected boolean canceled;
    protected int warning;
    protected int completed;
    protected final ArrayList<String> failed = new ArrayList();
    protected final List<InstanceLocator> insts;
    protected int outstandingRSP = 0;
    protected Object outstandingRSPLock = new Object();
    private ScheduledFuture<?> writePendingRSP;

    public BasicRetrieveTask(Service service, Association association, PresentationContext presentationContext, Attributes attributes, List<InstanceLocator> list) {
        this.service = service;
        this.as = association;
        this.pc = presentationContext;
        this.rq = attributes;
        this.insts = list;
    }

    public void setSendPendingRSP(boolean bl) {
        this.pendingRSP = bl;
    }

    public void setSendPendingRSPInterval(int n) {
        this.pendingRSPInterval = n;
    }

    @Override
    public void onCancelRQ(Association association) {
        this.canceled = true;
    }

    @Override
    public void run() {
        int n = this.rq.getInt(272, -1);
        this.as.addCancelRQHandler(n, this);
        try {
            try {
                if (!this.insts.isEmpty()) {
                    Association association = this.getStoreAssociation();
                    if (this.pendingRSPInterval > 0) {
                        this.startWritePendingRSP();
                    }
                    for (InstanceLocator instanceLocator : this.insts) {
                        if (!association.isReadyForDataTransfer()) {
                            this.failed.add(instanceLocator.iuid);
                            if (this.status == 42754) continue;
                            this.status = 42754;
                            LOG.warn("{}: Unable to perform sub-operation: association to {} in state: {}", new Object[]{this.as, association.getRemoteAET(), association.getState()});
                            continue;
                        }
                        if (this.canceled) {
                            this.status = 65024;
                            break;
                        }
                        if (this.pendingRSP) {
                            this.writePendingRSP();
                        }
                        try {
                            this.cstore(association, instanceLocator);
                        }
                        catch (Exception exception) {
                            this.failed.add(instanceLocator.iuid);
                            this.status = 42754;
                            LOG.warn(this.as + ": Unable to perform sub-operation on association to " + association.getRemoteAET(), (Throwable)exception);
                        }
                    }
                    this.waitForOutstandingCStoreRSP(association);
                    this.releaseStoreAssociation(association);
                    this.stopWritePendingRSP();
                }
                this.writeRSP(this.status);
            }
            catch (DicomServiceException dicomServiceException) {
                Attributes attributes = dicomServiceException.mkRSP(this.service.commandFieldOfRSP(), this.rq.getInt(272, 0));
                this.writeRSP(attributes, dicomServiceException.getDataset());
                this.as.removeCancelRQHandler(n);
                this.close();
            }
        }
        finally {
            this.as.removeCancelRQHandler(n);
            this.close();
        }
    }

    private void startWritePendingRSP() {
        this.writePendingRSP = this.as.getApplicationEntity().getDevice().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                BasicRetrieveTask.this.writePendingRSP();
            }
        }, 0L, this.pendingRSPInterval, TimeUnit.SECONDS);
    }

    private void stopWritePendingRSP() {
        if (this.writePendingRSP != null) {
            this.writePendingRSP.cancel(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForOutstandingCStoreRSP(Association association) {
        try {
            Object object = this.outstandingRSPLock;
            synchronized (object) {
                while (this.outstandingRSP > 0) {
                    this.outstandingRSPLock.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            LOG.warn(this.as + ": failed to wait for outstanding RSP on association to " + association.getRemoteAET(), (Throwable)interruptedException);
        }
    }

    protected Association getStoreAssociation() throws DicomServiceException {
        return this.as;
    }

    protected AAssociateRQ makeAAssociateRQ() {
        AAssociateRQ aAssociateRQ = new AAssociateRQ();
        aAssociateRQ.setCallingAET(this.as.getLocalAET());
        aAssociateRQ.setCalledAET(this.rq.getString(1536));
        for (InstanceLocator instanceLocator : this.insts) {
            String[] stringArray;
            if (aAssociateRQ.containsPresentationContextFor(instanceLocator.cuid, instanceLocator.tsuid)) continue;
            aAssociateRQ.addPresentationContext(new PresentationContext(aAssociateRQ.getNumberOfPresentationContexts() * 2 + 1, instanceLocator.cuid, instanceLocator.tsuid));
            String[] stringArray2 = stringArray = new String[]{"1.2.840.10008.1.2.1", "1.2.840.10008.1.2"};
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                if (!instanceLocator.tsuid.equals(string) && !aAssociateRQ.containsPresentationContextFor(instanceLocator.cuid, string)) {
                    aAssociateRQ.addPresentationContext(new PresentationContext(aAssociateRQ.getNumberOfPresentationContexts() * 2 + 1, instanceLocator.cuid, string));
                }
                ++n2;
            }
        }
        return aAssociateRQ;
    }

    protected void releaseStoreAssociation(Association association) {
        try {
            this.service.releaseStoreAssociation(association);
        }
        catch (AssociationStateException associationStateException) {
        }
        catch (IOException iOException) {
            LOG.warn(this.as + ": failed to release association to " + association.getRemoteAET(), (Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cstore(Association association, InstanceLocator instanceLocator) throws IOException, InterruptedException {
        String string = this.selectTransferSyntaxFor(association, instanceLocator);
        CStoreRSPHandler cStoreRSPHandler = new CStoreRSPHandler(this.as.nextMessageID(), instanceLocator.iuid);
        if (association == this.as) {
            association.cstore(instanceLocator.cuid, instanceLocator.iuid, this.rq.getInt(1792, 0), this.createDataWriter(instanceLocator, string), string, cStoreRSPHandler);
        } else {
            association.cstore(instanceLocator.cuid, instanceLocator.iuid, this.rq.getInt(1792, 0), this.as.getRemoteAET(), this.rq.getInt(272, 0), this.createDataWriter(instanceLocator, string), string, cStoreRSPHandler);
        }
        Object object = this.outstandingRSPLock;
        synchronized (object) {
            ++this.outstandingRSP;
        }
    }

    protected String selectTransferSyntaxFor(Association association, InstanceLocator instanceLocator) {
        return instanceLocator.tsuid;
    }

    protected DataWriter createDataWriter(InstanceLocator instanceLocator, String string) throws IOException {
        DicomInputStream dicomInputStream = new DicomInputStream(instanceLocator.getFile());
        dicomInputStream.readFileMetaInformation();
        return new InputStreamDataWriter(dicomInputStream);
    }

    public void writePendingRSP() {
        this.writeRSP(65280);
    }

    private void writeRSP(int n) {
        Attributes attributes = this.service.mkRSP(this.rq, n);
        if (n == 65280 || n == 65024) {
            attributes.setInt(4128, VR.US, this.remaining());
        }
        attributes.setInt(4129, VR.US, this.completed);
        attributes.setInt(4130, VR.US, this.failed.size());
        attributes.setInt(4131, VR.US, this.warning);
        Attributes attributes2 = null;
        if (!this.failed.isEmpty() && n != 65280) {
            attributes2 = new Attributes(1);
            attributes2.setString(524376, VR.UI, this.failed.toArray(new String[this.failed.size()]));
        }
        this.writeRSP(attributes, attributes2);
    }

    private void writeRSP(Attributes attributes, Attributes attributes2) {
        try {
            this.as.writeDimseRSP(this.pc, attributes, attributes2);
        }
        catch (IOException iOException) {
            this.pendingRSP = false;
            this.stopWritePendingRSP();
            LOG.warn(this.as + ": Unable to send C-GET or C-MOVE RSP on association to " + this.as.getRemoteAET(), (Throwable)iOException);
        }
    }

    private int remaining() {
        return this.insts.size() - this.completed - this.warning - this.failed.size();
    }

    protected void close() {
    }

    private final class CStoreRSPHandler
    extends DimseRSPHandler {
        private final String iuid;

        public CStoreRSPHandler(int n, String string) {
            super(n);
            this.iuid = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDimseRSP(Association association, Attributes attributes, Attributes attributes2) {
            super.onDimseRSP(association, attributes, attributes2);
            int n = attributes.getInt(2304, -1);
            if (n == 0) {
                ++BasicRetrieveTask.this.completed;
            } else if ((n & 0xB000) == 45056) {
                ++BasicRetrieveTask.this.warning;
            } else {
                BasicRetrieveTask.this.failed.add(this.iuid);
                if (BasicRetrieveTask.this.status == 0) {
                    BasicRetrieveTask.this.status = 45056;
                }
            }
            Object object = BasicRetrieveTask.this.outstandingRSPLock;
            synchronized (object) {
                if (--BasicRetrieveTask.this.outstandingRSP == 0) {
                    BasicRetrieveTask.this.outstandingRSPLock.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onClose(Association association) {
            super.onClose(association);
            Object object = BasicRetrieveTask.this.outstandingRSPLock;
            synchronized (object) {
                BasicRetrieveTask.this.outstandingRSP = 0;
                BasicRetrieveTask.this.outstandingRSPLock.notify();
            }
        }
    }

    public static enum Service {
        C_GET{

            @Override
            Attributes mkRSP(Attributes attributes, int n) {
                return Commands.mkCGetRSP(attributes, n);
            }

            @Override
            void releaseStoreAssociation(Association association) throws IOException {
            }

            @Override
            int commandFieldOfRSP() {
                return 32784;
            }
        }
        ,
        C_MOVE{

            @Override
            Attributes mkRSP(Attributes attributes, int n) {
                return Commands.mkCMoveRSP(attributes, n);
            }

            @Override
            void releaseStoreAssociation(Association association) throws IOException {
                association.release();
            }

            @Override
            int commandFieldOfRSP() {
                return 32801;
            }
        };


        abstract Attributes mkRSP(Attributes var1, int var2);

        abstract void releaseStoreAssociation(Association var1) throws IOException;

        abstract int commandFieldOfRSP();
    }
}

