/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net.audit;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.TimeZone;
import org.dcm4che3.audit.ActiveParticipant;
import org.dcm4che3.audit.AuditMessage;
import org.dcm4che3.audit.AuditMessages;
import org.dcm4che3.audit.AuditSourceIdentification;
import org.dcm4che3.audit.AuditSourceTypeCode;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.DeviceExtension;
import org.dcm4che3.net.IncompatibleConnectionException;
import org.dcm4che3.net.audit.AuditRecordRepository;
import org.dcm4che3.util.SafeClose;

public class AuditLogger
extends DeviceExtension {
    private static final long serialVersionUID = 1595714214186063103L;
    public static final String MESSAGE_ID = "DICOM+RFC3881";
    private static final int[] DIGITS_0X = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    private static final int[] DIGITS_X0 = new int[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57};
    private static final byte[] BOM = new byte[]{-17, -69, -65};
    private static final char SYSLOG_VERSION = '1';
    private static final InetAddress localHost = AuditLogger.localHost();
    private static final String processID = AuditLogger.processID();
    private static volatile AuditLogger defaultLogger;
    private Device arrDevice;
    private Facility facility = Facility.authpriv;
    private Severity successSeverity = Severity.notice;
    private Severity minorFailureSeverity = Severity.warning;
    private Severity seriousFailureSeverity = Severity.err;
    private Severity majorFailureSeverity = Severity.crit;
    private String applicationName;
    private String auditSourceID;
    private String auditEnterpriseSiteID;
    private String[] auditSourceTypeCodes = new String[0];
    private String messageID = "DICOM+RFC3881";
    private String encoding = "UTF-8";
    private String schemaURI = "http://www.dcm4che.org/DICOM/audit-message.rnc";
    private boolean timestampInUTC = false;
    private boolean includeBOM = true;
    private boolean formatXML;
    private Boolean installed;
    private Boolean includeInstanceUID = false;
    private final List<Connection> conns = new ArrayList<Connection>(1);
    private transient ActiveConnection activeConnection;

    public final Device getAuditRecordRepositoryDevice() {
        return this.arrDevice;
    }

    public String getAuditRecordRepositoryDeviceName() {
        if (this.arrDevice == null) {
            throw new IllegalStateException("AuditRecordRepositoryDevice not initalized");
        }
        return this.arrDevice.getDeviceName();
    }

    public void setAuditRecordRepositoryDevice(Device device) {
        SafeClose.close(this.activeConnection);
        this.activeConnection = null;
        this.arrDevice = device;
    }

    public final Facility getFacility() {
        return this.facility;
    }

    public final void setFacility(Facility facility) {
        if (facility == null) {
            throw new NullPointerException();
        }
        this.facility = facility;
    }

    public final Severity getSuccessSeverity() {
        return this.successSeverity;
    }

    public final void setSuccessSeverity(Severity severity) {
        if (severity == null) {
            throw new NullPointerException();
        }
        this.successSeverity = severity;
    }

    public final Severity getMinorFailureSeverity() {
        return this.minorFailureSeverity;
    }

    public final void setMinorFailureSeverity(Severity severity) {
        if (severity == null) {
            throw new NullPointerException();
        }
        this.minorFailureSeverity = severity;
    }

    public final Severity getSeriousFailureSeverity() {
        return this.seriousFailureSeverity;
    }

    public final void setSeriousFailureSeverity(Severity severity) {
        if (severity == null) {
            throw new NullPointerException();
        }
        this.seriousFailureSeverity = severity;
    }

    public final Severity getMajorFailureSeverity() {
        return this.majorFailureSeverity;
    }

    public final void setMajorFailureSeverity(Severity severity) {
        if (severity == null) {
            throw new NullPointerException();
        }
        this.majorFailureSeverity = severity;
    }

    public final String getApplicationName() {
        return this.applicationName;
    }

    private String applicationName() {
        return this.applicationName != null ? this.applicationName : this.auditSourceID();
    }

    public final void setApplicationName(String string) {
        this.applicationName = string;
    }

    public final String getAuditSourceID() {
        return this.auditSourceID;
    }

    public final void setAuditSourceID(String string) {
        this.auditSourceID = string;
    }

    private String auditSourceID() {
        return this.auditSourceID != null ? this.auditSourceID : this.getDevice().getDeviceName();
    }

    public final String getAuditEnterpriseSiteID() {
        return this.auditEnterpriseSiteID;
    }

    public final void setAuditEnterpriseSiteID(String string) {
        this.auditEnterpriseSiteID = string;
    }

    public String[] getAuditSourceTypeCodes() {
        return this.auditSourceTypeCodes;
    }

    public void setAuditSourceTypeCodes(String ... stringArray) {
        this.auditSourceTypeCodes = stringArray;
    }

    public ActiveParticipant createActiveParticipant(boolean bl, AuditMessages.RoleIDCode ... roleIDCodeArray) {
        Collection<String> collection = this.device.getApplicationAETitles();
        return this.createActiveParticipant(bl, AuditLogger.processID(), AuditMessages.alternativeUserIDForAETitle(collection.toArray(new String[collection.size()])), this.applicationName(), AuditLogger.localHost().getHostName(), roleIDCodeArray);
    }

    public ActiveParticipant createActiveParticipant(boolean bl, String string, String string2, String string3, String string4, AuditMessages.RoleIDCode ... roleIDCodeArray) {
        ActiveParticipant activeParticipant = new ActiveParticipant();
        activeParticipant.setUserID(string);
        activeParticipant.setAlternativeUserID(string2);
        activeParticipant.setUserName(string3);
        activeParticipant.setUserIsRequestor(bl);
        activeParticipant.setNetworkAccessPointID(string4);
        activeParticipant.setNetworkAccessPointTypeCode(AuditMessages.isIP(string4) ? "2" : "1");
        AuditMessages.RoleIDCode[] roleIDCodeArray2 = roleIDCodeArray;
        int n = roleIDCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AuditMessages.RoleIDCode roleIDCode = roleIDCodeArray2[n2];
            activeParticipant.getRoleIDCode().add(roleIDCode);
            ++n2;
        }
        return activeParticipant;
    }

    public AuditSourceIdentification createAuditSourceIdentification() {
        Object object;
        AuditSourceIdentification auditSourceIdentification = new AuditSourceIdentification();
        auditSourceIdentification.setAuditSourceID(this.auditSourceID());
        if (this.auditEnterpriseSiteID != null) {
            if (this.auditEnterpriseSiteID.equals("dicomInstitutionName")) {
                object = this.getDevice().getInstitutionNames();
                if (((String[])object).length > 0) {
                    auditSourceIdentification.setAuditEnterpriseSiteID(object[0]);
                }
            } else {
                auditSourceIdentification.setAuditEnterpriseSiteID(this.auditEnterpriseSiteID);
            }
        }
        String[] stringArray = this.auditSourceTypeCodes;
        int n = this.auditSourceTypeCodes.length;
        int n2 = 0;
        while (n2 < n) {
            Object object2;
            object = stringArray[n2];
            if (((String)object).equals("dicomPrimaryDeviceType")) {
                String[] stringArray2 = this.device.getPrimaryDeviceTypes();
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    object2 = stringArray2[n4];
                    AuditSourceTypeCode auditSourceTypeCode = new AuditSourceTypeCode();
                    auditSourceTypeCode.setCode((String)object2);
                    auditSourceTypeCode.setCodeSystemName("DCM");
                    auditSourceIdentification.getAuditSourceTypeCode().add(auditSourceTypeCode);
                    ++n4;
                }
            } else {
                object2 = new AuditSourceTypeCode();
                ((AuditSourceTypeCode)object2).setCode((String)object);
                auditSourceIdentification.getAuditSourceTypeCode().add((AuditSourceTypeCode)object2);
            }
            ++n2;
        }
        return auditSourceIdentification;
    }

    public final String getMessageID() {
        return this.messageID;
    }

    public final void setMessageID(String string) {
        this.messageID = string;
    }

    public final String getEncoding() {
        return this.encoding;
    }

    public final void setEncoding(String string) {
        if (!Charset.isSupported(string)) {
            throw new IllegalArgumentException("Charset not supported: " + string);
        }
        this.encoding = string;
    }

    public final String getSchemaURI() {
        return this.schemaURI;
    }

    public final void setSchemaURI(String string) {
        this.schemaURI = string;
    }

    public final boolean isTimestampInUTC() {
        return this.timestampInUTC;
    }

    public final void setTimestampInUTC(boolean bl) {
        this.timestampInUTC = bl;
    }

    public final boolean isIncludeBOM() {
        return this.includeBOM;
    }

    public final void setIncludeBOM(boolean bl) {
        this.includeBOM = bl;
    }

    public final boolean isFormatXML() {
        return this.formatXML;
    }

    public final void setFormatXML(boolean bl) {
        this.formatXML = bl;
    }

    public boolean isInstalled() {
        return this.device != null && this.device.isInstalled() && (this.installed == null || this.installed != false);
    }

    public final Boolean getInstalled() {
        return this.installed;
    }

    public void setInstalled(Boolean bl) {
        if (bl != null && bl.booleanValue() && this.device != null && !this.device.isInstalled()) {
            throw new IllegalStateException("owning device not installed");
        }
        this.installed = bl;
    }

    public Boolean isIncludeInstanceUID() {
        return this.includeInstanceUID;
    }

    public void setIncludeInstanceUID(Boolean bl) {
        this.includeInstanceUID = bl;
    }

    public void addConnection(Connection connection) {
        if (!connection.getProtocol().isSyslog()) {
            throw new IllegalArgumentException("Audit Logger does not support protocol " + (Object)((Object)connection.getProtocol()));
        }
        if (this.device != null && this.device != connection.getDevice()) {
            throw new IllegalStateException(connection + " not contained by " + this.device.getDeviceName());
        }
        this.conns.add(connection);
    }

    @Override
    public void verifyNotUsed(Connection connection) {
        if (this.conns.contains(connection)) {
            throw new IllegalStateException(connection + " used by Audit Logger");
        }
    }

    public boolean removeConnection(Connection connection) {
        return this.conns.remove(connection);
    }

    public List<Connection> getConnections() {
        return this.conns;
    }

    @Override
    public void reconfigure(DeviceExtension deviceExtension) {
        this.reconfigure((AuditLogger)deviceExtension);
    }

    private void reconfigure(AuditLogger auditLogger) {
        this.setFacility(auditLogger.facility);
        this.setSuccessSeverity(auditLogger.successSeverity);
        this.setMinorFailureSeverity(auditLogger.minorFailureSeverity);
        this.setSeriousFailureSeverity(auditLogger.seriousFailureSeverity);
        this.setMajorFailureSeverity(auditLogger.majorFailureSeverity);
        this.setApplicationName(auditLogger.applicationName);
        this.setAuditSourceID(auditLogger.auditSourceID);
        this.setAuditEnterpriseSiteID(auditLogger.auditEnterpriseSiteID);
        this.setAuditSourceTypeCodes(auditLogger.auditSourceTypeCodes);
        this.setMessageID(auditLogger.messageID);
        this.setEncoding(auditLogger.encoding);
        this.setSchemaURI(auditLogger.schemaURI);
        this.setTimestampInUTC(auditLogger.timestampInUTC);
        this.setIncludeBOM(auditLogger.includeBOM);
        this.setFormatXML(auditLogger.formatXML);
        this.setInstalled(auditLogger.installed);
        this.setAuditRecordRepositoryDevice(auditLogger.arrDevice);
        this.device.reconfigureConnections(this.conns, auditLogger.conns);
    }

    public Calendar timeStamp() {
        return this.timestampInUTC ? new GregorianCalendar(TimeZone.getTimeZone("UTC"), Locale.ENGLISH) : new GregorianCalendar(Locale.ENGLISH);
    }

    public void write(Calendar calendar, AuditMessage auditMessage) throws IncompatibleConnectionException, GeneralSecurityException {
        this.getActiveConnection().send(calendar, auditMessage);
    }

    public Connection getRemoteActiveConnection() throws IncompatibleConnectionException {
        return this.getActiveConnection().remoteConn;
    }

    private ActiveConnection getActiveConnection() throws IncompatibleConnectionException {
        ActiveConnection activeConnection = this.activeConnection;
        if (activeConnection != null) {
            return activeConnection;
        }
        Device device = this.arrDevice;
        if (this.arrDevice == null) {
            throw new IllegalStateException("No AuditRecordRepositoryDevice initalized");
        }
        AuditRecordRepository auditRecordRepository = device.getDeviceExtension(AuditRecordRepository.class);
        if (auditRecordRepository == null) {
            throw new IllegalStateException("AuditRecordRepositoryDevice " + this.arrDevice.getDeviceName() + " does not provide Audit Record Repository");
        }
        for (Connection connection : auditRecordRepository.getConnections()) {
            if (!connection.isInstalled() || !connection.isServer()) continue;
            for (Connection connection2 : this.conns) {
                if (!connection2.isInstalled() || !connection2.isCompatible(connection)) continue;
                this.activeConnection = connection2.getProtocol().isTCP() ? new TCPConnection(connection2, connection) : new UDPConnection(connection2, connection);
                return this.activeConnection;
            }
        }
        throw new IncompatibleConnectionException("No compatible connection to " + auditRecordRepository + " available on " + this);
    }

    public static String processID() {
        String string = ManagementFactory.getRuntimeMXBean().getName();
        int n = string.indexOf(64);
        return n > 0 ? string.substring(0, n) : Integer.toString(new Random().nextInt() & Integer.MAX_VALUE);
    }

    public static InetAddress localHost() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    private Severity severityOf(AuditMessage auditMessage) {
        String string = auditMessage.getEventIdentification().getEventOutcomeIndicator();
        if (string.length() == 1) {
            switch (string.charAt(0)) {
                case '0': {
                    return this.successSeverity;
                }
                case '4': {
                    return this.minorFailureSeverity;
                }
                case '8': {
                    return this.seriousFailureSeverity;
                }
            }
        } else if (string.equals("12")) {
            return this.majorFailureSeverity;
        }
        throw new IllegalArgumentException("Illegal eventOutcomeIndicator: " + string);
    }

    private int prival(Severity severity) {
        return this.facility.ordinal() << 3 | severity.ordinal();
    }

    public static AuditLogger getDefaultLogger() {
        return defaultLogger;
    }

    public static void setDefaultLogger(AuditLogger auditLogger) {
        defaultLogger = auditLogger;
    }

    private abstract class ActiveConnection
    extends ByteArrayOutputStream {
        final Connection conn;
        final Connection remoteConn;

        ActiveConnection(Connection connection, Connection connection2) {
            this.conn = connection;
            this.remoteConn = connection2;
        }

        abstract void connect() throws IOException, IncompatibleConnectionException, GeneralSecurityException;

        abstract void sendMessage() throws IOException;

        void send(Calendar calendar, AuditMessage auditMessage) throws IncompatibleConnectionException, GeneralSecurityException {
            this.reset();
            try {
                this.writeHeader(AuditLogger.this.severityOf(auditMessage), calendar);
                AuditMessages.toXML(auditMessage, this, AuditLogger.this.formatXML, AuditLogger.this.encoding, AuditLogger.this.schemaURI);
            }
            catch (IOException iOException) {
                throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)("Unexpected exception: " + iOException)))).initCause(iOException));
            }
            try {
                this.connect();
                this.sendMessage();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        void writeHeader(Severity severity, Calendar calendar) throws IOException {
            this.write(60);
            this.writeInt(AuditLogger.this.prival(severity));
            this.write(62);
            this.write(49);
            this.write(32);
            this.write(calendar);
            this.write(32);
            if (localHost != null) {
                this.write(localHost.getCanonicalHostName().getBytes(AuditLogger.this.encoding));
            } else {
                this.write(45);
            }
            this.write(32);
            this.write(AuditLogger.this.applicationName().getBytes(AuditLogger.this.encoding));
            this.write(32);
            this.write(processID.getBytes(AuditLogger.this.encoding));
            this.write(32);
            if (AuditLogger.this.messageID != null) {
                this.write(AuditLogger.this.messageID.getBytes(AuditLogger.this.encoding));
            } else {
                this.write(45);
            }
            this.write(32);
            this.write(45);
            this.write(32);
            if (AuditLogger.this.includeBOM && AuditLogger.this.encoding.equals("UTF-8")) {
                this.write(BOM);
            }
        }

        private void writeInt(int n) {
            if (n >= 100) {
                this.writeNNN(n);
            } else if (n >= 10) {
                this.writeNN(n);
            } else {
                this.writeN(n);
            }
        }

        private void write(Calendar calendar) {
            this.writeNNNN(calendar.get(1));
            this.write(45);
            this.writeNN(calendar.get(2) + 1);
            this.write(45);
            this.writeNN(calendar.get(5));
            this.write(84);
            this.writeNN(calendar.get(11));
            this.write(58);
            this.writeNN(calendar.get(12));
            this.write(58);
            this.writeNN(calendar.get(13));
            this.write(46);
            this.writeNNN(calendar.get(14));
            int n = calendar.get(15) + calendar.get(16);
            if (n == 0) {
                this.write(90);
            } else {
                if ((n /= 60000) > 0) {
                    this.write(43);
                } else {
                    this.write(45);
                    n = -n;
                }
                this.writeNN(n / 60);
                this.write(58);
                this.writeNN(n % 60);
            }
        }

        void writeNNNN(int n) {
            this.writeNN(n / 100);
            this.writeNN(n % 100);
        }

        void writeNNN(int n) {
            this.writeN(n / 100);
            this.writeNN(n % 100);
        }

        void writeNN(int n) {
            this.write(DIGITS_X0[n]);
            this.write(DIGITS_0X[n]);
        }

        void writeN(int n) {
            this.write(DIGITS_0X[n]);
        }
    }

    public static enum Facility {
        kern,
        user,
        mail,
        daemon,
        auth,
        syslog,
        lpr,
        news,
        uucp,
        cron,
        authpriv,
        ftp,
        ntp,
        audit,
        console,
        cron2,
        local0,
        local1,
        local2,
        local3,
        local4,
        local5,
        local6,
        local7;

    }

    public static enum Severity {
        emerg,
        alert,
        crit,
        err,
        warning,
        notice,
        info,
        debug;

    }

    private class TCPConnection
    extends ActiveConnection {
        Socket sock;
        OutputStream out;

        TCPConnection(Connection connection, Connection connection2) {
            super(connection, connection2);
        }

        @Override
        void connect() throws IOException, IncompatibleConnectionException, GeneralSecurityException {
            if (this.sock == null) {
                this.sock = this.conn.connect(this.remoteConn);
                this.out = this.sock.getOutputStream();
            }
        }

        @Override
        void sendMessage() throws IOException {
            try {
                this.out.write(Integer.toString(this.count).getBytes(AuditLogger.this.encoding));
                this.out.write(32);
                this.out.write(this.buf, 0, this.count);
                this.out.flush();
            }
            catch (IOException iOException) {
                this.close();
                throw iOException;
            }
        }

        @Override
        public void close() {
            SafeClose.close(this.out);
            SafeClose.close(this.sock);
            this.sock = null;
            this.out = null;
        }
    }

    private class UDPConnection
    extends ActiveConnection {
        DatagramSocket ds;

        UDPConnection(Connection connection, Connection connection2) {
            super(connection, connection2);
        }

        @Override
        void connect() throws IOException {
            if (this.ds == null) {
                this.ds = this.conn.createDatagramSocket();
            }
        }

        @Override
        void sendMessage() throws IOException {
            this.ds.send(new DatagramPacket(this.buf, this.count, this.remoteConn.getEndPoint()));
        }

        @Override
        public void close() {
            if (this.ds != null) {
                this.ds.close();
                this.ds = null;
            }
        }
    }
}

