/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.dcm4che3.util.SafeClose;
import org.dcm4che3.util.StreamUtils;

public abstract class SSLManagerFactory {
    public static KeyStore createKeyStore(X509Certificate ... x509CertificateArray) throws KeyStoreException {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        try {
            keyStore.load(null);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError((Object)noSuchAlgorithmException);
        }
        catch (CertificateException certificateException) {
            throw new AssertionError((Object)certificateException);
        }
        X509Certificate[] x509CertificateArray2 = x509CertificateArray;
        int n = x509CertificateArray.length;
        int n2 = 0;
        while (n2 < n) {
            X509Certificate x509Certificate = x509CertificateArray2[n2];
            keyStore.setCertificateEntry(x509Certificate.getSubjectX500Principal().getName(), x509Certificate);
            ++n2;
        }
        return keyStore;
    }

    public static KeyStore loadKeyStore(String string, String string2, String string3) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        return SSLManagerFactory.loadKeyStore(string, string2, string3.toCharArray());
    }

    public static KeyStore loadKeyStore(String string, String string2, char[] cArray) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = KeyStore.getInstance(string);
        InputStream inputStream = StreamUtils.openFileOrURL(string2);
        try {
            keyStore.load(inputStream, cArray);
        }
        finally {
            SafeClose.close(inputStream);
        }
        return keyStore;
    }

    public static KeyManager createKeyManager(String string, String string2, char[] cArray, char[] cArray2) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        return SSLManagerFactory.createKeyManager(SSLManagerFactory.loadKeyStore(string, string2, cArray), cArray2);
    }

    public static KeyManager createKeyManager(String string, String string2, String string3, String string4) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        return SSLManagerFactory.createKeyManager(SSLManagerFactory.loadKeyStore(string, string2, string3), string4);
    }

    public static KeyManager createKeyManager(KeyStore keyStore, String string) throws UnrecoverableKeyException, KeyStoreException {
        return SSLManagerFactory.createKeyManager(keyStore, string.toCharArray());
    }

    public static KeyManager createKeyManager(KeyStore keyStore, char[] cArray) throws UnrecoverableKeyException, KeyStoreException {
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, cArray);
            KeyManager[] keyManagerArray = keyManagerFactory.getKeyManagers();
            return keyManagerArray.length > 0 ? keyManagerArray[0] : null;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError((Object)noSuchAlgorithmException);
        }
    }

    public static TrustManager createTrustManager(KeyStore keyStore) throws KeyStoreException {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
            return trustManagerArray.length > 0 ? trustManagerArray[0] : null;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError((Object)noSuchAlgorithmException);
        }
    }

    public static TrustManager createTrustManager(X509Certificate ... x509CertificateArray) throws KeyStoreException {
        return SSLManagerFactory.createTrustManager(SSLManagerFactory.createKeyStore(x509CertificateArray));
    }

    public static TrustManager createTrustManager(String string, String string2, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        return SSLManagerFactory.createTrustManager(SSLManagerFactory.loadKeyStore(string, string2, cArray));
    }

    public static TrustManager createTrustManager(String string, String string2, String string3) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        return SSLManagerFactory.createTrustManager(SSLManagerFactory.loadKeyStore(string, string2, string3));
    }
}

