/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net;

import java.util.EnumSet;
import org.dcm4che3.net.pdu.ExtendedNegotiation;

public enum QueryOption {
    RELATIONAL,
    DATETIME,
    FUZZY,
    TIMEZONE;


    public static byte[] toExtendedNegotiationInformation(EnumSet<QueryOption> enumSet) {
        byte[] byArray = new byte[enumSet.contains((Object)TIMEZONE) ? 4 : (enumSet.contains((Object)FUZZY) || enumSet.contains((Object)DATETIME) ? 3 : 1)];
        for (QueryOption queryOption : enumSet) {
            byArray[queryOption.ordinal()] = 1;
        }
        return byArray;
    }

    public static EnumSet<QueryOption> toOptions(ExtendedNegotiation extendedNegotiation) {
        EnumSet<QueryOption> enumSet = EnumSet.noneOf(QueryOption.class);
        if (extendedNegotiation != null) {
            QueryOption.toOption(extendedNegotiation, RELATIONAL, enumSet);
            QueryOption.toOption(extendedNegotiation, DATETIME, enumSet);
            QueryOption.toOption(extendedNegotiation, FUZZY, enumSet);
            QueryOption.toOption(extendedNegotiation, TIMEZONE, enumSet);
        }
        return enumSet;
    }

    private static void toOption(ExtendedNegotiation extendedNegotiation, QueryOption queryOption, EnumSet<QueryOption> enumSet) {
        if (extendedNegotiation.getField(queryOption.ordinal(), (byte)0) == 1) {
            enumSet.add(queryOption);
        }
    }
}

