/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net;

import org.dcm4che3.data.Attributes;
import org.dcm4che3.util.StringUtils;
import org.dcm4che3.util.TagUtils;
import org.dcm4che3.util.UIDUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Dimse {
    C_STORE_RQ(1, 2, 4096, 272, ":C-STORE-RQ[pcid="),
    C_STORE_RSP(32769, 2, 4096, 288, ":C-STORE-RSP[pcid="),
    C_GET_RQ(16, 2, 0, 272, ":C-GET-RQ[pcid="),
    C_GET_RSP(32784, 2, 0, 288, ":C-GET-RSP[pcid="),
    C_FIND_RQ(32, 2, 0, 272, ":C-FIND-RQ[pcid="),
    C_FIND_RSP(32800, 2, 0, 288, ":C-FIND-RSP[pcid="),
    C_MOVE_RQ(33, 2, 0, 272, ":C-MOVE-RQ[pcid="),
    C_MOVE_RSP(32801, 2, 0, 288, ":C-MOVE-RSP[pcid="),
    C_ECHO_RQ(48, 2, 0, 272, ":C-ECHO-RQ[pcid="),
    C_ECHO_RSP(32816, 2, 0, 288, ":C-ECHO-RSP[pcid="),
    N_EVENT_REPORT_RQ(256, 2, 4096, 272, ":N-EVENT-REPORT-RQ[pcid="),
    N_EVENT_REPORT_RSP(33024, 2, 4096, 288, ":N-EVENT-REPORT-RSP[pcid="),
    N_GET_RQ(272, 3, 4097, 272, ":N-GET-RQ[pcid="),
    N_GET_RSP(33040, 2, 4096, 288, ":N-GET-RSP[pcid="),
    N_SET_RQ(288, 3, 4097, 272, ":N-SET-RQ[pcid="),
    N_SET_RSP(33056, 2, 4096, 288, ":N-SET-RSP[pcid="),
    N_ACTION_RQ(304, 3, 4097, 272, ":N-ACTION-RQ[pcid="),
    N_ACTION_RSP(33072, 2, 4096, 288, ":N-ACTION-RSP[pcid="),
    N_CREATE_RQ(320, 2, 4096, 272, ":N-CREATE-RQ[pcid="),
    N_CREATE_RSP(33088, 2, 4096, 288, ":N-CREATE-RSP[pcid="),
    N_DELETE_RQ(336, 3, 4097, 272, ":N-DELETE-RQ[pcid="),
    N_DELETE_RSP(33104, 2, 4096, 288, ":N-DELETE-RSP[pcid="),
    C_CANCEL_RQ(4095, 0, 0, 288, ":C-CANCEL-RQ[pcid=");

    public static final Logger LOG;
    private final int commandField;
    private final int tagOfSOPClassUID;
    private final int tagOfSOPInstanceUID;
    private final int tagOfMessageID;
    private final String prompt;

    static {
        LOG = LoggerFactory.getLogger(Dimse.class);
    }

    private Dimse(int n2, int n3, int n4, int n5, String string2) {
        this.commandField = n2;
        this.tagOfSOPClassUID = n3;
        this.tagOfSOPInstanceUID = n4;
        this.tagOfMessageID = n5;
        this.prompt = string2;
    }

    public int commandField() {
        return this.commandField;
    }

    public int tagOfSOPClassUID() {
        return this.tagOfSOPClassUID;
    }

    public int tagOfSOPInstanceUID() {
        return this.tagOfSOPInstanceUID;
    }

    public boolean isRSP() {
        return (this.commandField & 0x8000) != 0;
    }

    public boolean isRetrieveRQ() {
        return this == C_GET_RQ || this == C_MOVE_RQ;
    }

    public boolean isRetrieveRSP() {
        return this == C_GET_RSP || this == C_MOVE_RSP;
    }

    public boolean isCService() {
        return (this.commandField & 0x100) == 0;
    }

    public int commandFieldOfRSP() {
        return this.commandField | 0x8000;
    }

    public String toString(Attributes attributes, int n, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(attributes.getInt(this.tagOfMessageID, -1)).append(this.prompt).append(n);
        switch (this) {
            case C_STORE_RQ: {
                Dimse.promptIntTo(attributes, ", prior=", 1792, stringBuilder);
                Dimse.promptMoveOriginatorTo(attributes, stringBuilder);
                break;
            }
            case C_GET_RQ: {
                Dimse.promptIntTo(attributes, ", prior=", 1792, stringBuilder);
                Dimse.promptAttributeIdentifierListTo(attributes, stringBuilder);
                break;
            }
            case C_FIND_RQ: 
            case C_MOVE_RQ: {
                Dimse.promptIntTo(attributes, ", prior=", 1792, stringBuilder);
                break;
            }
            case C_GET_RSP: 
            case C_MOVE_RSP: {
                Dimse.promptNumberOfSubOpsTo(attributes, stringBuilder);
                break;
            }
            case N_EVENT_REPORT_RQ: 
            case N_EVENT_REPORT_RSP: {
                Dimse.promptIntTo(attributes, ", eventID=", 4098, stringBuilder);
                break;
            }
            case N_ACTION_RQ: 
            case N_ACTION_RSP: {
                Dimse.promptIntTo(attributes, ", actionID=", 4104, stringBuilder);
            }
        }
        if (this.isRSP()) {
            stringBuilder.append(", status=").append(Integer.toHexString(attributes.getInt(2304, -1))).append('H');
            Dimse.promptIntTo(attributes, ", errorID=", 2307, stringBuilder);
            Dimse.promptStringTo(attributes, ", errorComment=", 2306, stringBuilder);
            Dimse.promptAttributeIdentifierListTo(attributes, stringBuilder);
        }
        Dimse.promptUIDTo(attributes, "  cuid=", this.tagOfSOPClassUID, stringBuilder);
        Dimse.promptUIDTo(attributes, "  iuid=", this.tagOfSOPInstanceUID, stringBuilder);
        Dimse.promptUIDTo("  tsuid=", string, stringBuilder);
        return stringBuilder.toString();
    }

    private static void promptIntTo(Attributes attributes, String string, int n, StringBuilder stringBuilder) {
        int n2 = attributes.getInt(n, 0);
        if (n2 != 0 || attributes.containsValue(n)) {
            stringBuilder.append(string).append(n2);
        }
    }

    private static void promptStringTo(Attributes attributes, String string, int n, StringBuilder stringBuilder) {
        String string2 = attributes.getString(n, null);
        if (string2 != null) {
            stringBuilder.append(string).append(string2);
        }
    }

    private static void promptUIDTo(Attributes attributes, String string, int n, StringBuilder stringBuilder) {
        String string2;
        if (n != 0 && (string2 = attributes.getString(n, null)) != null) {
            Dimse.promptUIDTo(string, string2, stringBuilder);
        }
    }

    private static void promptUIDTo(String string, String string2, StringBuilder stringBuilder) {
        stringBuilder.append(StringUtils.LINE_SEPARATOR).append(string);
        UIDUtils.promptTo(string2, stringBuilder);
    }

    private static void promptMoveOriginatorTo(Attributes attributes, StringBuilder stringBuilder) {
        String string = attributes.getString(4144, null);
        if (string != null) {
            stringBuilder.append(StringUtils.LINE_SEPARATOR).append("  orig=").append(string).append(" >> ").append(attributes.getInt(4145, -1)).append(":C-MOVE-RQ");
        }
    }

    private static void promptAttributeIdentifierListTo(Attributes attributes, StringBuilder stringBuilder) {
        int[] nArray = attributes.getInts(4101);
        if (nArray == null) {
            return;
        }
        stringBuilder.append(StringUtils.LINE_SEPARATOR).append("  tags=[");
        if (nArray.length > 0) {
            int[] nArray2 = nArray;
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = nArray2[n2];
                stringBuilder.append(TagUtils.toString(n3)).append(", ");
                ++n2;
            }
            stringBuilder.setLength(stringBuilder.length() - 2);
        }
        stringBuilder.append(']');
    }

    private static void promptNumberOfSubOpsTo(Attributes attributes, StringBuilder stringBuilder) {
        Dimse.promptIntTo(attributes, ", remaining=", 4128, stringBuilder);
        Dimse.promptIntTo(attributes, ", completed=", 4129, stringBuilder);
        Dimse.promptIntTo(attributes, ", failed=", 4130, stringBuilder);
        Dimse.promptIntTo(attributes, ", warning=", 4131, stringBuilder);
    }

    public static Dimse valueOf(String string) {
        return Enum.valueOf(Dimse.class, string);
    }
}

