/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net;

import java.io.IOException;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.DimseRQHandler;
import org.dcm4che3.net.UserIdentityNegotiator;
import org.dcm4che3.net.pdu.AAssociateAC;
import org.dcm4che3.net.pdu.AAssociateRJ;
import org.dcm4che3.net.pdu.AAssociateRQ;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.net.pdu.UserIdentityAC;

public class AssociationHandler {
    private UserIdentityNegotiator userIdNegotiator;

    public final UserIdentityNegotiator getUserIdNegotiator() {
        return this.userIdNegotiator;
    }

    public final void setUserIdNegotiator(UserIdentityNegotiator userIdentityNegotiator) {
        this.userIdNegotiator = userIdentityNegotiator;
    }

    protected AAssociateAC negotiate(Association association, AAssociateRQ aAssociateRQ) throws IOException {
        UserIdentityAC userIdentityAC;
        if ((aAssociateRQ.getProtocolVersion() & 1) == 0) {
            throw new AAssociateRJ(1, 2, 2);
        }
        if (!aAssociateRQ.getApplicationContext().equals("1.2.840.10008.3.1.1.1")) {
            throw new AAssociateRJ(1, 1, 2);
        }
        ApplicationEntity applicationEntity = association.getApplicationEntity();
        if (!(applicationEntity != null && applicationEntity.getConnections().contains(association.getConnection()) && applicationEntity.isInstalled() && applicationEntity.isAssociationAcceptor())) {
            throw new AAssociateRJ(1, 1, 7);
        }
        if (!applicationEntity.isAcceptedCallingAETitle(aAssociateRQ.getCallingAET())) {
            throw new AAssociateRJ(1, 1, 3);
        }
        UserIdentityAC userIdentityAC2 = userIdentityAC = this.getUserIdNegotiator() != null ? this.getUserIdNegotiator().negotiate(association, aAssociateRQ.getUserIdentityRQ()) : null;
        if (applicationEntity.getDevice().isLimitOfOpenAssociationsExceeded()) {
            throw new AAssociateRJ(2, 2, 2);
        }
        return this.makeAAssociateAC(association, aAssociateRQ, userIdentityAC);
    }

    protected AAssociateAC makeAAssociateAC(Association association, AAssociateRQ aAssociateRQ, UserIdentityAC userIdentityAC) throws IOException {
        AAssociateAC aAssociateAC = new AAssociateAC();
        aAssociateAC.setCalledAET(aAssociateRQ.getCalledAET());
        aAssociateAC.setCallingAET(aAssociateRQ.getCallingAET());
        Connection connection = association.getConnection();
        aAssociateAC.setMaxPDULength(connection.getReceivePDULength());
        aAssociateAC.setMaxOpsInvoked(Association.minZeroAsMax(aAssociateRQ.getMaxOpsInvoked(), connection.getMaxOpsPerformed()));
        aAssociateAC.setMaxOpsPerformed(Association.minZeroAsMax(aAssociateRQ.getMaxOpsPerformed(), connection.getMaxOpsInvoked()));
        aAssociateAC.setUserIdentityAC(userIdentityAC);
        ApplicationEntity applicationEntity = association.getApplicationEntity();
        for (PresentationContext presentationContext : aAssociateRQ.getPresentationContexts()) {
            aAssociateAC.addPresentationContext(applicationEntity.negotiate(aAssociateRQ, aAssociateAC, presentationContext));
        }
        return aAssociateAC;
    }

    protected void onClose(Association association) {
        DimseRQHandler dimseRQHandler = association.getApplicationEntity().getDimseRQHandler();
        if (dimseRQHandler != null) {
            dimseRQHandler.onClose(association);
        }
    }
}

