/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.media;

import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.io.ContentHandlerAdapter;
import org.dcm4che3.media.RecordType;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RecordFactory {
    private static final int IN_USE = 65535;
    private EnumMap<RecordType, int[]> recordKeys;
    private HashMap<String, RecordType> recordTypes;
    private HashMap<String, String> privateRecordUIDs;
    private HashMap<String, int[]> privateRecordKeys;

    private void lazyLoadDefaultConfiguration() {
        if (this.recordTypes == null) {
            this.loadDefaultConfiguration();
        }
    }

    public void loadDefaultConfiguration() {
        try {
            this.loadConfiguration(Thread.currentThread().getContextClassLoader().getResource("org/dcm4che3/media/RecordFactory.xml").toString());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void loadConfiguration(String string) throws ParserConfigurationException, SAXException, IOException {
        Serializable serializable2;
        Attributes attributes = this.parseXML(string);
        Sequence sequence = attributes.getSequence(266784);
        if (sequence == null) {
            throw new IllegalArgumentException("Missing Directory Record Sequence in " + string);
        }
        EnumMap<RecordType, int[]> enumMap = new EnumMap<RecordType, int[]>(RecordType.class);
        HashMap<int[], RecordType> hashMap = new HashMap<int[], RecordType>(134);
        HashMap<int[], String> hashMap2 = new HashMap<int[], String>();
        HashMap<String, int[]> hashMap3 = new HashMap<String, int[]>();
        for (Serializable serializable2 : sequence) {
            Object object;
            RecordType recordType = RecordType.forCode(((Attributes)serializable2).getString(267312, null));
            String string2 = recordType == RecordType.PRIVATE ? ((Attributes)serializable2).getString(267314, null) : null;
            String[] stringArray = ((Attributes)serializable2).getStrings(267536);
            if (stringArray != null) {
                int n;
                int n2;
                String[] stringArray2;
                if (recordType != RecordType.PRIVATE) {
                    stringArray2 = stringArray;
                    n2 = stringArray.length;
                    n = 0;
                    while (n < n2) {
                        object = stringArray2[n];
                        hashMap.put((int[])object, recordType);
                        ++n;
                    }
                } else if (string2 != null) {
                    stringArray2 = stringArray;
                    n2 = stringArray.length;
                    n = 0;
                    while (n < n2) {
                        object = stringArray2[n];
                        hashMap2.put((int[])object, string2);
                        ++n;
                    }
                }
            }
            ((Attributes)serializable2).remove(267312);
            ((Attributes)serializable2).remove(267314);
            ((Attributes)serializable2).remove(267536);
            object = ((Attributes)serializable2).tags();
            if (string2 != null) {
                if (hashMap3.put(string2, (int[])object) == null) continue;
                throw new IllegalArgumentException("Duplicate Private Record UID: " + string2);
            }
            if (enumMap.put(recordType, (int[])object) == null) continue;
            throw new IllegalArgumentException("Duplicate Record Type: " + (Object)((Object)recordType));
        }
        serializable2 = EnumSet.allOf(RecordType.class);
        ((AbstractSet)((Object)serializable2)).removeAll(enumMap.keySet());
        if (!((AbstractCollection)((Object)serializable2)).isEmpty()) {
            throw new IllegalArgumentException("Missing Record Types: " + serializable2);
        }
        this.recordTypes = hashMap;
        this.recordKeys = enumMap;
        this.privateRecordUIDs = hashMap2;
        this.privateRecordKeys = hashMap3;
    }

    private Attributes parseXML(String string) throws ParserConfigurationException, SAXException, IOException {
        Attributes attributes = new Attributes();
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        sAXParser.parse(string, (DefaultHandler)new ContentHandlerAdapter(attributes));
        return attributes;
    }

    public RecordType getRecordType(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.lazyLoadDefaultConfiguration();
        RecordType recordType = this.recordTypes.get(string);
        return recordType != null ? recordType : RecordType.PRIVATE;
    }

    public RecordType setRecordType(String string, RecordType recordType) {
        if (string == null || recordType == null) {
            throw new NullPointerException();
        }
        this.lazyLoadDefaultConfiguration();
        return this.recordTypes.put(string, recordType);
    }

    public void setRecordKeys(RecordType recordType, int[] nArray) {
        if (recordType == null) {
            throw new NullPointerException();
        }
        int[] nArray2 = (int[])nArray.clone();
        Arrays.sort(nArray2);
        this.lazyLoadDefaultConfiguration();
        this.recordKeys.put(recordType, nArray);
    }

    public String getPrivateRecordUID(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.lazyLoadDefaultConfiguration();
        String string2 = this.privateRecordUIDs.get(string);
        return string2 != null ? string2 : string;
    }

    public String setPrivateRecordUID(String string, String string2) {
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        this.lazyLoadDefaultConfiguration();
        return this.privateRecordUIDs.put(string, string2);
    }

    public int[] setPrivateRecordKeys(String string, int[] nArray) {
        if (string == null) {
            throw new NullPointerException();
        }
        int[] nArray2 = (int[])nArray.clone();
        Arrays.sort(nArray2);
        this.lazyLoadDefaultConfiguration();
        return this.privateRecordKeys.put(string, nArray2);
    }

    public Attributes createRecord(Attributes attributes, Attributes attributes2, String[] stringArray) {
        RecordType recordType;
        String string = attributes2.getString(131074, null);
        return this.createRecord(recordType, (recordType = this.getRecordType(string)) == RecordType.PRIVATE ? this.getPrivateRecordUID(string) : null, attributes, attributes2, stringArray);
    }

    public Attributes createRecord(RecordType recordType, String string, Attributes attributes, Attributes attributes2, String[] stringArray) {
        if (recordType == null) {
            throw new NullPointerException("type");
        }
        if (attributes == null) {
            throw new NullPointerException("dataset");
        }
        this.lazyLoadDefaultConfiguration();
        int[] nArray = null;
        if (recordType == RecordType.PRIVATE) {
            if (string == null) {
                throw new NullPointerException("privRecUID must not be null for type = PRIVATE");
            }
            nArray = this.privateRecordKeys.get(string);
        } else if (string != null) {
            throw new IllegalArgumentException("privRecUID must be null for type != PRIVATE");
        }
        if (nArray == null) {
            nArray = this.recordKeys.get((Object)recordType);
        }
        Attributes attributes3 = new Attributes(nArray.length + (stringArray != null ? 9 : 5));
        attributes3.setInt(267264, VR.UL, 0);
        attributes3.setInt(267280, VR.US, 65535);
        attributes3.setInt(267296, VR.UL, 0);
        attributes3.setString(267312, VR.CS, recordType.code());
        if (string != null) {
            attributes3.setString(267314, VR.UI, string);
        }
        if (stringArray != null) {
            attributes3.setString(267520, VR.CS, stringArray);
            attributes3.setString(267536, VR.UI, attributes2.getString(131074, null));
            attributes3.setString(267537, VR.UI, attributes2.getString(131075, null));
            attributes3.setString(267538, VR.UI, attributes2.getString(131088, null));
        }
        attributes3.addSelected(attributes, nArray, 0, nArray.length);
        Sequence sequence = attributes.getSequence(4237104);
        if (sequence != null) {
            this.copyConceptMod(sequence, attributes3);
        }
        return attributes3;
    }

    private void copyConceptMod(Sequence sequence, Attributes attributes) {
        Sequence sequence2 = null;
        for (Attributes attributes2 : sequence) {
            if (!"HAS CONCEPT MOD".equals(attributes2.getString(4235280, null))) continue;
            if (sequence2 == null) {
                sequence2 = attributes.newSequence(4237104, 1);
            }
            sequence2.add(new Attributes(attributes2, false));
        }
    }
}

