/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.media;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.io.DicomEncodingOptions;
import org.dcm4che3.io.DicomOutputStream;
import org.dcm4che3.io.RAFOutputStreamAdapter;
import org.dcm4che3.media.DicomDirReader;
import org.dcm4che3.util.ByteUtils;
import org.dcm4che3.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DicomDirWriter
extends DicomDirReader {
    private static final Logger LOG = LoggerFactory.getLogger(DicomDirWriter.class);
    private static final int KNOWN_INCONSISTENCIES = 65535;
    private static final int NO_KNOWN_INCONSISTENCIES = 0;
    private static final int IN_USE = 65535;
    private static final int INACTIVE = 0;
    private final byte[] dirInfoHeader;
    private final byte[] dirRecordHeader;
    private final DicomOutputStream out;
    private final int firstRecordPos;
    private int nextRecordPos;
    private int rollbackLen;
    private IdentityHashMap<Attributes, Attributes> lastChildRecords;
    private final ArrayList<Attributes> dirtyRecords;
    private static final Comparator<Attributes> offsetComparator = new Comparator<Attributes>(){

        @Override
        public int compare(Attributes attributes, Attributes attributes2) {
            long l = attributes.getItemPosition() - attributes2.getItemPosition();
            return l < 0L ? -1 : (l > 0L ? 1 : 0);
        }
    };

    private DicomDirWriter(File file) throws IOException {
        super(file, "rw");
        byte[] byArray = new byte[46];
        byArray[0] = 4;
        byArray[3] = 18;
        byArray[4] = 85;
        byArray[5] = 76;
        byArray[6] = 4;
        byArray[12] = 4;
        byArray[14] = 2;
        byArray[15] = 18;
        byArray[16] = 85;
        byArray[17] = 76;
        byArray[18] = 4;
        byArray[24] = 4;
        byArray[26] = 18;
        byArray[27] = 18;
        byArray[28] = 85;
        byArray[29] = 83;
        byArray[30] = 2;
        byArray[34] = 4;
        byArray[36] = 32;
        byArray[37] = 18;
        byArray[38] = 83;
        byArray[39] = 81;
        this.dirInfoHeader = byArray;
        byte[] byArray2 = new byte[34];
        byArray2[0] = 4;
        byArray2[3] = 20;
        byArray2[4] = 85;
        byArray2[5] = 76;
        byArray2[6] = 4;
        byArray2[12] = 4;
        byArray2[14] = 16;
        byArray2[15] = 20;
        byArray2[16] = 85;
        byArray2[17] = 83;
        byArray2[18] = 2;
        byArray2[22] = 4;
        byArray2[24] = 32;
        byArray2[25] = 20;
        byArray2[26] = 85;
        byArray2[27] = 76;
        byArray2[28] = 4;
        this.dirRecordHeader = byArray2;
        this.rollbackLen = -1;
        this.lastChildRecords = new IdentityHashMap();
        this.dirtyRecords = new ArrayList();
        this.out = new DicomOutputStream(new RAFOutputStreamAdapter(this.raf), super.getTransferSyntaxUID());
        int n = this.in.length();
        boolean bl = n <= 0;
        this.setEncodingOptions(new DicomEncodingOptions(false, bl, false, bl, false));
        this.nextRecordPos = this.firstRecordPos = (int)this.in.getPosition();
        if (!this.isEmpty()) {
            this.nextRecordPos = n > 0 ? (this.nextRecordPos += n) : (int)(this.raf.length() - 12L);
        }
        this.updateDirInfoHeader();
    }

    public DicomEncodingOptions getEncodingOptions() {
        return this.out.getEncodingOptions();
    }

    public void setEncodingOptions(DicomEncodingOptions dicomEncodingOptions) {
        this.out.setEncodingOptions(dicomEncodingOptions);
    }

    public static DicomDirWriter open(File file) throws IOException {
        if (!file.isFile()) {
            throw new FileNotFoundException();
        }
        return new DicomDirWriter(file);
    }

    public static void createEmptyDirectory(File file, String string, String string2, File file2, String string3) throws IOException {
        Attributes attributes = Attributes.createFileMetaInformation(string, "1.2.840.10008.1.3.10", "1.2.840.10008.1.2.1");
        DicomDirWriter.createEmptyDirectory(file, attributes, string2, file2, string3);
    }

    public static void createEmptyDirectory(File file, Attributes attributes, String string, File file2, String string2) throws IOException {
        Attributes attributes2 = DicomDirWriter.createFileSetInformation(file, string, file2, string2);
        DicomOutputStream dicomOutputStream = new DicomOutputStream(file);
        try {
            dicomOutputStream.writeDataset(attributes, attributes2);
        }
        finally {
            dicomOutputStream.close();
        }
    }

    private static Attributes createFileSetInformation(File file, String string, File file2, String string2) {
        Attributes attributes = new Attributes(7);
        attributes.setString(266544, VR.CS, string);
        if (file2 != null) {
            attributes.setString(266561, VR.CS, DicomDirWriter.toFileIDs(file, file2));
            if (string2 != null && !string2.isEmpty()) {
                attributes.setString(266562, VR.CS, string2);
            }
        }
        attributes.setInt(266752, VR.UL, 0);
        attributes.setInt(266754, VR.UL, 0);
        attributes.setInt(266770, VR.US, 0);
        attributes.setNull(266784, VR.SQ);
        return attributes;
    }

    public synchronized Attributes addRootDirectoryRecord(Attributes attributes) throws IOException {
        Attributes attributes2 = this.readLastRootDirectoryRecord();
        if (attributes2 == null) {
            this.writeRecord(this.firstRecordPos, attributes);
            this.setOffsetOfFirstRootDirectoryRecord(this.firstRecordPos);
        } else {
            this.addRecord(267264, attributes2, attributes);
        }
        this.setOffsetOfLastRootDirectoryRecord((int)attributes.getItemPosition());
        return attributes;
    }

    public synchronized Attributes addLowerDirectoryRecord(Attributes attributes, Attributes attributes2) throws IOException {
        Attributes attributes3 = this.lastChildRecords.get(attributes);
        if (attributes3 == null) {
            attributes3 = this.findLastLowerDirectoryRecord(attributes);
        }
        if (attributes3 != null) {
            this.addRecord(267264, attributes3, attributes2);
        } else {
            this.addRecord(267296, attributes, attributes2);
        }
        this.lastChildRecords.put(attributes, attributes2);
        return attributes2;
    }

    public synchronized Attributes findOrAddPatientRecord(Attributes attributes) throws IOException {
        Attributes attributes2 = super.findPatientRecord(attributes.getString(0x100020));
        return attributes2 != null ? attributes2 : this.addRootDirectoryRecord(attributes);
    }

    public synchronized Attributes findOrAddStudyRecord(Attributes attributes, Attributes attributes2) throws IOException {
        Attributes attributes3 = super.findStudyRecord(attributes, attributes2.getString(0x20000D));
        return attributes3 != null ? attributes3 : this.addLowerDirectoryRecord(attributes, attributes2);
    }

    public synchronized Attributes findOrAddSeriesRecord(Attributes attributes, Attributes attributes2) throws IOException {
        Attributes attributes3 = super.findSeriesRecord(attributes, attributes2.getString(0x20000E));
        return attributes3 != null ? attributes3 : this.addLowerDirectoryRecord(attributes, attributes2);
    }

    public synchronized boolean deleteRecord(Attributes attributes) throws IOException {
        if (attributes.getInt(267280, 0) == 0) {
            return false;
        }
        Attributes attributes2 = this.readLowerDirectoryRecord(attributes);
        while (attributes2 != null) {
            this.deleteRecord(attributes2);
            attributes2 = this.readNextDirectoryRecord(attributes2);
        }
        attributes.setInt(267280, VR.US, 0);
        this.markAsDirty(attributes);
        return true;
    }

    public synchronized void rollback() throws IOException {
        if (this.dirtyRecords.isEmpty()) {
            return;
        }
        this.clearCache();
        this.dirtyRecords.clear();
        if (this.rollbackLen != -1) {
            this.restoreDirInfo();
            this.nextRecordPos = this.rollbackLen;
            if (this.getEncodingOptions().undefSequenceLength) {
                this.writeSequenceDelimitationItem();
                this.raf.setLength(this.raf.getFilePointer());
            } else {
                this.raf.setLength(this.rollbackLen);
            }
            this.writeFileSetConsistencyFlag(0);
            this.rollbackLen = -1;
        }
    }

    @Override
    public void clearCache() {
        this.lastChildRecords.clear();
        super.clearCache();
    }

    public synchronized void commit() throws IOException {
        if (this.dirtyRecords.isEmpty()) {
            return;
        }
        if (this.rollbackLen == -1) {
            this.writeFileSetConsistencyFlag(65535);
        }
        for (Attributes attributes : this.dirtyRecords) {
            this.writeDirRecordHeader(attributes);
        }
        this.dirtyRecords.clear();
        if (this.rollbackLen != -1 && this.getEncodingOptions().undefSequenceLength) {
            this.writeSequenceDelimitationItem();
        }
        this.writeDirInfoHeader();
        this.rollbackLen = -1;
    }

    @Override
    public void close() throws IOException {
        this.commit();
        super.close();
    }

    public String[] toFileIDs(File file) {
        return DicomDirWriter.toFileIDs(this.file, file);
    }

    private static String[] toFileIDs(File file, File file2) {
        String string = file.getAbsolutePath();
        int n = string.lastIndexOf(File.separatorChar) + 1;
        String string2 = string.substring(0, n);
        String string3 = file2.getAbsolutePath();
        if (n == 0 || !string3.startsWith(string2)) {
            throw new IllegalArgumentException("file: " + string3 + " not in directory: " + file.getAbsoluteFile());
        }
        return StringUtils.split(string3.substring(n), File.separatorChar);
    }

    private void updateDirInfoHeader() {
        ByteUtils.intToBytesLE(this.getOffsetOfFirstRootDirectoryRecord(), this.dirInfoHeader, 8);
        ByteUtils.intToBytesLE(this.getOffsetOfLastRootDirectoryRecord(), this.dirInfoHeader, 20);
        ByteUtils.intToBytesLE(this.getEncodingOptions().undefSequenceLength ? -1 : this.nextRecordPos - this.firstRecordPos, this.dirInfoHeader, 42);
    }

    private void restoreDirInfo() {
        this.setOffsetOfFirstRootDirectoryRecord(ByteUtils.bytesToIntLE(this.dirInfoHeader, 8));
        this.setOffsetOfLastRootDirectoryRecord(ByteUtils.bytesToIntLE(this.dirInfoHeader, 20));
    }

    private void writeDirInfoHeader() throws IOException {
        this.updateDirInfoHeader();
        this.raf.seek(this.firstRecordPos - this.dirInfoHeader.length);
        this.raf.write(this.dirInfoHeader);
    }

    private void writeDirRecordHeader(Attributes attributes) throws IOException {
        ByteUtils.intToBytesLE(attributes.getInt(267264, 0), this.dirRecordHeader, 8);
        ByteUtils.shortToBytesLE(attributes.getInt(267280, 0), this.dirRecordHeader, 20);
        ByteUtils.intToBytesLE(attributes.getInt(267296, 0), this.dirRecordHeader, 30);
        this.raf.seek(attributes.getItemPosition() + 8L);
        this.raf.write(this.dirRecordHeader);
    }

    private void writeSequenceDelimitationItem() throws IOException {
        this.raf.seek(this.nextRecordPos);
        this.out.writeHeader(-73507, null, 0);
    }

    private void addRecord(int n, Attributes attributes, Attributes attributes2) throws IOException {
        attributes.setInt(n, VR.UL, this.nextRecordPos);
        this.markAsDirty(attributes);
        this.writeRecord(this.nextRecordPos, attributes2);
    }

    private void writeRecord(int n, Attributes attributes) throws IOException {
        if (LOG.isInfoEnabled()) {
            LOG.info("M-UPDATE {}: add {} Record", (Object)this.file, (Object)attributes.getString(267312, null));
        }
        LOG.debug("Directory Record:\n{}", (Object)attributes);
        attributes.setItemPosition(n);
        if (this.rollbackLen == -1) {
            this.rollbackLen = n;
            this.writeFileSetConsistencyFlag(65535);
        }
        this.raf.seek(n);
        attributes.setInt(267264, VR.UL, 0);
        attributes.setInt(267280, VR.US, 65535);
        attributes.setInt(267296, VR.UL, 0);
        attributes.writeItemTo(this.out);
        this.nextRecordPos = (int)this.raf.getFilePointer();
        this.cache.put(n, attributes);
    }

    private void writeFileSetConsistencyFlag(int n) throws IOException {
        this.raf.seek(this.firstRecordPos - 14);
        this.raf.writeShort(n);
        this.setFileSetConsistencyFlag(n);
    }

    private void markAsDirty(Attributes attributes) {
        int n = Collections.binarySearch(this.dirtyRecords, attributes, offsetComparator);
        if (n < 0) {
            this.dirtyRecords.add(-(n + 1), attributes);
        }
    }

    public synchronized int purge() throws IOException {
        int[] nArray = new int[1];
        this.purge(this.findFirstRootDirectoryRecordInUse(false), nArray);
        return nArray[0];
    }

    private boolean purge(Attributes attributes, int[] nArray) throws IOException {
        boolean bl = true;
        while (attributes != null) {
            if (this.purge(this.findLowerDirectoryRecordInUse(attributes, false), nArray) && !attributes.containsValue(267520)) {
                this.deleteRecord(attributes);
                nArray[0] = nArray[0] + 1;
            } else {
                bl = false;
            }
            attributes = this.readNextDirectoryRecord(attributes);
        }
        return bl;
    }
}

