/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.media;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.io.RAFInputStreamAdapter;
import org.dcm4che3.util.IntHashMap;
import org.dcm4che3.util.SafeClose;
import org.dcm4che3.util.StringUtils;

public class DicomDirReader
implements Closeable {
    protected final File file;
    protected final RandomAccessFile raf;
    protected final DicomInputStream in;
    protected final Attributes fmi;
    protected final Attributes fsInfo;
    protected final IntHashMap<Attributes> cache = new IntHashMap();

    public DicomDirReader(File file) throws IOException {
        this(file, "r");
    }

    protected DicomDirReader(File file, String string) throws IOException {
        this.file = file;
        this.raf = new RandomAccessFile(file, string);
        try {
            this.in = new DicomInputStream(new RAFInputStreamAdapter(this.raf));
            this.fmi = this.in.readFileMetaInformation();
            this.fsInfo = this.in.readDataset(-1, 266784);
            if (this.in.tag() != 266784) {
                throw new IOException("Missing Directory Record Sequence");
            }
        }
        catch (IOException iOException) {
            SafeClose.close(this.raf);
            throw iOException;
        }
    }

    public final File getFile() {
        return this.file;
    }

    public final Attributes getFileMetaInformation() {
        return this.fmi;
    }

    public final Attributes getFileSetInformation() {
        return this.fsInfo;
    }

    @Override
    public void close() throws IOException {
        this.raf.close();
    }

    public String getFileSetUID() {
        return this.fmi.getString(131075, null);
    }

    public String getTransferSyntaxUID() {
        return this.fmi.getString(131088, null);
    }

    public String getFileSetID() {
        return this.fsInfo.getString(266544, null);
    }

    public File getDescriptorFile() {
        return this.toFile(this.fsInfo.getStrings(266561));
    }

    public File toFile(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        return new File(this.file.getParent(), StringUtils.concat(stringArray, File.separatorChar));
    }

    public String getDescriptorFileCharacterSet() {
        return this.fsInfo.getString(266562, null);
    }

    public int getFileSetConsistencyFlag() {
        return this.fsInfo.getInt(266770, 0);
    }

    protected void setFileSetConsistencyFlag(int n) {
        this.fsInfo.setInt(266770, VR.US, n);
    }

    public boolean knownInconsistencies() {
        return this.getFileSetConsistencyFlag() != 0;
    }

    public int getOffsetOfFirstRootDirectoryRecord() {
        return this.fsInfo.getInt(266752, 0);
    }

    protected void setOffsetOfFirstRootDirectoryRecord(int n) {
        this.fsInfo.setInt(266752, VR.UL, n);
    }

    public int getOffsetOfLastRootDirectoryRecord() {
        return this.fsInfo.getInt(266754, 0);
    }

    protected void setOffsetOfLastRootDirectoryRecord(int n) {
        this.fsInfo.setInt(266754, VR.UL, n);
    }

    public boolean isEmpty() {
        return this.getOffsetOfFirstRootDirectoryRecord() == 0;
    }

    public void clearCache() {
        this.cache.clear();
    }

    public Attributes readFirstRootDirectoryRecord() throws IOException {
        return this.readRecord(this.getOffsetOfFirstRootDirectoryRecord());
    }

    public Attributes readLastRootDirectoryRecord() throws IOException {
        return this.readRecord(this.getOffsetOfLastRootDirectoryRecord());
    }

    public Attributes readNextDirectoryRecord(Attributes attributes) throws IOException {
        return this.readRecord(attributes.getInt(267264, 0));
    }

    public Attributes readLowerDirectoryRecord(Attributes attributes) throws IOException {
        return this.readRecord(attributes.getInt(267296, 0));
    }

    /*
     * Unable to fully structure code
     */
    protected Attributes findLastLowerDirectoryRecord(Attributes var1_1) throws IOException {
        var2_2 = this.readLowerDirectoryRecord(var1_1);
        if (var2_2 != null) ** GOTO lbl5
        return null;
lbl-1000:
        // 1 sources

        {
            var2_2 = var3_3;
lbl5:
            // 2 sources

            ** while ((var3_3 = this.readNextDirectoryRecord((Attributes)var2_2)) != null)
        }
lbl6:
        // 1 sources

        return var2_2;
    }

    public Attributes findFirstRootDirectoryRecordInUse(boolean bl) throws IOException {
        return this.findRootDirectoryRecord(bl, null, false, false);
    }

    public Attributes findRootDirectoryRecord(Attributes attributes, boolean bl, boolean bl2, boolean bl3) throws IOException {
        return this.findRecordInUse(this.getOffsetOfFirstRootDirectoryRecord(), bl, attributes, bl2, bl3);
    }

    public Attributes findRootDirectoryRecord(boolean bl, Attributes attributes, boolean bl2, boolean bl3) throws IOException {
        return this.findRootDirectoryRecord(attributes, bl, bl2, bl3);
    }

    public Attributes findNextDirectoryRecordInUse(Attributes attributes, boolean bl) throws IOException {
        return this.findNextDirectoryRecord(attributes, bl, null, false, false);
    }

    public Attributes findNextDirectoryRecord(Attributes attributes, boolean bl, Attributes attributes2, boolean bl2, boolean bl3) throws IOException {
        return this.findRecordInUse(attributes.getInt(267264, 0), bl, attributes2, bl2, bl3);
    }

    public Attributes findLowerDirectoryRecordInUse(Attributes attributes, boolean bl) throws IOException {
        return this.findLowerDirectoryRecord(attributes, bl, null, false, false);
    }

    public Attributes findLowerDirectoryRecord(Attributes attributes, boolean bl, Attributes attributes2, boolean bl2, boolean bl3) throws IOException {
        return this.findRecordInUse(attributes.getInt(267296, 0), bl, attributes2, bl2, bl3);
    }

    public Attributes findPatientRecord(String ... stringArray) throws IOException {
        return this.findRootDirectoryRecord(false, this.pk("PATIENT", 0x100020, VR.LO, stringArray), false, false);
    }

    public Attributes findNextPatientRecord(Attributes attributes, String ... stringArray) throws IOException {
        return this.findNextDirectoryRecord(attributes, false, this.pk("PATIENT", 0x100020, VR.LO, stringArray), false, false);
    }

    public Attributes findStudyRecord(Attributes attributes, String ... stringArray) throws IOException {
        return this.findLowerDirectoryRecord(attributes, false, this.pk("STUDY", 0x20000D, VR.UI, stringArray), false, false);
    }

    public Attributes findNextStudyRecord(Attributes attributes, String ... stringArray) throws IOException {
        return this.findNextDirectoryRecord(attributes, false, this.pk("STUDY", 0x20000D, VR.UI, stringArray), false, false);
    }

    public Attributes findSeriesRecord(Attributes attributes, String ... stringArray) throws IOException {
        return this.findLowerDirectoryRecord(attributes, false, this.pk("SERIES", 0x20000E, VR.UI, stringArray), false, false);
    }

    public Attributes findNextSeriesRecord(Attributes attributes, String ... stringArray) throws IOException {
        return this.findNextDirectoryRecord(attributes, false, this.pk("SERIES", 0x20000E, VR.UI, stringArray), false, false);
    }

    public Attributes findLowerInstanceRecord(Attributes attributes, boolean bl, String ... stringArray) throws IOException {
        return this.findLowerDirectoryRecord(attributes, bl, this.pk(stringArray), false, false);
    }

    public Attributes findNextInstanceRecord(Attributes attributes, boolean bl, String ... stringArray) throws IOException {
        return this.findNextDirectoryRecord(attributes, bl, this.pk(stringArray), false, false);
    }

    public Attributes findRootInstanceRecord(boolean bl, String ... stringArray) throws IOException {
        return this.findRootDirectoryRecord(bl, this.pk(stringArray), false, false);
    }

    private Attributes pk(String string, int n, VR vR, String ... stringArray) {
        Attributes attributes = new Attributes(2);
        attributes.setString(267312, VR.CS, string);
        if (stringArray != null && stringArray.length != 0) {
            attributes.setString(n, vR, stringArray);
        }
        return attributes;
    }

    private Attributes pk(String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        Attributes attributes = new Attributes(1);
        attributes.setString(267537, VR.UI, stringArray);
        return attributes;
    }

    private Attributes findRecordInUse(int n, boolean bl, Attributes attributes, boolean bl2, boolean bl3) throws IOException {
        while (n != 0) {
            Attributes attributes2 = this.readRecord(n);
            if (!(!DicomDirReader.inUse(attributes2) || bl && DicomDirReader.isPrivate(attributes2) || attributes != null && !attributes2.matches(attributes, bl2, bl3))) {
                return attributes2;
            }
            n = attributes2.getInt(267264, 0);
        }
        return null;
    }

    private synchronized Attributes readRecord(int n) throws IOException {
        if (n == 0) {
            return null;
        }
        Attributes attributes = this.cache.get(n);
        if (attributes == null) {
            long l = (long)n & 0xFFFFFFFFL;
            this.raf.seek(l);
            this.in.setPosition(l);
            attributes = this.in.readItem();
            this.cache.put(n, attributes);
        }
        return attributes;
    }

    public static boolean inUse(Attributes attributes) {
        return attributes.getInt(267280, 0) != 0;
    }

    public static boolean isPrivate(Attributes attributes) {
        return "PRIVATE".equals(attributes.getString(267312));
    }
}

